/*
 * Decompiled with CFR 0.152.
 */
package com.github.i.fuzzybanksearch;

import com.github.i.fuzzybanksearch.FuzzyBankSearchConfig;
import com.github.i.fuzzybanksearch.matcher.FZFMatcher;
import com.github.i.fuzzybanksearch.matcher.JaroWinklerMatcher;
import com.github.i.fuzzybanksearch.matcher.Matcher;
import com.google.inject.Provides;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.ItemComposition;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.ScriptCallbackEvent;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.bank.BankSearch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Fuzzy Bank Search")
public class FuzzyBankSearchPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(FuzzyBankSearchPlugin.class);
    @Inject
    private Client client;
    @Inject
    private FuzzyBankSearchConfig config;
    @Inject
    private KeyManager keyManager;
    @Inject
    BankSearch bankSearch;
    @Inject
    ItemManager itemManager;
    private static final String BANK_SEARCH_FILTER_EVENT = "bankSearchFilter";
    String oldQuery = "";
    Set<String> cachedResults = null;
    private Matcher fzfMatcher = null;
    private Matcher jaroWinklerMatcher = null;
    private Map<Integer, String> itemIdsToNames = null;
    private final KeyListener searchHotkeyListener = new KeyListener(){

        public void keyPressed(KeyEvent e) {
            Widget bankContainer;
            if (FuzzyBankSearchPlugin.this.config.hotkey().matches(e) && (bankContainer = FuzzyBankSearchPlugin.this.client.getWidget(WidgetInfo.BANK_ITEM_CONTAINER)) != null && !bankContainer.isSelfHidden()) {
                FuzzyBankSearchPlugin.this.bankSearch.initSearch();
                e.consume();
            }
        }

        public void keyTyped(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
        }
    };

    protected void startUp() {
        this.keyManager.registerKeyListener(this.searchHotkeyListener);
    }

    protected void shutDown() {
        this.keyManager.unregisterKeyListener(this.searchHotkeyListener);
    }

    @Provides
    FuzzyBankSearchConfig provideConfig(ConfigManager configManager) {
        return (FuzzyBankSearchConfig)configManager.getConfig(FuzzyBankSearchConfig.class);
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        if (event.getContainerId() == InventoryID.BANK.getId()) {
            this.itemIdsToNames = Arrays.stream(this.client.getItemContainer(InventoryID.BANK).getItems()).map(item -> this.itemManager.getItemComposition(item.getId())).collect(Collectors.toMap(ItemComposition::getId, ItemComposition::getName, (x, __) -> x));
            this.fzfMatcher = new FZFMatcher(this.itemIdsToNames.values());
            this.jaroWinklerMatcher = new JaroWinklerMatcher(this.itemIdsToNames.values());
        }
    }

    public boolean filterBankSearch(int itemId, String query) {
        if (!this.oldQuery.equals(query) || this.cachedResults == null) {
            Matcher matcher = this.config.useFzf() ? this.fzfMatcher : this.jaroWinklerMatcher;
            this.cachedResults = matcher.match(query, this.config.limit());
            this.oldQuery = query;
        }
        return this.cachedResults.contains(this.itemIdsToNames.get(itemId));
    }

    @Subscribe
    public void onScriptCallbackEvent(ScriptCallbackEvent event) {
        int[] intStack = this.client.getIntStack();
        String[] stringStack = this.client.getStringStack();
        int intStackSize = this.client.getIntStackSize();
        int stringStackSize = this.client.getStringStackSize();
        if (event.getEventName().equals(BANK_SEARCH_FILTER_EVENT)) {
            int itemId = intStack[intStackSize - 1];
            String query = stringStack[stringStackSize - 1];
            intStack[intStackSize - 2] = this.filterBankSearch(itemId, query) ? 1 : 0;
        }
    }
}

