/*
 * Decompiled with CFR 0.152.
 */
package com.offlineChatIcon;

import java.awt.image.BufferedImage;
import java.util.Arrays;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.IndexedSprite;
import net.runelite.api.IterableHashTable;
import net.runelite.api.MessageNode;
import net.runelite.api.clan.ClanChannelMember;
import net.runelite.api.events.ClanMemberJoined;
import net.runelite.api.events.ClanMemberLeft;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Offline Chat Icon")
public class OfflineChatIconPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(OfflineChatIconPlugin.class);
    @Inject
    private Client client;
    private int offlineIconLocation = -1;
    private String iconImg;
    @Inject
    private ClientThread clientThread;

    protected void startUp() throws Exception {
        this.clientThread.invoke(() -> {
            if (this.client.getModIcons() == null) {
                return false;
            }
            this.loadIcon();
            return true;
        });
    }

    @Subscribe
    public void onClanMemberJoined(ClanMemberJoined clanMemberJoined) {
        ClanChannelMember member = clanMemberJoined.getClanMember();
        this.rebuildChat(member.getName(), false);
    }

    @Subscribe
    public void onClanMemberLeft(ClanMemberLeft clanMemberLeft) {
        ClanChannelMember member = clanMemberLeft.getClanMember();
        this.rebuildChat(member.getName(), true);
    }

    private void loadIcon() {
        IndexedSprite[] modIcons = this.client.getModIcons();
        if (this.offlineIconLocation != -1 || modIcons == null) {
            return;
        }
        BufferedImage image = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/logout_icon.png");
        IndexedSprite indexedSprite = ImageUtil.getImageIndexedSprite((BufferedImage)image, (Client)this.client);
        this.offlineIconLocation = modIcons.length;
        IndexedSprite[] newModIcons = Arrays.copyOf(modIcons, modIcons.length + 1);
        newModIcons[newModIcons.length - 1] = indexedSprite;
        this.client.setModIcons(newModIcons);
        this.iconImg = "<img=" + this.offlineIconLocation + ">";
    }

    private void rebuildChat(String rsn, Boolean addIcon) {
        boolean needRefreshing = false;
        IterableHashTable messages = this.client.getMessages();
        for (MessageNode message : messages) {
            String cleanRsnFromMessage = Text.standardize((String)Text.removeTags((String)message.getName()));
            String standardizedRsnFromEvent = Text.standardize((String)rsn);
            ChatMessageType messageType = message.getType();
            if (!cleanRsnFromMessage.equals(standardizedRsnFromEvent) || messageType != ChatMessageType.CLAN_CHAT && messageType != ChatMessageType.CLAN_GUEST_CHAT) continue;
            if (addIcon.booleanValue()) {
                message.setName(this.iconImg + message.getName());
            } else {
                message.setName(message.getName().replace(this.iconImg, ""));
            }
            needRefreshing = true;
        }
        if (needRefreshing) {
            this.client.refreshChat();
        }
    }
}

