/*
 * Decompiled with CFR 0.152.
 */
package com.animatedicons;

import com.google.common.collect.Sets;
import java.util.Set;

public enum Icon {
    DRAMEN_BRANCH(771),
    FIRE_CAPE(6570, 24223, 10566),
    INFERNAL_CAPE(21295, 24224, 21297, 23622),
    INFERNAL_MAX_CAPE(21284, 24133, 21285),
    MAGIC_LOGS(1513),
    MAGIC_PYRE_LOGS(3448),
    VOLCANIC_WHIP(12773),
    VOLCANIC_WHIP_MIX(12771);

    private final Set<Integer> itemIDs;
    private final int defaultID;

    private Icon(Integer ... ids) {
        this.defaultID = ids[0];
        this.itemIDs = Sets.newHashSet((Object[])ids);
    }

    private Icon(int defaultID) {
        this.defaultID = defaultID;
        this.itemIDs = Sets.newHashSet((Object[])new Integer[]{defaultID});
    }

    static Icon getAnimatedIcon(int id) {
        for (Icon icon : Icon.values()) {
            if (!icon.itemIDs.contains(id)) continue;
            return icon;
        }
        return null;
    }

    public Set<Integer> getItemIDs() {
        return this.itemIDs;
    }

    public int getDefaultID() {
        return this.defaultID;
    }

    public String toString() {
        return "Icon." + this.name() + "(itemIDs=" + this.getItemIDs() + ", defaultID=" + this.getDefaultID() + ")";
    }
}

