/*
 * Decompiled with CFR 0.152.
 */
package com.animatedicons;

import com.animatedicons.AnimatedIconsPlugin;
import com.animatedicons.Icon;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.swing.ImageIcon;
import net.runelite.api.widgets.WidgetItem;
import net.runelite.client.ui.overlay.WidgetItemOverlay;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnimatedIconsOverlay
extends WidgetItemOverlay {
    private static final Logger log = LoggerFactory.getLogger(AnimatedIconsOverlay.class);
    Map<Integer, Image> images = new HashMap<Integer, Image>();

    @Inject
    private AnimatedIconsOverlay() {
        this.showOnEquipment();
        this.showOnInventory();
        this.showOnBank();
    }

    public void renderItemOverlay(Graphics2D graphics, int itemId, WidgetItem itemWidget) {
        Icon icon = Icon.getAnimatedIcon(itemId);
        if (icon != null) {
            Image animatedIcon;
            Rectangle bounds = itemWidget.getCanvasBounds();
            Integer defaultItemID = new Integer(icon.getDefaultID());
            if (this.images.containsKey(defaultItemID)) {
                animatedIcon = this.images.get(defaultItemID);
            } else {
                animatedIcon = new ImageIcon(AnimatedIconsPlugin.class.getClassLoader().getResource(defaultItemID.toString() + ".gif")).getImage();
                this.images.put(defaultItemID, animatedIcon);
            }
            graphics.drawImage(animatedIcon, (int)bounds.getX(), (int)bounds.getY(), null);
        }
    }
}

