/*
 * Decompiled with CFR 0.152.
 */
package com.gpu;

import com.regionlocker.RegionLocker;
import java.util.Arrays;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import org.lwjgl.opengl.GL43C;

public class RegionLockerAddon {
    @Inject
    private Client client;
    private static final int LOCKED_REGIONS_SIZE = 16;
    private final int[] loadedLockedRegions = new int[16];
    private int uniUseGray;
    private int uniUseHardBorder;
    private int uniGrayAmount;
    private int uniGrayColor;
    private int uniBaseX;
    private int uniBaseY;
    private int uniLockedRegions;

    public void initUniforms(int glProgram) {
        this.uniUseGray = GL43C.glGetUniformLocation((int)glProgram, (CharSequence)"useGray");
        this.uniUseHardBorder = GL43C.glGetUniformLocation((int)glProgram, (CharSequence)"useHardBorder");
        this.uniGrayAmount = GL43C.glGetUniformLocation((int)glProgram, (CharSequence)"configGrayAmount");
        this.uniGrayColor = GL43C.glGetUniformLocation((int)glProgram, (CharSequence)"configGrayColor");
        this.uniBaseX = GL43C.glGetUniformLocation((int)glProgram, (CharSequence)"baseX");
        this.uniBaseY = GL43C.glGetUniformLocation((int)glProgram, (CharSequence)"baseY");
        this.uniLockedRegions = GL43C.glGetUniformLocation((int)glProgram, (CharSequence)"lockedRegions");
    }

    private boolean instanceRegionUnlocked() {
        if (this.client.getMapRegions() != null && this.client.getMapRegions().length > 0 && (this.client.getGameState() == GameState.LOGGED_IN || this.client.getGameState() == GameState.LOADING)) {
            for (int i = 0; i < this.client.getMapRegions().length; ++i) {
                int region = this.client.getMapRegions()[i];
                if (!RegionLocker.hasRegion(region)) continue;
                return true;
            }
        }
        return false;
    }

    private void initRegionLockerGpu() {
        int bx = this.client.getBaseX() * 128;
        int by = this.client.getBaseY() * 128;
        Arrays.fill(this.loadedLockedRegions, 0);
        if (this.client.getMapRegions() != null && this.client.getMapRegions().length > 0 && (this.client.getGameState() == GameState.LOGGED_IN || this.client.getGameState() == GameState.LOADING)) {
            for (int i = 0; i < this.client.getMapRegions().length; ++i) {
                int region = this.client.getMapRegions()[i];
                if (RegionLocker.invertShader && !RegionLocker.hasRegion(region)) {
                    this.loadedLockedRegions[i] = region;
                    continue;
                }
                if (RegionLocker.invertShader || !RegionLocker.hasRegion(region)) continue;
                this.loadedLockedRegions[i] = region;
            }
        }
        GL43C.glUniform1i((int)this.uniBaseX, (int)bx);
        GL43C.glUniform1i((int)this.uniBaseY, (int)by);
        GL43C.glUniform1iv((int)this.uniLockedRegions, (int[])this.loadedLockedRegions);
    }

    public void beforeDrawRegionLockerGpu() {
        GL43C.glUniform1i((int)this.uniUseHardBorder, (int)(RegionLocker.hardBorder ? 1 : 0));
        GL43C.glUniform1f((int)this.uniGrayAmount, (float)((float)RegionLocker.grayAmount / 255.0f));
        GL43C.glUniform4f((int)this.uniGrayColor, (float)((float)RegionLocker.grayColor.getRed() / 255.0f), (float)((float)RegionLocker.grayColor.getGreen() / 255.0f), (float)((float)RegionLocker.grayColor.getBlue() / 255.0f), (float)((float)RegionLocker.grayColor.getAlpha() / 255.0f));
        if (!RegionLocker.renderLockedRegions || this.client.isInInstancedRegion() && this.instanceRegionUnlocked()) {
            GL43C.glUniform1i((int)this.uniUseGray, (int)0);
        } else {
            GL43C.glUniform1i((int)this.uniUseGray, (int)1);
            this.initRegionLockerGpu();
        }
    }
}

