/*
 * Decompiled with CFR 0.152.
 */
package com.goaltracker.ui;

import com.goaltracker.Goal;
import com.goaltracker.GoalTrackerPlugin;
import com.goaltracker.Requirement;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.components.MouseDragEventForwarder;
import net.runelite.client.util.ImageUtil;

public class RequirementsPanel
extends JPanel {
    private static final ImageIcon EXPAND_MORE_ICON;
    private static final ImageIcon EXPAND_MORE_HOVER_ICON;
    private static final ImageIcon EXPAND_LESS_ICON;
    private static final ImageIcon EXPAND_LESS_HOVER_ICON;
    private static final ImageIcon ADD_ICON;
    private static final ImageIcon ADD_HOVER_ICON;
    private static final ImageIcon DELETE_ICON;
    private static final ImageIcon DELETE_HOVER_ICON;
    private JLabel expandButton;
    private JPanel bottomContainer;
    private JPanel addButtonWrapper;
    private JPanel nameWrapper;
    private final GoalTrackerPlugin plugin;
    private final JComponent parentPanel;
    private final Goal goal;
    private boolean expanded = true;
    private boolean hovering = false;
    private GridBagConstraints gbc;

    RequirementsPanel(final GoalTrackerPlugin plugin, JComponent parentPanel, final Goal goal) {
        this.plugin = plugin;
        this.parentPanel = parentPanel;
        this.goal = goal;
        this.expanded = !plugin.config.collapseRequirements();
        this.setLayout(new BorderLayout());
        this.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.setBorder(new EmptyBorder(0, 8, 0, 8));
        this.nameWrapper = new JPanel(new BorderLayout());
        this.nameWrapper.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.nameWrapper.setCursor(Cursor.getPredefinedCursor(12));
        this.bottomContainer = new JPanel(new GridBagLayout());
        this.bottomContainer.setBorder(new EmptyBorder(5, 0, 0, 0));
        this.bottomContainer.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.bottomContainer.setVisible(this.expanded);
        final JLabel requirementsLabel = new JLabel("Requirements");
        final JLabel addRequirement = new JLabel(ADD_ICON);
        addRequirement.setCursor(Cursor.getPredefinedCursor(12));
        addRequirement.setToolTipText("Add new requirement");
        addRequirement.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                String name = JOptionPane.showInputDialog(addRequirement, (Object)"Requirement name:");
                if (name == null || name.isEmpty()) {
                    return;
                }
                goal.getRequirements().add(new Requirement(name, false, false));
                plugin.updateConfig();
                RequirementsPanel.this.updateRequirements();
                RequirementsPanel.this.repaint();
                RequirementsPanel.this.revalidate();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                addRequirement.setIcon(ADD_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                addRequirement.setIcon(ADD_ICON);
            }
        });
        this.expandButton = new JLabel(EXPAND_LESS_ICON);
        this.expandButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 1));
        this.nameWrapper.setToolTipText("View less...");
        this.nameWrapper.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                RequirementsPanel.this.setExpanded(!RequirementsPanel.this.expanded);
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                RequirementsPanel.this.hovering = true;
                RequirementsPanel.this.updateHeader();
                requirementsLabel.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                RequirementsPanel.this.hovering = false;
                RequirementsPanel.this.updateHeader();
                requirementsLabel.setForeground(Color.WHITE);
            }
        });
        this.updateHeader();
        this.nameWrapper.add((Component)requirementsLabel, "Center");
        this.nameWrapper.add((Component)this.expandButton, "East");
        this.addButtonWrapper = new JPanel(new BorderLayout(3, 0));
        this.addButtonWrapper.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.addButtonWrapper.add((Component)addRequirement, "Center");
        this.updateRequirements();
        this.add((Component)this.nameWrapper, "North");
        this.add((Component)this.bottomContainer, "Center");
        MouseDragEventForwarder mouseDragEventForwarder = new MouseDragEventForwarder((Component)parentPanel);
        this.bottomContainer.addMouseListener((MouseListener)mouseDragEventForwarder);
        this.bottomContainer.addMouseMotionListener((MouseMotionListener)mouseDragEventForwarder);
        addRequirement.addMouseListener((MouseListener)mouseDragEventForwarder);
        addRequirement.addMouseMotionListener((MouseMotionListener)mouseDragEventForwarder);
        this.nameWrapper.addMouseListener((MouseListener)mouseDragEventForwarder);
        this.nameWrapper.addMouseMotionListener((MouseMotionListener)mouseDragEventForwarder);
        this.addButtonWrapper.addMouseListener((MouseListener)mouseDragEventForwarder);
        this.addButtonWrapper.addMouseMotionListener((MouseMotionListener)mouseDragEventForwarder);
    }

    public JLabel createDeleteLabel(final Requirement requirement) {
        final JLabel deleteLabel = new JLabel(DELETE_ICON);
        deleteLabel.setToolTipText("Delete requirement");
        deleteLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                RequirementsPanel.this.goal.getRequirements().remove(requirement);
                RequirementsPanel.this.plugin.updateConfig();
                RequirementsPanel.this.updateRequirements();
                RequirementsPanel.this.repaint();
                RequirementsPanel.this.revalidate();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                deleteLabel.setIcon(DELETE_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                deleteLabel.setIcon(DELETE_ICON);
            }
        });
        return deleteLabel;
    }

    private Color getRequirementColor(Requirement req) {
        return req.isCompleted() ? this.plugin.config.completedColor() : (req.isBlocked() ? this.plugin.config.blockedColor() : this.plugin.config.inProgressColor());
    }

    public JLabel createRequirementLabel(final Requirement req) {
        final JLabel requirementLabel = new JLabel(req.getName());
        requirementLabel.setForeground(this.getRequirementColor(req));
        requirementLabel.setToolTipText("Toggle completion");
        requirementLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                req.cycleState();
                if (e.isShiftDown()) {
                    req.cycleState();
                }
                RequirementsPanel.this.plugin.updateConfig();
                RequirementsPanel.this.updateRequirements();
                RequirementsPanel.this.repaint();
                RequirementsPanel.this.revalidate();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                requirementLabel.setForeground(RequirementsPanel.this.getRequirementColor(req).darker());
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                requirementLabel.setForeground(RequirementsPanel.this.getRequirementColor(req));
            }
        });
        return requirementLabel;
    }

    public void updateHeader() {
        this.nameWrapper.setToolTipText(this.expanded ? "View less..." : "View more...");
        if (this.hovering) {
            this.expandButton.setIcon(this.expanded ? EXPAND_LESS_HOVER_ICON : EXPAND_MORE_HOVER_ICON);
        } else {
            this.expandButton.setIcon(this.expanded ? EXPAND_LESS_ICON : EXPAND_MORE_ICON);
        }
    }

    public void updateRequirements() {
        this.bottomContainer.removeAll();
        this.gbc = new GridBagConstraints();
        this.gbc.fill = 2;
        this.gbc.weightx = 1.0;
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        for (Requirement requirement : this.goal.getRequirements()) {
            JPanel requirementWrapper = new JPanel(new BorderLayout());
            requirementWrapper.setBackground(ColorScheme.DARKER_GRAY_COLOR);
            JLabel requirementLabel = this.createRequirementLabel(requirement);
            requirementLabel.setCursor(Cursor.getPredefinedCursor(12));
            JLabel deleteLabel = this.createDeleteLabel(requirement);
            deleteLabel.setCursor(Cursor.getPredefinedCursor(12));
            requirementWrapper.add((Component)requirementLabel, "Center");
            requirementWrapper.add((Component)deleteLabel, "East");
            this.bottomContainer.add((Component)requirementWrapper, this.gbc);
            ++this.gbc.gridy;
            this.bottomContainer.add(Box.createRigidArea(new Dimension(0, 5)), this.gbc);
            ++this.gbc.gridy;
            MouseDragEventForwarder mouseDragEventForwarder = new MouseDragEventForwarder((Component)this.parentPanel);
            requirementLabel.addMouseListener((MouseListener)mouseDragEventForwarder);
            requirementLabel.addMouseMotionListener((MouseMotionListener)mouseDragEventForwarder);
            deleteLabel.addMouseListener((MouseListener)mouseDragEventForwarder);
            deleteLabel.addMouseMotionListener((MouseMotionListener)mouseDragEventForwarder);
            requirementWrapper.addMouseListener((MouseListener)mouseDragEventForwarder);
            requirementWrapper.addMouseMotionListener((MouseMotionListener)mouseDragEventForwarder);
        }
        this.bottomContainer.add((Component)this.addButtonWrapper, this.gbc);
        ++this.gbc.gridy;
    }

    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
        this.bottomContainer.setVisible(expanded);
        this.updateHeader();
    }

    static {
        BufferedImage addIcon = ImageUtil.getResourceStreamFromClass(GoalTrackerPlugin.class, (String)"add_icon.png");
        ADD_ICON = new ImageIcon(addIcon);
        ADD_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)addIcon, (float)0.53f));
        BufferedImage expandMoreImg = ImageUtil.getResourceStreamFromClass(GoalTrackerPlugin.class, (String)"expand_more_icon.png");
        EXPAND_MORE_ICON = new ImageIcon(expandMoreImg);
        EXPAND_MORE_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)expandMoreImg, (int)-100));
        BufferedImage expandLessImg = ImageUtil.getResourceStreamFromClass(GoalTrackerPlugin.class, (String)"expand_less_icon.png");
        EXPAND_LESS_ICON = new ImageIcon(expandLessImg);
        EXPAND_LESS_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)expandLessImg, (int)-100));
        BufferedImage deleteImg = ImageUtil.getResourceStreamFromClass(GoalTrackerPlugin.class, (String)"delete_icon.png");
        DELETE_ICON = new ImageIcon(deleteImg);
        DELETE_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)deleteImg, (int)-100));
    }
}

