/*
 * Decompiled with CFR 0.152.
 */
package com.goaltracker.ui;

import com.goaltracker.Goal;
import com.goaltracker.GoalTrackerConfig;
import com.goaltracker.GoalTrackerPlugin;
import com.goaltracker.ui.GoalPanel;
import com.google.gson.Gson;
import com.google.inject.Inject;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.components.DragAndDropReorderPane;
import net.runelite.client.ui.components.IconTextField;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoalTrackerPanel
extends PluginPanel {
    private static final Logger log = LoggerFactory.getLogger(GoalTrackerPanel.class);
    private static final ImageIcon ADD_ICON;
    private static final ImageIcon ADD_HOVER_ICON;
    private static final ImageIcon IMPORT_ICON;
    private static final ImageIcon IMPORT_HOVER_ICON;
    private static final ImageIcon EXPORT_ICON;
    private static final ImageIcon EXPORT_HOVER_ICON;
    public static final ImageIcon EDIT_ICON;
    public static final ImageIcon EDIT_HOVER_ICON;
    public static final ImageIcon DELETE_ICON;
    public static final ImageIcon DELETE_HOVER_ICON;
    private static final Color DEFAULT_BORDER_COLOR;
    private static final Color DEFAULT_FILL_COLOR;
    private static final int DEFAULT_BORDER_THICKNESS = 3;
    private final JLabel addGoal = new JLabel(ADD_ICON);
    private final JLabel importButton = new JLabel(IMPORT_ICON);
    private final JLabel exportButton = new JLabel(EXPORT_ICON);
    private final JLabel title = new JLabel();
    private final IconTextField searchBar = new IconTextField();
    private DragAndDropReorderPane goalListPanel = new DragAndDropReorderPane();
    @Inject
    private GoalTrackerPlugin plugin;
    @Inject
    private GoalTrackerConfig config;
    private Color selectedColor = DEFAULT_BORDER_COLOR;
    private Color selectedFillColor = DEFAULT_FILL_COLOR;
    private int selectedBorderThickness = 3;
    @Inject
    private Gson gson;
    static ImageIcon CHECKED_ICON;
    static ImageIcon CHECKED_HOVER_ICON;
    static ImageIcon CHECKBOX_ICON;
    static ImageIcon CHECKBOX_HOVER_ICON;
    static ImageIcon BLOCKED_ICON;
    static ImageIcon BLOCKED_HOVER_ICON;

    public void init() {
        this.loadIcons();
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        JPanel northPanel = new JPanel(new BorderLayout(0, 5));
        JPanel actionWrapper = new JPanel(new BorderLayout(8, 0));
        actionWrapper.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 8));
        this.title.setText("Goal Tracker");
        this.title.setForeground(Color.WHITE);
        this.searchBar.setIcon(IconTextField.Icon.SEARCH);
        this.searchBar.setPreferredSize(new Dimension(205, 30));
        this.searchBar.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.searchBar.setHoverBackgroundColor(ColorScheme.DARK_GRAY_HOVER_COLOR);
        this.searchBar.addActionListener(e -> this.onSearchBarChanged());
        actionWrapper.add((Component)this.importButton, "West");
        actionWrapper.add((Component)this.exportButton, "Center");
        actionWrapper.add((Component)this.addGoal, "East");
        northPanel.add((Component)this.title, "West");
        northPanel.add((Component)actionWrapper, "East");
        northPanel.add((Component)this.searchBar, "South");
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new BoxLayout(centerPanel, 1));
        centerPanel.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.addGoal.setCursor(Cursor.getPredefinedCursor(12));
        this.addGoal.setToolTipText("Add new goal");
        this.addGoal.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                GoalTrackerPanel.this.plugin.addGoal();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                GoalTrackerPanel.this.addGoal.setIcon(ADD_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                GoalTrackerPanel.this.addGoal.setIcon(ADD_ICON);
            }
        });
        this.importButton.setCursor(Cursor.getPredefinedCursor(12));
        this.importButton.setToolTipText("Import goals file...");
        this.importButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int confirm;
                JFileChooser fc = new JFileChooser();
                fc.setDialogType(0);
                fc.setDialogTitle("Choose a goals json file to import");
                fc.setFileFilter(new FileNameExtensionFilter("JSON", "json"));
                int returnVal = fc.showOpenDialog((Component)((Object)GoalTrackerPanel.this));
                if (returnVal != 0) {
                    return;
                }
                File file = fc.getSelectedFile();
                if (GoalTrackerPanel.this.plugin.getGoals().size() > 0 && (confirm = JOptionPane.showConfirmDialog((Component)((Object)GoalTrackerPanel.this), "Are you sure you want to import this file? This will DELETE all your current goals.", "Warning", 2)) != 0) {
                    return;
                }
                try (FileInputStream fileStream = new FileInputStream(file);
                     InputStreamReader reader = new InputStreamReader((InputStream)fileStream, StandardCharsets.UTF_8);
                     BufferedReader in = new BufferedReader(reader);){
                    String line = in.readLine();
                    StringBuilder json = new StringBuilder();
                    while (line != null) {
                        json.append(line + System.lineSeparator());
                        line = in.readLine();
                    }
                    GoalTrackerPanel.this.plugin.getGoals().clear();
                    GoalTrackerPanel.this.plugin.loadConfig(json.toString()).forEach(GoalTrackerPanel.this.plugin.getGoals()::add);
                    GoalTrackerPanel.this.plugin.updateConfig();
                    GoalTrackerPanel.this.updateGoals();
                }
                catch (FileNotFoundException ex) {
                    JOptionPane.showConfirmDialog((Component)((Object)GoalTrackerPanel.this), "That file doesn't exist!", "Error", -1);
                }
                catch (IOException ex) {
                    JOptionPane.showConfirmDialog((Component)((Object)GoalTrackerPanel.this), "Cannot parse file!", "Error", -1);
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                GoalTrackerPanel.this.importButton.setIcon(IMPORT_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                GoalTrackerPanel.this.importButton.setIcon(IMPORT_ICON);
            }
        });
        this.exportButton.setCursor(Cursor.getPredefinedCursor(12));
        this.exportButton.setToolTipText("Export goals file...");
        this.exportButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                JFileChooser fc = new JFileChooser();
                fc.setDialogType(1);
                fc.setDialogTitle("Save your goals to a json file");
                fc.setSelectedFile(new File("goals.json"));
                fc.setFileFilter(new FileNameExtensionFilter("JSON", "json"));
                int returnVal = fc.showOpenDialog((Component)((Object)GoalTrackerPanel.this));
                if (returnVal != 0) {
                    return;
                }
                File file = fc.getSelectedFile();
                if (file == null) {
                    return;
                }
                if (!file.getName().toLowerCase().endsWith(".json")) {
                    file = new File(file.getParentFile(), file.getName() + ".json");
                }
                try (FileOutputStream fileStream = new FileOutputStream(file);
                     OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fileStream, StandardCharsets.UTF_8);){
                    String json = GoalTrackerPanel.this.gson.toJson(GoalTrackerPanel.this.plugin.getGoals());
                    writer.write(json);
                }
                catch (IOException ex) {
                    JOptionPane.showConfirmDialog((Component)((Object)GoalTrackerPanel.this), "Cannot write file!", "Error", -1);
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                GoalTrackerPanel.this.exportButton.setIcon(EXPORT_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                GoalTrackerPanel.this.exportButton.setIcon(EXPORT_ICON);
            }
        });
        this.goalListPanel = new DragAndDropReorderPane();
        this.goalListPanel.addDragListener(draggedComponent -> {
            try {
                Component[] components = this.goalListPanel.getComponentsInLayer(JLayeredPane.DEFAULT_LAYER.intValue());
                for (int i = 0; i < components.length; ++i) {
                    if (components[i] != draggedComponent) continue;
                    GoalPanel goalPanel = (GoalPanel)components[i];
                    this.plugin.reorderGoal(goalPanel.goal, i);
                    break;
                }
            }
            catch (Exception ex) {
                log.error("The goal panel should only contain GoalPanel instances", (Throwable)ex);
            }
        });
        centerPanel.add((Component)this.goalListPanel);
        this.add(northPanel, "North");
        this.add(centerPanel, "Center");
        this.updateGoals();
    }

    private void loadIcons() {
        BufferedImage checkedImg = ImageUtil.recolorImage((Image)ImageUtil.getResourceStreamFromClass(GoalTrackerPlugin.class, (String)"checked_icon.png"), (Color)this.config.completedColor());
        CHECKED_ICON = new ImageIcon(checkedImg);
        CHECKED_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)checkedImg, (int)-100));
        BufferedImage checkboxImg = ImageUtil.recolorImage((Image)ImageUtil.getResourceStreamFromClass(GoalTrackerPlugin.class, (String)"checkbox_icon.png"), (Color)this.config.inProgressColor());
        CHECKBOX_ICON = new ImageIcon(checkboxImg);
        CHECKBOX_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)checkboxImg, (int)-100));
        BufferedImage blockedImg = ImageUtil.recolorImage((Image)ImageUtil.getResourceStreamFromClass(GoalTrackerPlugin.class, (String)"blocked_icon.png"), (Color)this.config.blockedColor());
        BLOCKED_ICON = new ImageIcon(blockedImg);
        BLOCKED_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)blockedImg, (int)-100));
    }

    private void onSearchBarChanged() {
        String text = this.searchBar.getText();
        this.updateGoals(text);
        this.repaint();
        this.revalidate();
    }

    public void rebuild() {
        this.loadIcons();
        this.removeAll();
        this.repaint();
        this.revalidate();
        this.init();
    }

    public void updateGoals() {
        this.updateGoals("");
    }

    public void updateGoals(String text) {
        this.goalListPanel.removeAll();
        for (Goal goal : this.plugin.getGoals()) {
            if (goal == null || !this.matchesSearchTerms(goal, text) || goal.isCompleted() && this.plugin.config.hideCompletedGoals()) continue;
            this.goalListPanel.add((Component)new GoalPanel(this.plugin, (JComponent)this.goalListPanel, goal));
        }
        this.repaint();
        this.revalidate();
    }

    public boolean matchesSearchTerms(Goal goal, String text) {
        if (text.isEmpty()) {
            return true;
        }
        text = text.toLowerCase();
        Pattern p = Pattern.compile("((?:\\\")([^\\\"]*)(?:\\\")|\\w+)");
        Matcher m = p.matcher(text);
        while (m.find()) {
            String term = m.group();
            String t = term = term.replaceAll("^\"|\"$", "");
            if (t.isEmpty()) continue;
            if (t.equals(Integer.toString(goal.getChunk()))) {
                return true;
            }
            if (goal.getName().toLowerCase().contains(t)) {
                return true;
            }
            if (!goal.getRequirements().stream().anyMatch(str -> str.getName().toLowerCase().contains(t))) continue;
            return true;
        }
        return false;
    }

    public Color getSelectedColor() {
        return this.selectedColor;
    }

    public Color getSelectedFillColor() {
        return this.selectedFillColor;
    }

    public int getSelectedBorderThickness() {
        return this.selectedBorderThickness;
    }

    static {
        DEFAULT_BORDER_COLOR = Color.GREEN;
        DEFAULT_FILL_COLOR = new Color(0, 255, 0, 0);
        BufferedImage addIcon = ImageUtil.getResourceStreamFromClass(GoalTrackerPlugin.class, (String)"add_icon.png");
        ADD_ICON = new ImageIcon(addIcon);
        ADD_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)addIcon, (float)0.53f));
        BufferedImage importIcon = ImageUtil.getResourceStreamFromClass(GoalTrackerPlugin.class, (String)"import.png");
        IMPORT_ICON = new ImageIcon(importIcon);
        IMPORT_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)importIcon, (float)0.53f));
        BufferedImage exportIcon = ImageUtil.getResourceStreamFromClass(GoalTrackerPlugin.class, (String)"export.png");
        EXPORT_ICON = new ImageIcon(exportIcon);
        EXPORT_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)exportIcon, (float)0.53f));
        BufferedImage deleteImg = ImageUtil.getResourceStreamFromClass(GoalTrackerPlugin.class, (String)"delete_icon.png");
        DELETE_ICON = new ImageIcon(deleteImg);
        DELETE_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)deleteImg, (int)-100));
        BufferedImage editImg = ImageUtil.getResourceStreamFromClass(GoalTrackerPlugin.class, (String)"edit_icon.png");
        EDIT_ICON = new ImageIcon(editImg);
        EDIT_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)editImg, (int)-100));
    }
}

