/*
 * Decompiled with CFR 0.152.
 */
package com.goaltracker;

import com.goaltracker.Goal;
import com.goaltracker.GoalTrackerConfig;
import com.goaltracker.GoalTrackerInput;
import com.goaltracker.GoalTrackerOverlay;
import com.goaltracker.Requirement;
import com.goaltracker.ui.GoalTrackerPanel;
import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Inject;
import com.google.inject.Provides;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Stream;
import net.runelite.api.Client;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.ClientUI;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Region Goal Tracker", description="Add goals to chunks", tags={"chunk", "backlog", "log"}, enabledByDefault=false)
public class GoalTrackerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(GoalTrackerPlugin.class);
    private static final String PLUGIN_NAME = "Goal Tracker";
    private static final String TASK_LIST_CONFIG_KEY = "goals";
    private static final String ICON_FILE = "panel_icon.png";
    private final LinkedList<Goal> goals = new LinkedList();
    private boolean hotkeyPressed = false;
    @Inject
    private Client client;
    @Inject
    public GoalTrackerConfig config;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private ConfigManager configManager;
    @Inject
    private ClientUI clientUi;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private GoalTrackerOverlay overlay;
    @Inject
    private KeyManager keyManager;
    @Inject
    private GoalTrackerInput inputListener;
    @Inject
    private Gson gson;
    private GoalTrackerPanel pluginPanel;
    private NavigationButton navigationButton;

    @Provides
    GoalTrackerConfig provideConfig(ConfigManager configManager) {
        if (configManager.getConfiguration("RegionLockerGoalTracker", "migrationCompleted") == null) {
            String[] oldConfigKeys;
            log.info("Migrating region locker goal tracker config...");
            for (String key : oldConfigKeys = new String[]{TASK_LIST_CONFIG_KEY, "drawMapOverlay", "enableTooltip", "hotKey", "noProgressColor", "inProgressColor", "completedColor", "requiredChunkColor"}) {
                String value = configManager.getConfiguration("RegionLockerGoalTracker", key);
                if (value != null || (value = configManager.getConfiguration("goaltracker", key)) == null) continue;
                configManager.setConfiguration("RegionLockerGoalTracker", key, value);
            }
            configManager.setConfiguration("RegionLockerGoalTracker", "migrationCompleted", (Object)true);
        }
        return (GoalTrackerConfig)configManager.getConfig(GoalTrackerConfig.class);
    }

    protected void startUp() {
        String taskListJson = this.configManager.getConfiguration("RegionLockerGoalTracker", TASK_LIST_CONFIG_KEY);
        this.loadConfig(taskListJson).forEach(this.goals::add);
        this.pluginPanel = (GoalTrackerPanel)((Object)this.injector.getInstance(GoalTrackerPanel.class));
        this.pluginPanel.rebuild();
        BufferedImage icon = ImageUtil.getResourceStreamFromClass(((Object)((Object)this)).getClass(), (String)ICON_FILE);
        this.navigationButton = NavigationButton.builder().tooltip(PLUGIN_NAME).icon(icon).priority(1).panel((PluginPanel)this.pluginPanel).build();
        this.clientToolbar.addNavigation(this.navigationButton);
        this.keyManager.registerKeyListener((KeyListener)this.inputListener);
        this.overlayManager.add((Overlay)this.overlay);
    }

    protected void shutDown() {
        this.overlayManager.remove((Overlay)this.overlay);
        this.overlayManager.removeIf(GoalTrackerOverlay.class::isInstance);
        this.goals.clear();
        this.clientToolbar.removeNavigation(this.navigationButton);
        this.keyManager.unregisterKeyListener((KeyListener)this.inputListener);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!event.getGroup().equals("RegionLockerGoalTracker")) {
            return;
        }
        switch (event.getKey()) {
            case "hideCompletedGoals": 
            case "collapseRequirements": 
            case "noProgressColor": 
            case "inProgressColor": 
            case "completedColor": 
            case "requiredChunkColor": {
                this.pluginPanel.updateGoals();
            }
        }
    }

    public void updateConfig() {
        if (this.goals.isEmpty()) {
            this.configManager.unsetConfiguration("RegionLockerGoalTracker", TASK_LIST_CONFIG_KEY);
        } else {
            String json = this.gson.toJson(this.goals);
            this.configManager.setConfiguration("RegionLockerGoalTracker", TASK_LIST_CONFIG_KEY, json);
        }
    }

    public Stream<Goal> loadConfig(String json) {
        if (Strings.isNullOrEmpty((String)json)) {
            return Stream.empty();
        }
        try {
            List goalData = (List)this.gson.fromJson(json, new TypeToken<ArrayList<Goal>>(){}.getType());
            return goalData.stream();
        }
        catch (Exception e) {
            this.updateConfig();
            return Stream.empty();
        }
    }

    public synchronized void addGoal() {
        Goal goal = new Goal("Goal " + (this.goals.size() + 1), 12850, new ArrayList<Requirement>(), false, false);
        this.goals.addFirst(goal);
        this.pluginPanel.updateGoals();
        this.updateConfig();
    }

    public synchronized void deleteGoal(Goal goal) {
        if (this.goals.remove(goal)) {
            this.pluginPanel.updateGoals();
            this.updateConfig();
        }
    }

    public synchronized void reorderGoal(Goal goal, int newIndex) {
        if (this.goals.remove(goal)) {
            this.goals.add(newIndex, goal);
            this.updateConfig();
        }
    }

    public LinkedList<Goal> getGoals() {
        return this.goals;
    }

    public boolean isHotkeyPressed() {
        return this.hotkeyPressed;
    }

    public void setHotkeyPressed(boolean hotkeyPressed) {
        this.hotkeyPressed = hotkeyPressed;
    }
}

