/*
 * Decompiled with CFR 0.152.
 */
package com.goaltracker;

import com.goaltracker.Goal;
import com.goaltracker.GoalTrackerConfig;
import com.goaltracker.GoalTrackerPlugin;
import com.google.inject.Inject;
import com.regionlocker.RegionLocker;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.Arrays;
import net.runelite.api.Client;
import net.runelite.api.Point;
import net.runelite.api.RenderOverview;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.tooltip.Tooltip;
import net.runelite.client.ui.overlay.tooltip.TooltipManager;
import net.runelite.client.util.ColorUtil;

public class GoalTrackerOverlay
extends Overlay {
    private static final Color WHITE_TRANSLUCENT = new Color(255, 255, 255, 127);
    private static final int LABEL_PADDING = 4;
    private static final int REGION_SIZE = 64;
    private static final int REGION_TRUNCATE = -64;
    @Inject
    private Client client;
    @Inject
    private GoalTrackerPlugin plugin;
    @Inject
    private GoalTrackerConfig config;
    @Inject
    private TooltipManager tooltipManager;

    @Inject
    private GoalTrackerOverlay() {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.HIGHEST);
        this.setLayer(OverlayLayer.ALWAYS_ON_TOP);
    }

    public Dimension render(Graphics2D graphics) {
        if (this.config.enableTooltip() || this.config.drawMapOverlay()) {
            this.drawRegionOverlay(graphics);
        }
        return null;
    }

    private void drawRegionOverlay(Graphics2D graphics) {
        Widget map = this.client.getWidget(WidgetInfo.WORLD_MAP_VIEW);
        if (map == null) {
            return;
        }
        RenderOverview ro = this.client.getRenderOverview();
        Float pixelsPerTile = Float.valueOf(ro.getWorldMapZoom());
        Rectangle worldMapRect = map.getBounds();
        graphics.setClip(worldMapRect);
        int widthInTiles = (int)Math.ceil(worldMapRect.getWidth() / (double)pixelsPerTile.floatValue());
        int heightInTiles = (int)Math.ceil(worldMapRect.getHeight() / (double)pixelsPerTile.floatValue());
        Point worldMapPosition = ro.getWorldMapPosition();
        int yTileMin = worldMapPosition.getY() - heightInTiles / 2;
        int xRegionMin = worldMapPosition.getX() - widthInTiles / 2 & 0xFFFFFFC0;
        int xRegionMax = (worldMapPosition.getX() + widthInTiles / 2 & 0xFFFFFFC0) + 64;
        int yRegionMin = yTileMin & 0xFFFFFFC0;
        int yRegionMax = (worldMapPosition.getY() + heightInTiles / 2 & 0xFFFFFFC0) + 64;
        int regionPixelSize = (int)Math.ceil(64.0f * pixelsPerTile.floatValue());
        Point mousePos = this.client.getMouseCanvasPosition();
        for (int x = xRegionMin; x < xRegionMax; x += 64) {
            for (int y = yRegionMin; y < yRegionMax; y += 64) {
                Color color;
                String tooltip;
                int yTileOffset = -(yTileMin - y);
                int xTileOffset = x + widthInTiles / 2 - worldMapPosition.getX();
                int xPos = (int)((float)xTileOffset * pixelsPerTile.floatValue()) + (int)worldMapRect.getX();
                int yPos = worldMapRect.height - (int)((float)yTileOffset * pixelsPerTile.floatValue()) + (int)worldMapRect.getY();
                int regionId = x >> 6 << 8 | y >> 6;
                Rectangle regionRect = new Rectangle(xPos, yPos -= regionPixelSize, regionPixelSize, regionPixelSize);
                Goal[] goals = (Goal[])this.plugin.getGoals().stream().filter(g -> g.getChunk() == regionId).toArray(Goal[]::new);
                Goal[] reqs = new Goal[]{};
                if (!RegionLocker.hasRegion(regionId)) {
                    reqs = (Goal[])this.plugin.getGoals().stream().filter(g -> g.getRequirements().stream().anyMatch(r -> r.getName().equals(Integer.toString(regionId)))).toArray(Goal[]::new);
                }
                if (this.config.enableTooltip() && this.plugin.isHotkeyPressed() && regionRect.contains(mousePos.getX(), mousePos.getY()) && !(tooltip = this.buildTooltip(goals, reqs)).isEmpty()) {
                    this.tooltipManager.add(new Tooltip(tooltip));
                }
                if (!this.config.drawMapOverlay()) continue;
                if (reqs.length > 0) {
                    color = this.config.requiredChunkColor();
                } else {
                    if (goals.length <= 0) continue;
                    if (Arrays.stream(goals).allMatch(Goal::isCompleted)) {
                        if (this.config.hideCompletedGoals()) continue;
                        color = this.config.completedColor();
                    } else {
                        color = Arrays.stream(goals).anyMatch(Goal::isBlocked) ? this.config.blockedColor() : this.config.inProgressColor();
                    }
                }
                graphics.setColor(color);
                graphics.drawRect(xPos + 1, yPos + 1, regionPixelSize - 2, regionPixelSize - 2);
            }
        }
    }

    private String buildTooltip(Goal[] goals, Goal[] reqs) {
        String title = "Goals:</br>";
        StringBuilder sb = this.textFromGoals(title, goals);
        String reqsTitle = "Chunk required for:</br>";
        StringBuilder reqsSb = this.textFromGoals(reqsTitle, reqs);
        return sb.append((CharSequence)reqsSb).toString();
    }

    private StringBuilder textFromGoals(String title, Goal[] goals) {
        StringBuilder sb = new StringBuilder();
        for (Goal goal : goals) {
            Color color = Arrays.stream(goals).allMatch(Goal::isCompleted) ? this.config.completedColor() : (Arrays.stream(goals).anyMatch(Goal::isBlocked) ? this.config.blockedColor() : this.config.inProgressColor());
            sb.append(ColorUtil.wrapWithColorTag((String)goal.getName(), (Color)color) + "</br>");
        }
        if (!sb.toString().isEmpty()) {
            sb.insert(0, title);
        }
        return sb;
    }
}

