/*
 * Decompiled with CFR 0.152.
 */
package com.pollscreenshot;

import com.google.inject.Provides;
import com.pollscreenshot.PollScreenshotConfig;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nullable;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.SpritePixels;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.FontManager;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.ImageCapture;
import net.runelite.client.util.ImageUploadStyle;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Poll Screenshot", description="Screenshots polls")
public class PollScreenshotPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(PollScreenshotPlugin.class);
    @Inject
    private Client client;
    @Inject
    private PollScreenshotConfig config;
    @Inject
    private KeyManager keyManager;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ItemManager itemManager;
    @Inject
    private ImageCapture imageCapture;
    @Inject
    private SpriteManager spriteManager;
    @Inject
    private ScheduledExecutorService executor;
    private Widget button = null;
    private Map<Integer, Rectangle> overrideBounds = new HashMap<Integer, Rectangle>();

    protected void startUp() throws Exception {
        this.clientThread.invokeLater(this::createButton);
    }

    protected void shutDown() throws Exception {
        this.clientThread.invoke(this::hideButton);
    }

    @Provides
    PollScreenshotConfig provideConfig(ConfigManager configManager) {
        return (PollScreenshotConfig)configManager.getConfig(PollScreenshotConfig.class);
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded event) {
        if (event.getGroupId() != 345) {
            return;
        }
        this.createButton();
    }

    private void hideButton() {
        if (this.button == null) {
            return;
        }
        this.button.setHidden(true);
        this.button = null;
    }

    private void createButton() {
        Widget parent = this.client.getWidget(22609920);
        if (parent == null) {
            return;
        }
        this.hideButton();
        this.button = parent.createChild(-1, 5);
        this.button.setOriginalHeight(20);
        this.button.setOriginalWidth(20);
        this.button.setOriginalX(384);
        this.button.setOriginalY(44);
        this.button.setSpriteId(573);
        this.button.setAction(0, "Screenshot");
        this.button.setOnOpListener(new Object[]{e -> this.clientThread.invokeLater(this::screenshot)});
        this.button.setHasListener(true);
        this.button.revalidate();
        this.button.setOnMouseOverListener(new Object[]{e -> this.button.setSpriteId(570)});
        this.button.setOnMouseLeaveListener(new Object[]{e -> this.button.setSpriteId(573)});
    }

    private void screenshot() {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        this.client.getWidgetSpriteCache().reset();
        Widget container = this.client.getWidget(345, 11);
        if (container == null) {
            return;
        }
        Widget[] children = container.getDynamicChildren();
        if (children.length == 0) {
            return;
        }
        int height = children[0].getHeight() + children[0].getRelativeY();
        int y = 0;
        for (Widget item : children) {
            if (item.getRelativeY() <= y) continue;
            y = item.getRelativeY() + 2;
            height = y + item.getHeight();
        }
        int width = 469;
        BufferedImage screenshot = new BufferedImage(width, height + 42, 2);
        Graphics graphics = screenshot.getGraphics();
        BufferedImage background = this.getSprite(297);
        int x = screenshot.getWidth() / background.getWidth() + 1;
        y = screenshot.getHeight() / background.getHeight() + 1;
        for (int i = 0; i < x; ++i) {
            for (int z = 0; z < y; ++z) {
                graphics.drawImage(background, i * background.getWidth(), z * background.getHeight(), null);
            }
        }
        Widget title = this.client.getWidget(345, 2);
        if (title == null) {
            return;
        }
        Widget titleChildren = title.getChild(1);
        graphics.translate(4, 5);
        this.drawWidget(graphics, titleChildren, titleChildren.getRelativeX(), titleChildren.getRelativeY());
        graphics.translate(0, 30);
        for (Widget w : children) {
            this.drawWidget(graphics, w, w.getRelativeX(), w.getRelativeY());
        }
        this.imageCapture.takeScreenshot(screenshot, "poll", "polls", true, ImageUploadStyle.NEITHER);
    }

    private void drawWidget(Graphics graphics, Widget child, int x, int y) {
        if (child == null || child.getType() == 0) {
            return;
        }
        int width = child.getWidth();
        int height = child.getHeight();
        if (child.getType() == 4) {
            String text = Text.removeTags((String)child.getText());
            Font font = FontManager.getRunescapeSmallFont();
            if (child.getId() == 22609922 || text.contains("Votes:")) {
                font = FontManager.getRunescapeBoldFont();
            }
            x = child.getRelativeX() + 2;
            y = child.getRelativeY();
            width = child.getWidth();
            height = child.getHeight();
            Graphics textLayer = graphics.create(x, y, width, height);
            textLayer.setFont(font);
            int xPos = 3;
            int yPos = 0;
            int textWidth = textLayer.getFontMetrics().stringWidth(text);
            if (child.getXTextAlignment() == 1) {
                xPos = (width - textWidth) / 2 + 1;
            }
            if (child.getYTextAlignment() == 0) {
                yPos = font.getSize() - 3;
            } else if (child.getYTextAlignment() == 1) {
                yPos = font.getSize() - 3;
            } else if (child.getYTextAlignment() == 2) {
                yPos = font.getSize() - 3;
            }
            ArrayList<String> lines = child.getOriginalWidth() == 230 ? this.splitString(graphics, text, 242) : this.splitString(graphics, text, 480);
            for (String s : lines) {
                if (child.getTextShadowed()) {
                    xPos = 3;
                    if (child.getId() == 22609922 || text.contains("Votes:")) {
                        xPos = 234 - textWidth / 2 - 2;
                    }
                    textLayer.setColor(Color.BLACK);
                    textLayer.drawString(s, xPos, yPos);
                    --xPos;
                    --yPos;
                }
                textLayer.setColor(new Color(child.getTextColor()));
                textLayer.drawString(s, xPos, yPos);
                if (child.getOriginalWidth() == 230) {
                    yPos += textLayer.getFontMetrics().getHeight() - 1;
                    continue;
                }
                yPos += textLayer.getFontMetrics().getHeight() + 2;
            }
            textLayer.dispose();
        } else if (child.getType() == 3 || child.getType() == 5) {
            if (child.isFilled() && child.getOpacity() == 225 && (child.getTextColor() == 0xFFFFFF || child.getTextColor() == 65280)) {
                String hex = child.getTextColor() == 65280 ? "3f542c" : "5d544a";
                BufferedImage image = new BufferedImage(child.getWidth(), child.getHeight(), 2);
                Graphics g = image.getGraphics();
                Color colour = ColorUtil.fromHex((String)hex);
                g.setColor(colour);
                g.fillRect(0, 0, image.getWidth(), image.getHeight());
                graphics.drawImage(image, child.getRelativeX(), child.getRelativeY(), child.getWidth(), child.getHeight(), null);
                g.dispose();
            }
            if (child.getSpriteId() == 897 || child.getSpriteId() == 297) {
                BufferedImage sprite = this.getSprite(child.getSpriteId());
                graphics.drawImage(sprite, child.getRelativeX(), child.getRelativeY(), child.getWidth(), child.getHeight(), null);
            } else {
                Color c = new Color(child.getTextColor());
                if (child.getOpacity() > 0) {
                    c = new Color(c.getRed(), c.getGreen(), c.getBlue(), child.getOpacity());
                }
                graphics.setColor(c);
                Rectangle r = child.getBounds();
                graphics.drawRect(child.getRelativeX(), child.getRelativeY(), r.width, r.height);
            }
        }
    }

    @Nullable
    private SpritePixels getPixels(int archive) {
        SpritePixels[] sp = this.client.getSprites(this.client.getIndexSprites(), archive, 0);
        assert (sp != null);
        return sp[0];
    }

    private BufferedImage getSprite(int id) {
        SpritePixels sp = this.getPixels(id);
        assert (sp != null);
        return sp.toBufferedImage();
    }

    public ArrayList<String> splitString(Graphics g, String text, int maxWidth) {
        ArrayList<String> lines = new ArrayList<String>();
        String[] words = text.split(" ");
        StringBuilder currentLine = new StringBuilder(words[0]);
        for (int i = 1; i < words.length; ++i) {
            String word = words[i];
            String tempLine = currentLine.toString() + " " + word;
            int lineWidth = g.getFontMetrics().stringWidth(tempLine);
            if (lineWidth > maxWidth) {
                lines.add(currentLine.toString());
                currentLine = new StringBuilder(word);
                continue;
            }
            currentLine.append(" ").append(word);
        }
        lines.add(currentLine.toString());
        return lines;
    }
}

