/*
 * Decompiled with CFR 0.152.
 */
package thestonedturtle.crabsolver;

import com.google.inject.Provides;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.GameState;
import net.runelite.api.events.GameObjectDespawned;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameStateChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import thestonedturtle.crabsolver.CrabCrystal;
import thestonedturtle.crabsolver.CrabSolverConfig;
import thestonedturtle.crabsolver.CrabSolverOverlay;
import thestonedturtle.crabsolver.CrabTile;

@PluginDescriptor(name="Crab Solver")
public class CrabSolverPlugin
extends Plugin {
    @Inject
    private CrabSolverOverlay overlay;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private CrabSolverConfig config;
    @Inject
    private Client client;
    private final Map<CrabCrystal, GameObject> crystalMap = new HashMap<CrabCrystal, GameObject>();
    private final Collection<CrabTile> tiles = new ArrayList<CrabTile>();

    @Provides
    CrabSolverConfig provideConfig(ConfigManager configManager) {
        return (CrabSolverConfig)configManager.getConfig(CrabSolverConfig.class);
    }

    public void startUp() {
        this.overlayManager.add((Overlay)this.overlay);
        this.loadTiles();
    }

    public void shutDown() {
        this.crystalMap.clear();
        this.overlayManager.remove((Overlay)this.overlay);
        this.tiles.clear();
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged c) {
        if (c.getGameState() == GameState.LOADING) {
            this.crystalMap.clear();
        } else if (c.getGameState() == GameState.LOGGED_IN) {
            this.loadTiles();
        }
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned e) {
        CrabCrystal crystal = CrabCrystal.getByObjectID(e.getGameObject().getId());
        if (crystal == null) {
            return;
        }
        this.crystalMap.put(crystal, e.getGameObject());
    }

    @Subscribe
    public void onGameObjectDespawned(GameObjectDespawned e) {
        CrabCrystal crystal = CrabCrystal.getByObjectID(e.getGameObject().getId());
        if (crystal == null) {
            return;
        }
        this.crystalMap.remove((Object)crystal);
    }

    private void loadTiles() {
        this.tiles.clear();
        int[] regions = this.client.getMapRegions();
        if (regions == null) {
            return;
        }
        for (int region : regions) {
            Collection<CrabTile> regionTiles = CrabTile.getByRegion(region);
            regionTiles.forEach(tile -> tile.setWorldPoints(this.client));
            this.tiles.addAll(regionTiles);
        }
    }

    public Map<CrabCrystal, GameObject> getCrystalMap() {
        return this.crystalMap;
    }

    public Collection<CrabTile> getTiles() {
        return this.tiles;
    }
}

