/*
 * Decompiled with CFR 0.152.
 */
package thestonedturtle.crabsolver;

import com.google.common.base.Strings;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.game.SkillIconManager;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thestonedturtle.crabsolver.CrabSolverConfig;
import thestonedturtle.crabsolver.CrabSolverPlugin;
import thestonedturtle.crabsolver.CrabTile;

public class CrabSolverOverlay
extends Overlay {
    private static final Logger log = LoggerFactory.getLogger(CrabSolverOverlay.class);
    private static final int MAX_RENDER_DISTANCE = 32;
    private final CrabSolverPlugin plugin;
    private final CrabSolverConfig config;
    private final SkillIconManager iconManager;
    private final Client client;

    @Inject
    private CrabSolverOverlay(CrabSolverPlugin plugin, CrabSolverConfig config, SkillIconManager iconManager, Client client) {
        this.plugin = plugin;
        this.config = config;
        this.iconManager = iconManager;
        this.client = client;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
    }

    public Dimension render(Graphics2D graphics) {
        if (this.client.getLocalPlayer() == null) {
            return null;
        }
        WorldPoint playerPosition = this.client.getLocalPlayer().getWorldLocation();
        this.plugin.getCrystalMap().forEach((crabCrystal, gameObject) -> {
            if (playerPosition.distanceTo(gameObject.getWorldLocation()) > 32) {
                return;
            }
            Point point = Perspective.localToCanvas((Client)this.client, (LocalPoint)gameObject.getLocalLocation(), (int)this.client.getPlane(), (int)0);
            if (point == null) {
                return;
            }
            if (this.config.displayColor()) {
                graphics.setColor(crabCrystal.getSolutionColor());
                graphics.fillOval(point.getX() - 11, point.getY() - 11, 22, 22);
            }
            if (this.config.displayStyle() && crabCrystal.getSolutionSkill() != null) {
                BufferedImage icon = this.iconManager.getSkillImage(crabCrystal.getSolutionSkill(), true);
                if (icon == null) {
                    return;
                }
                OverlayUtil.renderImageLocation((Client)this.client, (Graphics2D)graphics, (LocalPoint)gameObject.getLocalLocation(), (BufferedImage)icon, (int)0);
            }
        });
        if (this.config.markTiles()) {
            BasicStroke borderStroke = new BasicStroke((float)this.config.borderWidth());
            for (CrabTile tile : this.plugin.getTiles()) {
                for (WorldPoint p : tile.getWorldPoints()) {
                    if (p.getPlane() != this.client.getPlane() || playerPosition.distanceTo(p) > 32) continue;
                    this.drawTile(graphics, p, tile, borderStroke);
                }
            }
        }
        return null;
    }

    private void drawTile(Graphics2D graphics, WorldPoint p, CrabTile tile, Stroke borderStroke) {
        Point canvasTextLocation;
        LocalPoint lp = LocalPoint.fromWorld((Client)this.client, (WorldPoint)p);
        if (lp == null) {
            return;
        }
        Polygon poly = Perspective.getCanvasTilePoly((Client)this.client, (LocalPoint)lp);
        if (poly != null) {
            OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)poly, (Color)tile.getColor(), (Color)new Color(0, 0, 0, this.config.fillOpacity()), (Stroke)borderStroke);
        }
        if (!Strings.isNullOrEmpty((String)tile.getLabel()) && (canvasTextLocation = Perspective.getCanvasTextLocation((Client)this.client, (Graphics2D)graphics, (LocalPoint)lp, (String)tile.getLabel(), (int)0)) != null) {
            OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)canvasTextLocation, (String)tile.getLabel(), (Color)tile.getColor());
        }
    }
}

