/*
 * Decompiled with CFR 0.152.
 */
package thestonedturtle.crabsolver;

import com.google.common.collect.ImmutableMap;
import java.awt.Color;
import javax.annotation.Nullable;
import net.runelite.api.Skill;

public enum CrabCrystal {
    BLACK(29758, new Color(255, 255, 255, 122), null),
    YELLOW(29761, new Color(0, 0, 255, 122), Skill.MAGIC),
    CYAN(29759, new Color(255, 0, 0, 122), Skill.ATTACK),
    MAGENTA(29760, new Color(0, 255, 0, 122), Skill.RANGED);

    private final int objectID;
    private final Color solutionColor;
    private final Skill solutionSkill;
    private static final ImmutableMap<Integer, CrabCrystal> OBJECT_ID_MAP;

    @Nullable
    public static CrabCrystal getByObjectID(int id) {
        return (CrabCrystal)((Object)OBJECT_ID_MAP.get((Object)id));
    }

    private CrabCrystal(int objectID, Color solutionColor, Skill solutionSkill) {
        this.objectID = objectID;
        this.solutionColor = solutionColor;
        this.solutionSkill = solutionSkill;
    }

    public int getObjectID() {
        return this.objectID;
    }

    public Color getSolutionColor() {
        return this.solutionColor;
    }

    public Skill getSolutionSkill() {
        return this.solutionSkill;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (CrabCrystal crystal : CrabCrystal.values()) {
            builder.put((Object)crystal.getObjectID(), (Object)crystal);
        }
        OBJECT_ID_MAP = builder.build();
    }
}

