/*
 * Decompiled with CFR 0.152.
 */
package com.xpdrops.predictedhit;

import com.google.gson.Gson;
import com.google.gson.internal.LinkedTreeMap;
import com.xpdrops.predictedhit.npcswithscalingbonus.ChambersLayoutSolver;
import com.xpdrops.predictedhit.npcswithscalingbonus.cox.CoXNPCs;
import com.xpdrops.predictedhit.npcswithscalingbonus.toa.ToANPCs;
import com.xpdrops.predictedhit.npcswithscalingbonus.tob.ToBNPCs;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.widgets.Widget;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XpDropDamageCalculator {
    private static final Logger log = LoggerFactory.getLogger(XpDropDamageCalculator.class);
    private static final String NPC_JSON_FILE = "npcs.min.json";
    private static final HashMap<Integer, Double> XP_BONUS_MAPPING = new HashMap();
    private static final Pattern RAID_LEVEL_MATCHER = Pattern.compile("(\\d+)");
    private static final int RAID_LEVEL_WIDGET_ID = 31522858;
    private static final int ROOM_LEVEL_WIDGET_ID = 31522861;
    private static final int RAID_MEMBERS_WIDGET_ID = 31522820;
    private int lastToARaidLevel = 0;
    private int lastToARaidPartySize = 1;
    private int lastToARaidRoomLevel = 0;
    private final Gson GSON;
    private Client client;
    private ChambersLayoutSolver chambersLayoutSolver;

    @Inject
    protected XpDropDamageCalculator(Gson gson, Client client, ChambersLayoutSolver chambersLayoutSolver) {
        this.GSON = gson;
        this.client = client;
        this.chambersLayoutSolver = chambersLayoutSolver;
    }

    public void populateMap() {
        XP_BONUS_MAPPING.clear();
        XP_BONUS_MAPPING.putAll(this.getNpcsWithXpBonus());
    }

    private int getCoXPartySize() {
        return Math.max(1, this.client.getVarbitValue(5424));
    }

    private int getToBPartySize() {
        int count = 0;
        for (int i = 330; i < 335; ++i) {
            String name;
            String jagexName = this.client.getVarcStrValue(i);
            if (jagexName == null || "".equals(name = Text.removeTags((String)jagexName).replace('\u00a0', ' ').trim())) continue;
            ++count;
        }
        return count;
    }

    private int getToAPartySize() {
        Widget[] children;
        Widget memberParentWidget = this.client.getWidget(31522820);
        if (memberParentWidget != null && !memberParentWidget.isHidden() && (children = memberParentWidget.getStaticChildren()) != null && children.length > 0) {
            return (int)Arrays.stream(children).filter(c -> c != null && !c.isHidden()).count();
        }
        return -1;
    }

    private int getToARaidLevel() {
        Matcher m;
        Widget levelWidget = this.client.getWidget(31522858);
        if (levelWidget != null && !levelWidget.isHidden() && (m = RAID_LEVEL_MATCHER.matcher(levelWidget.getText())).find()) {
            try {
                return Integer.parseInt(m.group(0));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return -1;
    }

    private int getToARoomLevel() {
        Widget levelWidget = this.client.getWidget(31522861);
        if (levelWidget != null && !levelWidget.isHidden()) {
            try {
                return Integer.parseInt(Text.sanitize((String)levelWidget.getText()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return -1;
    }

    private int calculateHit(int hpXpDiff, double modifier, double configModifier) {
        if (Math.abs(configModifier) < 1.0E-6) {
            configModifier = 1.0E-6;
        }
        if (modifier < 1.0E-6) {
            return 0;
        }
        return (int)Math.round((double)hpXpDiff * 0.75 / modifier / configModifier);
    }

    public int calculateHitOnPlayer(int cmb, int hpXpDiff, double configModifier) {
        double modifier = Math.min(1.125, 1.0 + Math.floor((double)cmb / 20.0) / 40.0);
        return this.calculateHit(hpXpDiff, modifier, configModifier);
    }

    public int calculateHitOnNpc(int id, int hpXpDiff, double configModifier) {
        double modifier = 1.0;
        if (CoXNPCs.isCOXNPC(id)) {
            int partySize = this.getCoXPartySize();
            int raidType = this.chambersLayoutSolver.isCM() ? 1 : 0;
            modifier = CoXNPCs.getModifier(id, partySize, raidType);
            log.debug("COX modifier {} {} party size {} raid type {}", new Object[]{id, modifier, partySize, raidType});
        } else if (ToBNPCs.isTOBNPC(id)) {
            int partySize = this.getToBPartySize();
            modifier = ToBNPCs.getModifier(id, partySize);
            log.debug("TOB modifier {} {} part size {}", new Object[]{id, modifier, partySize});
        } else if (ToANPCs.isToANPC(id)) {
            int partySize = this.getToAPartySize();
            int roomLevel = this.getToARoomLevel();
            int raidLevel = this.getToARaidLevel();
            if (partySize < 0) {
                partySize = this.lastToARaidPartySize;
            } else {
                this.lastToARaidPartySize = partySize;
            }
            if (roomLevel < 0) {
                roomLevel = this.lastToARaidRoomLevel;
            } else {
                this.lastToARaidRoomLevel = roomLevel;
            }
            if (raidLevel < 0) {
                raidLevel = this.lastToARaidLevel;
            } else {
                this.lastToARaidLevel = raidLevel;
            }
            modifier = ToANPCs.getModifier(id, partySize, raidLevel, roomLevel);
            log.debug("TOA modifier {} {} party size {} raid level {} room level {}", new Object[]{id, modifier, partySize, raidLevel, roomLevel});
        } else if (XP_BONUS_MAPPING.containsKey(id)) {
            modifier = XP_BONUS_MAPPING.get(id);
        }
        return this.calculateHit(hpXpDiff, modifier, configModifier);
    }

    private HashMap<Integer, Double> getNpcsWithXpBonus() {
        HashMap<Integer, Double> map1 = new HashMap<Integer, Double>();
        try (InputStream resource = XpDropDamageCalculator.class.getResourceAsStream(NPC_JSON_FILE);){
            BufferedReader reader = new BufferedReader(new InputStreamReader(resource, StandardCharsets.UTF_8));
            Object jsonResult = this.GSON.fromJson((Reader)reader, Map.class);
            try {
                Map map = (Map)jsonResult;
                for (String id : map.keySet()) {
                    LinkedTreeMap result = (LinkedTreeMap)map.get(id);
                    for (String key : result.keySet()) {
                        Double xpbonus = (Double)result.get((Object)key);
                        xpbonus = (xpbonus + 100.0) / 100.0;
                        map1.put(Integer.parseInt(id), xpbonus);
                    }
                }
            }
            catch (ClassCastException castException) {
                log.warn("Invalid json. Casting to expected hierarchy failed", (Throwable)castException);
            }
        }
        catch (IOException e) {
            log.warn("Couldn't open NPC json file", (Throwable)e);
        }
        return map1;
    }
}

