/*
 * Decompiled with CFR 0.152.
 */
package com.xpdrops.overlay;

import com.xpdrops.config.XpDropsConfig;
import com.xpdrops.overlay.XpDropFontHandler;
import com.xpdrops.overlay.XpDropInFlight;
import com.xpdrops.overlay.XpDropOverlayManager;
import com.xpdrops.overlay.XpDropOverlayUtilities;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.Client;
import net.runelite.api.Point;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XpDropSceneOverlay
extends Overlay {
    private static final Logger log = LoggerFactory.getLogger(XpDropSceneOverlay.class);
    private final XpDropsConfig config;
    private final XpDropOverlayManager xpDropOverlayManager;
    private final XpDropFontHandler xpDropFontHandler = new XpDropFontHandler();
    @Inject
    private Client client;

    @Inject
    private XpDropSceneOverlay(XpDropsConfig config, XpDropOverlayManager xpDropOverlayManager) {
        this.config = config;
        this.xpDropOverlayManager = xpDropOverlayManager;
        this.setLayer(OverlayLayer.UNDER_WIDGETS);
        this.setPosition(OverlayPosition.DYNAMIC);
    }

    public Dimension render(Graphics2D graphics) {
        this.xpDropFontHandler.updateFont(this.config.fontName(), this.config.fontSize(), this.config.fontStyle());
        XpDropOverlayUtilities.setGraphicsProperties(graphics);
        this.xpDropFontHandler.handleFont(graphics);
        if (this.client.getLocalPlayer() != null && this.xpDropOverlayManager.isShouldDraw()) {
            this.drawAttachedXpDrops(graphics);
        }
        return null;
    }

    private Point getCanvasTextLocation(Graphics2D graphics, Actor actor) {
        int zOffset = Math.min(actor.getLogicalHeight(), 140);
        return actor.getCanvasTextLocation(graphics, "x", zOffset);
    }

    private void drawAttachedXpDrops(Graphics2D graphics) {
        for (XpDropInFlight xpDropInFlight : this.xpDropOverlayManager.getXpDropsInFlight()) {
            int x;
            Point point;
            if (xpDropInFlight.getFrame() < 0.0f) continue;
            String text = XpDropOverlayUtilities.getDropText(xpDropInFlight, this.config);
            Actor target = xpDropInFlight.getAttachTo();
            if (target == null || !this.config.attachToTarget()) {
                target = this.client.getLocalPlayer();
            }
            if (target == null || (point = this.getCanvasTextLocation(graphics, target)) == null) continue;
            point = new Point(point.getX() + this.config.attachToOffsetX(), point.getY() - this.config.attachToOffsetY());
            float xStart = xpDropInFlight.getXOffset();
            float yStart = xpDropInFlight.getYOffset();
            int textWidth = graphics.getFontMetrics().stringWidth(Text.removeTags((String)text));
            if (this.config.xpDropCenterOn() == XpDropsConfig.CenterOn.TEXT) {
                x = (int)(xStart + (float)point.getX() - (float)textWidth / 2.0f);
            } else {
                int iconsWidth = XpDropOverlayUtilities.getIconWidthForIcons(graphics, xpDropInFlight.getIcons(), this.config, this.xpDropOverlayManager);
                int totalWidth = textWidth + iconsWidth;
                x = (int)(xStart + (float)point.getX() - (float)totalWidth / 2.0f + (float)iconsWidth);
            }
            int y = (int)(yStart + (float)point.getY());
            XpDropOverlayUtilities.drawText(graphics, text, x, y, (int)xpDropInFlight.getAlpha(), this.config.xpDropBackground());
            int imageX = x - 2;
            int imageY = y - graphics.getFontMetrics().getMaxAscent();
            XpDropOverlayUtilities.drawIcons(graphics, xpDropInFlight.getIcons(), imageX, imageY, xpDropInFlight.getAlpha(), true, this.config, this.xpDropOverlayManager);
        }
    }
}

