/*
 * Decompiled with CFR 0.152.
 */
package com.xpdrops.overlay;

import com.xpdrops.config.XpDropsConfig;
import com.xpdrops.overlay.TextComponentWithAlpha;
import com.xpdrops.overlay.XpDropInFlight;
import com.xpdrops.overlay.XpDropOverlay;
import com.xpdrops.overlay.XpDropOverlayManager;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XpDropOverlayUtilities {
    private static final Logger log = LoggerFactory.getLogger(XpDropOverlayUtilities.class);

    public static Font initRuneScapeBold() {
        Font boldFont;
        try (InputStream inRunescapeBold = XpDropOverlay.class.getResourceAsStream("RuneScape-Bold-12.ttf");){
            if (inRunescapeBold == null) {
                log.warn("Font file could not be loaded.");
                boldFont = new Font("Dialog", 1, 16);
            } else {
                boldFont = Font.createFont(0, inRunescapeBold).deriveFont(0, 16.0f);
            }
        }
        catch (FontFormatException ex) {
            log.warn("Font loaded, but format incorrect.", (Throwable)ex);
            boldFont = new Font("Dialog", 1, 16);
        }
        catch (IOException ex) {
            log.warn("Font file not found.", (Throwable)ex);
            boldFont = new Font("Dialog", 1, 16);
        }
        return boldFont;
    }

    public static String wrapWithTags(String hex) {
        return "<col=" + hex + ">";
    }

    public static String getDropText(XpDropInFlight xpDropInFlight, XpDropsConfig config) {
        String colorTag;
        Object text = XpDropOverlayManager.XP_FORMATTER.format(xpDropInFlight.getAmount());
        if (xpDropInFlight.isPredictedHit()) {
            colorTag = config.predictedHitColorOverride() ? XpDropOverlayUtilities.wrapWithTags(XpDropOverlayUtilities.RGBToHex(config.predictedHitColor().getRGB())) : XpDropOverlayUtilities.wrapWithTags(XpDropOverlayUtilities.RGBToHex(XpDropOverlayUtilities.getColor(xpDropInFlight, config).getRGB()));
            text = colorTag + config.predictedHitPrefix() + (String)text + config.predictedHitSuffix();
        } else {
            colorTag = XpDropOverlayUtilities.wrapWithTags(XpDropOverlayUtilities.RGBToHex(XpDropOverlayUtilities.getColor(xpDropInFlight, config).getRGB()));
            text = colorTag + config.xpDropPrefix() + (String)text + config.xpDropSuffix();
        }
        if (xpDropInFlight.getHit() > 0) {
            String predictedHitColor = "";
            if (config.predictedHitColorOverride()) {
                predictedHitColor = XpDropOverlayUtilities.wrapWithTags(XpDropOverlayUtilities.RGBToHex(config.predictedHitColor().getRGB()));
            }
            text = (String)text + predictedHitColor + " (" + config.predictedHitPrefix() + xpDropInFlight.getHit() + config.predictedHitSuffix() + ")";
        }
        return text;
    }

    public static int getIconWidthForIcons(Graphics2D graphics, int icons, XpDropsConfig config, XpDropOverlayManager xpDropOverlayManager) {
        int _iconSize;
        int width = 0;
        int iconSize = graphics.getFontMetrics().getHeight();
        if (config.iconSizeOverride() > 0) {
            iconSize = config.iconSizeOverride();
        }
        for (int i = XpDropOverlayManager.SKILL_INDICES.length - 1; i >= 0; --i) {
            int index;
            BufferedImage image;
            int icon = icons >> i & 1;
            if (icon != 1 || (image = xpDropOverlayManager.getStatIcon(index = XpDropOverlayManager.SKILL_INDICES[i])) == null) continue;
            int _iconSize2 = Math.max(iconSize, 18);
            int iconWidth = image.getWidth() * _iconSize2 / 25;
            int iconHeight = image.getHeight() * _iconSize2 / 25;
            Dimension dimension = new Dimension(iconWidth, iconHeight);
            width = (int)((double)width + (dimension.getWidth() + 2.0));
        }
        int icon = icons >> 23 & 1;
        if (icon == 1) {
            _iconSize = Math.max(iconSize - 4, 14);
            Dimension dimension = new Dimension(_iconSize, _iconSize);
            width = (int)((double)width + (dimension.getWidth() + 2.0));
        }
        if ((icon = icons >> 24 & 1) == 1) {
            _iconSize = Math.max(iconSize - 4, 14);
            Dimension dimension = new Dimension(_iconSize, _iconSize);
            width = (int)((double)width + (dimension.getWidth() + 2.0));
        }
        return width;
    }

    public static int drawIcons(Graphics2D graphics, int icons, int x, int y, float alpha, boolean rightToLeft, XpDropsConfig config, XpDropOverlayManager xpDropOverlayManager) {
        Dimension dimension;
        int _iconSize;
        int width = 0;
        int iconSize = graphics.getFontMetrics().getHeight();
        if (config.iconSizeOverride() > 0) {
            iconSize = config.iconSizeOverride();
        }
        for (int i = XpDropOverlayManager.SKILL_INDICES.length - 1; i >= 0; --i) {
            int index;
            BufferedImage image;
            int icon = icons >> i & 1;
            if (icon != 1 || (image = xpDropOverlayManager.getStatIcon(index = XpDropOverlayManager.SKILL_INDICES[i])) == null) continue;
            int _iconSize2 = Math.max(iconSize, 18);
            int iconWidth = image.getWidth() * _iconSize2 / 25;
            int iconHeight = image.getHeight() * _iconSize2 / 25;
            Dimension dimension2 = XpDropOverlayUtilities.drawIcon(graphics, image, x, y, iconWidth, iconHeight, alpha / 255.0f, rightToLeft);
            x = rightToLeft ? (int)((double)x - (dimension2.getWidth() + 2.0)) : (int)((double)x + (dimension2.getWidth() + 2.0));
            width = (int)((double)width + (dimension2.getWidth() + 2.0));
        }
        int icon = icons >> 23 & 1;
        if (icon == 1) {
            BufferedImage image = xpDropOverlayManager.getFakeSkillIcon();
            _iconSize = Math.max(iconSize - 4, 14);
            dimension = XpDropOverlayUtilities.drawIcon(graphics, image, x, y, _iconSize, _iconSize, alpha / 255.0f, rightToLeft);
            width = (int)((double)width + (dimension.getWidth() + 2.0));
        }
        if ((icon = icons >> 24 & 1) == 1) {
            BufferedImage image = xpDropOverlayManager.getHitsplatIcon();
            _iconSize = Math.max(iconSize - 4, 14);
            dimension = XpDropOverlayUtilities.drawIcon(graphics, image, x, y, _iconSize, _iconSize, alpha / 255.0f, rightToLeft);
            width = (int)((double)width + (dimension.getWidth() + 2.0));
        }
        return width;
    }

    public static Dimension drawIcon(Graphics2D graphics, BufferedImage image, int x, int y, int width, int height, float alpha, boolean rightToLeft) {
        int yOffset = graphics.getFontMetrics().getHeight() / 2 - height / 2;
        int xOffset = rightToLeft ? width : 0;
        Composite composite = graphics.getComposite();
        graphics.setComposite(AlphaComposite.getInstance(3, alpha));
        graphics.drawImage(image, x - xOffset, y + yOffset, width, height, null);
        graphics.setComposite(composite);
        return new Dimension(width, height);
    }

    public static Color getColor(XpDropInFlight xpDropInFlight, XpDropsConfig config) {
        switch (xpDropInFlight.getStyle()) {
            case DEFAULT: {
                return config.xpDropColor();
            }
            case MELEE: {
                return config.xpDropColorMelee();
            }
            case MAGE: {
                return config.xpDropColorMage();
            }
            case RANGE: {
                return config.xpDropColorRange();
            }
        }
        return Color.WHITE;
    }

    public static void setGraphicsProperties(Graphics2D graphics) {
        graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
    }

    public static Dimension drawText(Graphics2D graphics, String text, int textX, int textY, int alpha, TextComponentWithAlpha.Background background) {
        TextComponentWithAlpha textComponent = new TextComponentWithAlpha();
        textComponent.setText(text);
        textComponent.setAlphaOverride(alpha);
        textComponent.setPosition(new Point(textX, textY));
        textComponent.setBackground(background);
        return textComponent.render(graphics);
    }

    public static String RGBToHex(int rgb) {
        StringBuilder hex = new StringBuilder(Integer.toHexString(rgb));
        if (hex.length() < 8) {
            while (hex.length() < 8) {
                hex.insert(0, "0");
            }
        }
        return hex.toString();
    }
}

