/*
 * Decompiled with CFR 0.152.
 */
package com.xpdrops.overlay;

import com.xpdrops.config.XpDropsConfig;
import com.xpdrops.overlay.XpDropFontHandler;
import com.xpdrops.overlay.XpDropInFlight;
import com.xpdrops.overlay.XpDropOverlayManager;
import com.xpdrops.overlay.XpDropOverlayUtilities;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XpDropOverlay
extends Overlay {
    private static final Logger log = LoggerFactory.getLogger(XpDropOverlay.class);
    private final XpDropsConfig config;
    private final XpDropOverlayManager xpDropOverlayManager;
    private final XpDropFontHandler xpDropFontHandler = new XpDropFontHandler();

    @Inject
    private XpDropOverlay(XpDropsConfig config, XpDropOverlayManager xpDropOverlayManager) {
        this.config = config;
        this.xpDropOverlayManager = xpDropOverlayManager;
        this.setLayer(OverlayLayer.UNDER_WIDGETS);
        this.setPosition(OverlayPosition.TOP_RIGHT);
        this.setPriority(config.xpDropOverlayPriority());
    }

    public Dimension render(Graphics2D graphics) {
        this.xpDropFontHandler.updateFont(this.config.fontName(), this.config.fontSize(), this.config.fontStyle());
        XpDropOverlayUtilities.setGraphicsProperties(graphics);
        this.xpDropFontHandler.handleFont(graphics);
        if (this.xpDropOverlayManager.isShouldDraw()) {
            this.drawXpDrops(graphics);
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int width = fontMetrics.stringWidth("###,###,###");
        width = (int)((float)width + Math.abs((float)(this.config.framesPerDrop() * this.config.xPixelsPerSecond()) / 50.0f));
        int height = fontMetrics.getHeight();
        height = (int)((float)height + Math.abs((float)(this.config.framesPerDrop() * this.config.yPixelsPerSecond()) / 50.0f));
        return new Dimension(width, height);
    }

    private void drawXpDrops(Graphics2D graphics) {
        int width = graphics.getFontMetrics().stringWidth("###,###,###");
        int totalWidth = width + (int)Math.abs((float)(this.config.framesPerDrop() * this.config.xPixelsPerSecond()) / 50.0f);
        int height = graphics.getFontMetrics().getHeight();
        int totalHeight = height + (int)Math.abs((float)(this.config.framesPerDrop() * this.config.yPixelsPerSecond()) / 50.0f);
        for (XpDropInFlight xpDropInFlight : this.xpDropOverlayManager.getXpDropsInFlight()) {
            int textX;
            int imageY;
            int imageX;
            if (xpDropInFlight.getFrame() < 0.0f) continue;
            String text = this.getDropText(xpDropInFlight);
            float xStart = xpDropInFlight.getXOffset();
            float yStart = xpDropInFlight.getYOffset();
            int textY = this.config.yDirection() == XpDropsConfig.VerticalDirection.DOWN ? (int)(yStart + (float)graphics.getFontMetrics().getMaxAscent()) : (int)((float)totalHeight + yStart + (float)graphics.getFontMetrics().getMaxAscent() - (float)graphics.getFontMetrics().getHeight());
            if (this.config.xpDropForceCentered()) {
                int x;
                int textWidth = graphics.getFontMetrics().stringWidth(Text.removeTags((String)text));
                if (this.config.xpDropCenterOn() == XpDropsConfig.CenterOn.TEXT) {
                    x = (int)((float)totalWidth / 2.0f - (float)textWidth / 2.0f + xStart);
                } else {
                    int iconsWidth = XpDropOverlayUtilities.getIconWidthForIcons(graphics, xpDropInFlight.getIcons(), this.config, this.xpDropOverlayManager);
                    x = (int)((float)totalWidth / 2.0f - (float)(textWidth + iconsWidth) / 2.0f + (float)iconsWidth + xStart);
                }
                XpDropOverlayUtilities.drawText(graphics, text, x, textY, (int)xpDropInFlight.getAlpha(), this.config.xpDropBackground());
                int imageX2 = x - 2;
                int imageY2 = textY - graphics.getFontMetrics().getMaxAscent();
                XpDropOverlayUtilities.drawIcons(graphics, xpDropInFlight.getIcons(), imageX2, imageY2, xpDropInFlight.getAlpha(), true, this.config, this.xpDropOverlayManager);
                continue;
            }
            if (this.config.xDirection() == XpDropsConfig.HorizontalDirection.RIGHT) {
                imageX = (int)xStart;
                imageY = textY - graphics.getFontMetrics().getMaxAscent();
                int imageWidth = this.drawIcons(graphics, xpDropInFlight.getIcons(), imageX, imageY, xpDropInFlight.getAlpha(), false);
                textX = imageX + imageWidth;
                XpDropOverlayUtilities.drawText(graphics, text, textX, textY, (int)xpDropInFlight.getAlpha(), this.config.xpDropBackground());
                continue;
            }
            textX = (int)((float)totalWidth + xStart - (float)graphics.getFontMetrics().stringWidth(Text.removeTags((String)text)));
            XpDropOverlayUtilities.drawText(graphics, text, textX, textY, (int)xpDropInFlight.getAlpha(), this.config.xpDropBackground());
            imageX = textX - 2;
            imageY = textY - graphics.getFontMetrics().getMaxAscent();
            this.drawIcons(graphics, xpDropInFlight.getIcons(), imageX, imageY, xpDropInFlight.getAlpha(), true);
        }
    }

    private String getDropText(XpDropInFlight xpDropInFlight) {
        return XpDropOverlayUtilities.getDropText(xpDropInFlight, this.config);
    }

    private int drawIcons(Graphics2D graphics, int icons, int x, int y, float alpha, boolean rightToLeft) {
        return XpDropOverlayUtilities.drawIcons(graphics, icons, x, y, alpha, rightToLeft, this.config, this.xpDropOverlayManager);
    }
}

