/*
 * Decompiled with CFR 0.152.
 */
package com.xpdrops.overlay;

import com.xpdrops.config.XpDropsConfig;
import com.xpdrops.overlay.XpDropOverlayManager;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import net.runelite.client.ui.FontManager;

public class XpDropFontHandler {
    private String lastFont = "";
    private int lastFontSize = 0;
    private boolean useRunescapeFont = true;
    private XpDropsConfig.FontStyle lastFontStyle = XpDropsConfig.FontStyle.DEFAULT;
    private Font font = null;

    public void handleFont(Graphics2D graphics) {
        if (this.font != null) {
            graphics.setFont(this.font);
            if (this.useRunescapeFont) {
                graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            }
        }
    }

    public void updateFont(String fontName, int fontSize, XpDropsConfig.FontStyle fontStyle) {
        if (!this.lastFont.equals(fontName) || this.lastFontSize != fontSize || this.lastFontStyle != fontStyle) {
            this.lastFont = fontName;
            this.lastFontSize = fontSize;
            this.lastFontStyle = fontStyle;
            int style = fontStyle.getStyle();
            if ("".equals(fontName)) {
                if (fontSize < 16) {
                    this.font = FontManager.getRunescapeSmallFont();
                } else if (fontStyle == XpDropsConfig.FontStyle.BOLD || fontStyle == XpDropsConfig.FontStyle.BOLD_ITALICS) {
                    this.font = XpDropOverlayManager.RUNESCAPE_BOLD_FONT;
                    style ^= 1;
                } else {
                    this.font = FontManager.getRunescapeFont();
                }
                float size = Math.max(16.0f, (float)fontSize);
                this.font = this.font.deriveFont(style, size);
                this.useRunescapeFont = true;
                return;
            }
            this.font = new Font(fontName, style, fontSize);
            this.useRunescapeFont = false;
        }
    }
}

