/*
 * Decompiled with CFR 0.152.
 */
package com.stevenwaterman.blindfold;

import com.google.inject.Provides;
import com.stevenwaterman.blindfold.BlindfoldOverlay;
import com.stevenwaterman.blindfold.BlindfoldPluginConfig;
import com.stevenwaterman.blindfold.DisableRenderCallbacks;
import java.util.HashSet;
import java.util.Objects;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.Client;
import net.runelite.api.DynamicObject;
import net.runelite.api.GameState;
import net.runelite.api.GraphicsObject;
import net.runelite.api.Model;
import net.runelite.api.ModelData;
import net.runelite.api.Projectile;
import net.runelite.api.Renderable;
import net.runelite.api.RuneLiteObject;
import net.runelite.api.Scene;
import net.runelite.api.SceneTileModel;
import net.runelite.api.SceneTilePaint;
import net.runelite.api.Texture;
import net.runelite.api.TileItem;
import net.runelite.api.events.FocusChanged;
import net.runelite.api.hooks.DrawCallbacks;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.events.NotificationFired;
import net.runelite.client.events.PluginChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Blindfold", description="Stops things rendering (requires GPU)", tags={"blindfold", "blind", "black", "greenscreen", "render"})
public class BlindfoldPlugin
extends Plugin
implements DrawCallbacks {
    private static final Logger log = LoggerFactory.getLogger(BlindfoldPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private BlindfoldPluginConfig config;
    @Inject
    private BlindfoldOverlay overlay;
    private DrawCallbacks interceptedDrawCallbacks;
    private final HashSet<Plugin> interceptedPlugins = new HashSet();
    private final DisableRenderCallbacks DISABLE_RENDERING = new DisableRenderCallbacks();

    @Provides
    BlindfoldPluginConfig provideConfig(ConfigManager configManager) {
        return (BlindfoldPluginConfig)configManager.getConfig(BlindfoldPluginConfig.class);
    }

    protected void startUp() {
        this.overlayManager.add((Overlay)this.overlay);
        this.clientThread.invokeLater(() -> this.interceptDrawCalls());
    }

    protected void shutDown() {
        this.overlayManager.remove((Overlay)this.overlay);
        this.clientThread.invokeLater(() -> {
            if (this.client.getDrawCallbacks() == this || this.client.getDrawCallbacks() == this.DISABLE_RENDERING) {
                this.client.setDrawCallbacks(this.interceptedDrawCallbacks);
            }
            this.interceptedDrawCallbacks = null;
            this.interceptedPlugins.clear();
        });
    }

    @Subscribe
    public void onPluginChanged(PluginChanged pluginChanged) {
        Plugin plugin = pluginChanged.getPlugin();
        if (plugin == this) {
            return;
        }
        this.clientThread.invokeLater(() -> {
            if (pluginChanged.isLoaded()) {
                if (this.interceptedPlugins.contains(plugin)) {
                    return;
                }
                if (this.interceptDrawCalls()) {
                    this.interceptedPlugins.add(plugin);
                }
            } else if (this.client.getDrawCallbacks() == null) {
                this.interceptedDrawCallbacks = null;
                this.interceptedPlugins.clear();
            } else {
                this.interceptedPlugins.remove(plugin);
            }
        });
    }

    private boolean interceptDrawCalls() {
        assert (this.client.isClientThread());
        if (this.client.getGameState() == GameState.LOADING) {
            return false;
        }
        if (!this.client.isGpu()) {
            return false;
        }
        DrawCallbacks drawCallbacks = this.client.getDrawCallbacks();
        if (drawCallbacks == null) {
            return false;
        }
        if (drawCallbacks == this || drawCallbacks == this.DISABLE_RENDERING) {
            return false;
        }
        this.interceptedDrawCallbacks = drawCallbacks;
        this.client.setDrawCallbacks((DrawCallbacks)this);
        return true;
    }

    public void drawScene(double cameraX, double cameraY, double cameraZ, double cameraPitch, double cameraYaw, int plane) {
        if (this.interceptedDrawCallbacks != null) {
            this.interceptedDrawCallbacks.drawScene(cameraX, cameraY, cameraZ, cameraPitch, cameraYaw, plane);
        }
    }

    public void drawScene(int cameraX, int cameraY, int cameraZ, int cameraPitch, int cameraYaw, int plane) {
        if (this.interceptedDrawCallbacks != null) {
            this.interceptedDrawCallbacks.drawScene(cameraX, cameraY, cameraZ, cameraPitch, cameraYaw, plane);
        }
    }

    public void postDrawScene() {
        if (this.interceptedDrawCallbacks != null) {
            this.interceptedDrawCallbacks.postDrawScene();
        }
    }

    public void animate(Texture texture, int diff) {
        if (this.interceptedDrawCallbacks != null) {
            this.interceptedDrawCallbacks.animate(texture, diff);
        }
    }

    public boolean tileInFrustum(Scene scene, int pitchSin, int pitchCos, int yawSin, int yawCos, int cameraX, int cameraY, int cameraZ, int plane, int msx, int msy) {
        if (this.interceptedDrawCallbacks != null) {
            this.interceptedDrawCallbacks.tileInFrustum(scene, pitchSin, pitchCos, yawSin, yawCos, cameraX, cameraY, cameraZ, plane, msx, msy);
        }
        return true;
    }

    @Subscribe
    public void onFocusChanged(FocusChanged event) {
        if (this.client.getGameState() == GameState.LOGGED_IN && this.config.disableRendering() && !event.isFocused()) {
            this.clientThread.invoke(() -> this.client.setDrawCallbacks((DrawCallbacks)this.DISABLE_RENDERING));
            log.debug("Focus changed: rendering disabled");
        } else if (this.client.getDrawCallbacks() == this.DISABLE_RENDERING) {
            this.clientThread.invoke(() -> this.client.setDrawCallbacks((DrawCallbacks)this));
            log.debug("Focus changed: rendering reenabled");
        }
    }

    @Subscribe
    public void onNotificationFired(NotificationFired event) {
        if (this.client.getDrawCallbacks() == this.DISABLE_RENDERING) {
            this.clientThread.invoke(() -> this.client.setDrawCallbacks((DrawCallbacks)this));
            log.debug("notification sent: rendering reenabled");
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!Objects.equals(event.getGroup(), "blindfold")) {
            return;
        }
        if (Objects.equals(event.getKey(), "disableRendering") && Objects.equals(event.getNewValue(), "false") && this.client.getDrawCallbacks() == this.DISABLE_RENDERING) {
            this.clientThread.invoke(() -> this.client.setDrawCallbacks((DrawCallbacks)this));
        }
    }

    public void loadScene(Scene scene) {
        if (this.interceptedDrawCallbacks != null) {
            this.interceptedDrawCallbacks.loadScene(scene);
        }
    }

    public void swapScene(Scene scene) {
        if (this.interceptedDrawCallbacks != null) {
            this.interceptedDrawCallbacks.swapScene(scene);
        }
    }

    public void drawScenePaint(int orientation, int pitchSin, int pitchCos, int yawSin, int yawCos, int x, int y, int z, SceneTilePaint paint, int tileZ, int tileX, int tileY, int zoom, int centerX, int centerY) {
        if (this.interceptedDrawCallbacks != null && this.config.enableTerrain()) {
            this.interceptedDrawCallbacks.drawScenePaint(orientation, pitchSin, pitchCos, yawSin, yawCos, x, y, z, paint, tileZ, tileX, tileY, zoom, centerX, centerY);
        }
    }

    public void drawSceneModel(int orientation, int pitchSin, int pitchCos, int yawSin, int yawCos, int x, int y, int z, SceneTileModel model, int tileZ, int tileX, int tileY, int zoom, int centerX, int centerY) {
        if (this.interceptedDrawCallbacks != null && this.config.enableTerrain()) {
            this.interceptedDrawCallbacks.drawSceneModel(orientation, pitchSin, pitchCos, yawSin, yawCos, x, y, z, model, tileZ, tileX, tileY, zoom, centerX, centerY);
        }
    }

    public void draw(int overlayColor) {
        if (this.interceptedDrawCallbacks != null) {
            this.interceptedDrawCallbacks.draw(overlayColor);
        }
    }

    public void draw(Renderable renderable, int orientation, int pitchSin, int pitchCos, int yawSin, int yawCos, int x, int y, int z, long hash) {
        boolean render;
        if (this.interceptedDrawCallbacks == null) {
            return;
        }
        boolean isRuneLiteObject = renderable instanceof RuneLiteObject;
        boolean bl = render = renderable == this.client.getLocalPlayer() || this.config.enableScenery() && (renderable instanceof Model || renderable instanceof ModelData || !isRuneLiteObject && renderable instanceof GraphicsObject || renderable instanceof DynamicObject) || this.config.enableEntities() && (renderable instanceof Projectile || renderable instanceof TileItem || renderable instanceof Actor) || isRuneLiteObject && this.config.enableRuneLiteObjects();
        if (render) {
            this.interceptedDrawCallbacks.draw(renderable, orientation, pitchSin, pitchCos, yawSin, yawCos, x, y, z, hash);
        } else {
            Model model;
            Model model2 = model = renderable instanceof Model ? (Model)renderable : renderable.getModel();
            if (model == null) {
                return;
            }
            if (model != renderable) {
                renderable.setModelHeight(model.getModelHeight());
            }
            if (!this.isVisible(model, pitchSin, pitchCos, yawSin, yawCos, x, y, z)) {
                return;
            }
            this.client.checkClickbox(model, orientation, pitchSin, pitchCos, yawSin, yawCos, x, y, z, hash);
        }
    }

    private boolean isVisible(Model model, int pitchSin, int pitchCos, int yawSin, int yawCos, int x, int y, int z) {
        int yheight;
        int ybottom;
        int ry;
        int var20;
        int var17;
        int rx;
        int var16;
        model.calculateBoundsCylinder();
        int xzMag = model.getXYZMag();
        int bottomY = model.getBottomY();
        int zoom = this.client.get3dZoom();
        int modelHeight = model.getModelHeight();
        int Rasterizer3D_clipMidX2 = this.client.getRasterizer3D_clipMidX2();
        int Rasterizer3D_clipNegativeMidX = this.client.getRasterizer3D_clipNegativeMidX();
        int Rasterizer3D_clipNegativeMidY = this.client.getRasterizer3D_clipNegativeMidY();
        int Rasterizer3D_clipMidY2 = this.client.getRasterizer3D_clipMidY2();
        int var11 = yawCos * z - yawSin * x >> 16;
        int var12 = pitchSin * y + pitchCos * var11 >> 16;
        int var13 = pitchCos * xzMag >> 16;
        int depth = var12 + var13;
        if (depth > 50 && (var16 = ((rx = z * yawSin + yawCos * x >> 16) - xzMag) * zoom) / depth < Rasterizer3D_clipMidX2 && (var17 = (rx + xzMag) * zoom) / depth > Rasterizer3D_clipNegativeMidX && (var20 = ((ry = pitchCos * y - var11 * pitchSin >> 16) + (ybottom = (pitchCos * bottomY >> 16) + (yheight = pitchSin * xzMag >> 16))) * zoom) / depth > Rasterizer3D_clipNegativeMidY) {
            int ytop = (pitchCos * modelHeight >> 16) + yheight;
            int var22 = (ry - ytop) * zoom;
            return var22 / depth < Rasterizer3D_clipMidY2;
        }
        return false;
    }
}

