/*
 * Decompiled with CFR 0.152.
 */
package com.stevenwaterman.blindfold;

import com.stevenwaterman.blindfold.BlindfoldPluginConfig;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;

public class BlindfoldOverlay
extends Overlay {
    private static final Color TRANSPARENT = new Color(0, 0, 0, 0);
    @Inject
    private Client client;
    @Inject
    private BlindfoldPluginConfig config;

    public BlindfoldOverlay() {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ALWAYS_ON_TOP);
        this.setPriority(OverlayPriority.HIGHEST);
    }

    public Dimension render(Graphics2D g) {
        if (this.client.isGpu() && !this.config.enableUi()) {
            Rectangle bounds = g.getClipBounds();
            g.setBackground(TRANSPARENT);
            g.clearRect(0, 0, bounds.width, bounds.height);
            g.setColor(TRANSPARENT);
            g.fillRect(0, 0, bounds.width, bounds.height);
        }
        return null;
    }
}

