/*
 * Decompiled with CFR 0.152.
 */
package com.rang.forestrycc;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

enum Location {
    NMAGE("North Sorcerer's Tower (Nmage)", List.of("nmage", "n mage", "north mage"), null, false, false, 11126),
    SMAGE("South Sorcerer's Tower (Smage)", List.of("smage", "s mage", "south mage"), null, false, false, 1052),
    DRAY("Draynor (Dray)", List.of("draynor", "dray"), null, false, false, 1519),
    CHURCH("Seers Church (Church)", List.of("church", "churc", "curch", "churh", "chrch", "chuch"), null, false, false, 1718),
    N_SEERS("North Seers (NSeers)", List.of("north seers", "north seer", "n seers", "nseers", "n seer", "nseer", "n sears", "nsears"), List.of("bank", "south", "s"), false, true, 1517),
    SEERS("Seers (S Seers/Seers Bank)", List.of("seer oaks", "seers oaks", "seer oak", "seers oak", "seers bank", "seer bank", "s seers", "sseers", "s seer", "sseer", "seers", "seer", "s sears", "ssears", "sears", "sear"), List.of("n", "north", "nseers"), false, true, 8010),
    GLADE("Xeric's Glade (Glade)", List.of("glade"), null, false, false, 13393),
    HIVE("Seers Beehives (Hive)", List.of("hives", "hive"), null, false, false, 28184),
    ZALC("Zalcano (Zalc)", List.of("zalc"), null, false, false, 23908),
    MYTH("Myth's Guild (Myth)", List.of("myths", "myth"), null, false, false, 22114),
    ARC("Arceuus Magics (Arc)", List.of("arc"), null, false, false, 25818),
    PRIF("Prifddinas (Prif Teaks/Prif Mahog)", List.of("prif teaks", "prif teak", "prif t", "prif mahogs", "prif mahog", "prif m", "prift", "prifm", "prif"), null, false, false, 6103),
    YAK("Neitiznot (Yak)", List.of("yakki boo", "yakki", "yak", "arctic pines", "arctic pine", "arctic"), null, false, false, 10828),
    GEYEWS("GE Yews", List.of("ge"), null, true, false, 617),
    RIMM("Rimmington (Rimm)", List.of("Rimmington", "rimm", "rim"), null, false, false, 8794),
    LOOK("Xeric's Lookout (Lookout)", List.of("lookout"), null, false, false, 1195),
    WOOD("Kourend Woodland (Woodland)", List.of("woodland"), null, false, false, 22947),
    OUTPOST("Barbarian Outpost (Barb)", List.of("barbarian outpost", "barbarian", "outpost", "barb"), null, false, false, 3853);

    private static final Map<String, Location> locations;
    private final String name;
    public final List<String> match_filters;
    public final List<String> exclude_filters;
    private final boolean match_strict;
    private final boolean exclude_strict;
    private final int itemSpriteId;

    private Location(String name, List<String> match_filters, List<String> exclude_filters, boolean match_strict, boolean exclude_strict, int itemSpriteId) {
        this.name = name;
        this.match_filters = match_filters;
        this.exclude_filters = exclude_filters;
        this.match_strict = match_strict;
        this.exclude_strict = exclude_strict;
        this.itemSpriteId = itemSpriteId;
    }

    public String getName() {
        return this.name;
    }

    public Integer getSize() {
        return locations.size();
    }

    public boolean isMatch(String msg) {
        block12: {
            String[] msg_split = msg.split(" ");
            String first_three_words = null;
            Integer num_spaces = msg_split.length;
            if (num_spaces > 3) {
                num_spaces = 3;
            }
            first_three_words = String.join((CharSequence)" ", Arrays.copyOfRange(msg_split, 0, (int)num_spaces));
            if (this.exclude_filters != null) {
                if (this.exclude_strict) {
                    for (String string : msg_split) {
                        for (String value : this.exclude_filters) {
                            if (!string.equals(value)) continue;
                            return false;
                        }
                    }
                } else {
                    for (String value : this.exclude_filters) {
                        if (!first_three_words.contains(value)) continue;
                        return false;
                    }
                }
            }
            if (this.match_filters == null) break block12;
            if (this.match_strict) {
                for (String string : msg_split) {
                    for (String value : this.match_filters) {
                        if (!string.equals(value)) continue;
                        return true;
                    }
                }
            } else {
                for (String value : this.match_filters) {
                    if (!first_three_words.contains(value)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isRevive(String msg) {
        String[] confirmed_strings;
        for (String value : confirmed_strings = new String[]{"not dead", "alive", "still here", "not d", "still up", "still going", "real", "still", "stil"}) {
            if (!msg.contains(value)) continue;
            return true;
        }
        return false;
    }

    public boolean isConfirmed(String msg) {
        String[] msg_split;
        String[] confirmed_strings = new String[]{"confirmed", "confirm", "conf", "con*", "real", "alive", "c"};
        for (String split_value : msg_split = msg.split(" ")) {
            for (String value : confirmed_strings) {
                if (!split_value.matches(value)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isDead(String msg) {
        String[] msg_split;
        String[] confirmed_strings = new String[]{"murder", "bust", "rip", "clear", "cleared", "busted", "dead", "done", "ded", "dea", "d"};
        for (String split_value : msg_split = msg.split(" ")) {
            for (String value : confirmed_strings) {
                if (!split_value.matches(value)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isFake(String msg) {
        String[] msg_split;
        String[] confirmed_strings = new String[]{"fake"};
        for (String split_value : msg_split = msg.split(" ")) {
            for (String value : confirmed_strings) {
                if (!split_value.matches(value)) continue;
                return true;
            }
        }
        return false;
    }

    public int getItemSpriteId() {
        return this.itemSpriteId;
    }

    public static Location find(String msg) {
        for (String key : locations.keySet()) {
            if (!locations.get(key).isMatch(msg)) continue;
            return locations.get(key);
        }
        return null;
    }

    public static Location findFromName(String rootName) {
        for (String key : locations.keySet()) {
            if (!locations.get(key).getName().equals(rootName)) continue;
            return locations.get(key);
        }
        return null;
    }

    static {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (Location roots : Location.values()) {
            builder.put((Object)roots.getName(), (Object)roots);
        }
        locations = builder.build();
    }
}

