/*
 * Decompiled with CFR 0.152.
 */
package com.rang.forestrycc;

import com.google.inject.Provides;
import com.rang.forestrycc.ForestryccConfig;
import com.rang.forestrycc.ForestryccTimer;
import com.rang.forestrycc.Location;
import java.awt.image.BufferedImage;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameTick;
import net.runelite.client.Notifier;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import net.runelite.client.util.AsyncBufferedImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Forestry CC")
public class ForestryccPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ForestryccPlugin.class);
    @Inject
    private InfoBoxManager infoBoxManager;
    @Inject
    private ItemManager itemManager;
    @Inject
    private Client client;
    @Inject
    private Notifier notifier;
    @Inject
    private ForestryccConfig config;
    private long event_duration_default = 120L;
    private long event_duration_bees = 180L;
    private List<String> events_alive = new ArrayList<String>();
    private HashMap<String, Instant> events_starttime = new HashMap();
    private HashMap<String, Instant> events_timeofdeath = new HashMap();
    private HashMap<String, Integer> events_confirmed = new HashMap();
    private HashMap<String, String> events_type = new HashMap();
    private List<String> bee_filters = List.of("bees", "bee", "b");
    private List<String> root_filters = List.of("roots", "root", "r");
    private List<String> sap_filters = List.of("sapling", "saps", "sap");
    private List<String> banned_words = List.of("?", "\"", "=", "where", "wher", "wehre", "were", "what", "waht", "wat", "wht");
    private List<String> unsupported_chars = List.of(",", "'", "/", "-", "_", "(", ")");
    private List<String> excessive_spaces = List.of("          ", "         ", "        ", "       ", "      ", "     ", "    ", "   ", "  ");
    private long death_timeout = 6L;
    private long revive_timeout = 10L;
    String chat_msg_orignal;
    String chat_msg;

    protected void startUp() throws Exception {
        log.info("Forestry CC started!");
        for (Location r : Location.values()) {
            this.events_starttime.put(r.getName(), Instant.now());
            this.events_timeofdeath.put(r.getName(), Instant.now());
            this.events_type.put(r.getName(), null);
        }
    }

    protected void shutDown() throws Exception {
        log.info("Forestry CC stopped!");
        this.infoBoxManager.removeIf(t -> t instanceof ForestryccTimer);
    }

    private boolean validChatMsg(ChatMessage chatMessage) {
        String msg_text = chatMessage.getMessage().toLowerCase();
        if (chatMessage.getSender() == null) {
            return false;
        }
        if (!chatMessage.getMessageNode().getType().equals((Object)ChatMessageType.FRIENDSCHAT)) {
            return false;
        }
        if (msg_text.length() > 25) {
            return false;
        }
        for (String banned : this.banned_words) {
            if (!msg_text.contains(banned)) continue;
            return false;
        }
        return true;
    }

    private String classifyEvent() {
        String[] msg_split;
        for (String split_value : msg_split = this.chat_msg.split(" ")) {
            for (String value : this.bee_filters) {
                if (!split_value.equals(value)) continue;
                return "BEES";
            }
        }
        for (String split_value : msg_split) {
            for (String value : this.root_filters) {
                if (!split_value.equals(value)) continue;
                return "ROOTS";
            }
        }
        for (String split_value : msg_split) {
            for (String value : this.sap_filters) {
                if (!split_value.equals(value)) continue;
                return "SAP";
            }
        }
        return null;
    }

    private void clean_chat_msg() {
        for (String c : this.unsupported_chars) {
            this.chat_msg = this.chat_msg.replace(c, "");
        }
        for (String excessive_space : this.excessive_spaces) {
            this.chat_msg = this.chat_msg.replace(excessive_space, " ");
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) {
        if (this.validChatMsg(chatMessage)) {
            Location event;
            String chat_msg_substring;
            this.chat_msg = this.chat_msg_orignal = chatMessage.getMessage().toLowerCase();
            this.clean_chat_msg();
            String event_type = this.classifyEvent();
            if (event_type != null) {
                if (event_type.equals("BEES") && !this.config.beesEnabled()) {
                    return;
                }
                if (event_type.equals("SAP") && !this.config.sapsEnabled()) {
                    return;
                }
                if (event_type.equals("ROOTS") && !this.config.rootsEnabled()) {
                    return;
                }
                if (event_type.equals("BEES")) {
                    this.chat_msg = this.chat_msg.replace("bee", "");
                    this.chat_msg = this.chat_msg.replace("bees", "");
                } else if (event_type.equals("SAP")) {
                    this.chat_msg = this.chat_msg.replace("sapling", "");
                    this.chat_msg = this.chat_msg.replace("saps", "");
                    this.chat_msg = this.chat_msg.replace("sap", "");
                    this.chat_msg = this.chat_msg.replace("mulch", "");
                } else if (event_type.equals("ROOTS")) {
                    this.chat_msg = this.chat_msg.replace("roots", "");
                    this.chat_msg = this.chat_msg.replace("root", "");
                }
            }
            if ((chat_msg_substring = this.chat_msg).length() > 17) {
                chat_msg_substring = chat_msg_substring.substring(0, 17);
            }
            if ((event = Location.find(chat_msg_substring)) != null) {
                this.displayTimer(event, event_type, this.chat_msg);
            }
        }
    }

    @Subscribe
    public void onGameTick(GameTick tickEvent) {
        if (this.client.getTickCount() % 5 == 0) {
            this.activeRootsRemoveExpired();
            this.activeRootsExpirationWarning();
        }
    }

    private boolean activeRootsExpiringSoon(String locationName) {
        long event_alive_for;
        long duration = this.eventDuration(this.events_type.get(locationName));
        return duration - (event_alive_for = Duration.between(this.events_starttime.get(locationName), Instant.now()).toSeconds()) < Long.valueOf(this.config.expirationWarnTime());
    }

    private void activeRootsExpirationWarning() {
        if (!this.config.expirationWarning()) {
            return;
        }
        for (String locationName : this.events_alive) {
            Location event;
            if (!this.activeRootsExpiringSoon(locationName) || (event = Location.findFromName(locationName)) == null) continue;
            this.updateTimerImage(event, this.itemManager.getImage(1982));
        }
    }

    private void activeRootsRemoveExpired() {
        for (int e = 0; e < this.events_alive.size(); ++e) {
            long duration = this.eventDuration(this.events_type.get(this.events_alive.get(e)));
            if (Duration.between(this.events_starttime.get(this.events_alive.get(e)), Instant.now()).toSeconds() <= duration) continue;
            Location event = Location.findFromName(this.events_alive.get(e));
            this.removeEvent(event);
        }
    }

    private void createTimer(Location event, long duration, String tooltip) {
        this.newTimerUI(event.getName(), duration, this.itemManager.getImage(event.getItemSpriteId()), tooltip);
    }

    private void deleteTimer(Location event) {
        this.deleteTimerUI(event);
    }

    private void updateTimerImage(Location event, AsyncBufferedImage image) {
        if (this.events_alive.contains(event.getName())) {
            this.deleteTimerUI(event);
            long duration = this.eventDuration(this.events_type.get(event.getName()));
            long new_duration = duration - Duration.between(this.events_starttime.get(event.getName()), Instant.now()).toSeconds();
            if (new_duration <= 0L) {
                return;
            }
            String tooltip = this.generateTooltip(event);
            this.newTimerUI(event.getName(), new_duration, image, tooltip);
        }
    }

    private void updateTimerTooltip(Location event, String tooltip) {
        if (this.events_alive.contains(event.getName())) {
            this.deleteTimerUI(event);
            long duration = this.eventDuration(this.events_type.get(event.getName()));
            long new_duration = duration - Duration.between(this.events_starttime.get(event.getName()), Instant.now()).toSeconds();
            if (new_duration <= 0L) {
                return;
            }
            AsyncBufferedImage image = null;
            image = this.config.expirationWarning() && this.activeRootsExpiringSoon(event.getName()) ? this.itemManager.getImage(1982) : this.itemManager.getImage(event.getItemSpriteId());
            this.newTimerUI(event.getName(), new_duration, image, tooltip);
        }
    }

    private void deleteTimerUI(Location event) {
        this.infoBoxManager.removeIf(t -> t instanceof ForestryccTimer && ((ForestryccTimer)((Object)t)).getEvent().equals(event.getName()));
    }

    private void newTimerUI(String name, long duration, AsyncBufferedImage image, String tooltip) {
        ForestryccTimer timer = new ForestryccTimer(name, duration, (BufferedImage)image, this);
        timer.setTooltip(tooltip);
        this.infoBoxManager.addInfoBox((InfoBox)timer);
    }

    private boolean validEvent(Location event) {
        if (event.getName().equals(Location.NMAGE.getName()) && this.config.enableNmage()) {
            return true;
        }
        if (event.getName().equals(Location.SMAGE.getName()) && this.config.enableSmage()) {
            return true;
        }
        if (event.getName().equals(Location.DRAY.getName()) && this.config.enableDray()) {
            return true;
        }
        if (event.getName().equals(Location.CHURCH.getName()) && this.config.enableChurch()) {
            return true;
        }
        if (event.getName().equals(Location.N_SEERS.getName()) && this.config.enableNSeers()) {
            return true;
        }
        if (event.getName().equals(Location.SEERS.getName()) && this.config.enableSeers()) {
            return true;
        }
        if (event.getName().equals(Location.GLADE.getName()) && this.config.enableGlade()) {
            return true;
        }
        if (event.getName().equals(Location.HIVE.getName()) && this.config.enableBees()) {
            return true;
        }
        if (event.getName().equals(Location.ZALC.getName()) && this.config.enableZalc()) {
            return true;
        }
        if (event.getName().equals(Location.MYTH.getName()) && this.config.enableMyth()) {
            return true;
        }
        if (event.getName().equals(Location.ARC.getName()) && this.config.enableArc()) {
            return true;
        }
        if (event.getName().equals(Location.PRIF.getName()) && this.config.enablePrif()) {
            return true;
        }
        if (event.getName().equals(Location.YAK.getName()) && this.config.enableYak()) {
            return true;
        }
        if (event.getName().equals(Location.GEYEWS.getName()) && this.config.enableGE()) {
            return true;
        }
        if (event.getName().equals(Location.RIMM.getName()) && this.config.enableRimm()) {
            return true;
        }
        if (event.getName().equals(Location.LOOK.getName()) && this.config.enableLookout()) {
            return true;
        }
        if (event.getName().equals(Location.WOOD.getName()) && this.config.enableWoodland()) {
            return true;
        }
        return event.getName().equals(Location.OUTPOST.getName()) && this.config.enableOutpost();
    }

    private String generateTooltip(Location event) {
        return this.formatTooltip(event, this.events_type.get(event.getName()), this.events_confirmed.get(event.getName()));
    }

    private String formatTooltip(Location event, String event_type, Integer confirmations) {
        Object tooltip = event.getName();
        if (event_type != null) {
            tooltip = (String)tooltip + " " + event_type;
        }
        if (confirmations != null && confirmations > 0) {
            tooltip = (String)tooltip + " +" + confirmations;
        }
        return tooltip;
    }

    private long eventDuration(String event_type) {
        long duration = this.event_duration_default;
        if (event_type != null && event_type.equals("BEES")) {
            duration = this.event_duration_bees;
        }
        return duration;
    }

    private void newEvent(Location event, String event_type) {
        this.events_alive.add(event.getName());
        this.events_confirmed.put(event.getName(), 0);
        this.events_starttime.put(event.getName(), Instant.now());
        this.events_type.putIfAbsent(event.getName(), event_type);
        this.deleteTimer(event);
        String tooltip = this.generateTooltip(event);
        long duration = this.eventDuration(event_type);
        this.createTimer(event, duration, tooltip);
    }

    private void reviveEvent(Location event) {
        this.events_alive.add(event.getName());
        Object tooltip = this.generateTooltip(event);
        tooltip = (String)tooltip + " *revived";
        this.updateTimerTooltip(event, (String)tooltip);
    }

    private void confirmEvent(Location event, String event_type) {
        this.events_type.putIfAbsent(event.getName(), event_type);
        Integer confirmations = this.events_confirmed.get(event.getName());
        this.events_confirmed.put(event.getName(), confirmations + 1);
        String tooltip = this.generateTooltip(event);
        this.updateTimerTooltip(event, tooltip);
    }

    private void removeEvent(Location event) {
        this.deleteTimer(event);
        this.events_alive.remove(event.getName());
        this.events_confirmed.remove(event.getName());
        this.events_timeofdeath.put(event.getName(), Instant.now());
        this.events_type.put(event.getName(), null);
    }

    private void Dead(Location event) {
        this.removeEvent(event);
    }

    private void Revive(Location event) {
        if (this.events_alive.contains(event.getName())) {
            return;
        }
        if (Duration.between(this.events_timeofdeath.get(event.getName()), Instant.now()).toSeconds() < this.revive_timeout) {
            this.reviveEvent(event);
        }
    }

    private void Fake(Location event) {
        this.removeEvent(event);
    }

    private void New(Location event, String event_type) {
        if (Duration.between(this.events_timeofdeath.get(event.getName()), Instant.now()).toSeconds() < this.death_timeout) {
            return;
        }
        if (this.validEvent(event)) {
            this.newEvent(event, event_type);
        }
    }

    private void Confirm(Location event, String event_type) {
        if (this.validEvent(event)) {
            this.confirmEvent(event, event_type);
        }
    }

    private void NotifyNew(Location event, String event_type) {
        if (!this.config.idleNotificationEnabled()) {
            return;
        }
        if (this.validEvent(event)) {
            if (event_type == null) {
                this.notifier.notify("New forestry cc event!");
            } else {
                this.notifier.notify("New forestry cc " + event_type.toLowerCase() + " event!");
            }
        }
    }

    private void displayTimer(Location event, String event_type, String msg) {
        if (event.isRevive(msg)) {
            if (this.config.allowRevives()) {
                this.Revive(event);
            }
        } else if (event.isFake(msg)) {
            this.Fake(event);
        } else if (event.isConfirmed(msg)) {
            if (this.events_alive.contains(event.getName()) && this.events_confirmed.containsKey(event.getName())) {
                this.Confirm(event, event_type);
            } else {
                this.New(event, event_type);
                this.NotifyNew(event, event_type);
            }
        } else if (event.isDead(msg)) {
            this.Dead(event);
        } else if (this.events_alive.contains(event.getName()) && this.events_confirmed.containsKey(event.getName())) {
            this.Confirm(event, event_type);
        } else {
            this.New(event, event_type);
            this.NotifyNew(event, event_type);
        }
    }

    @Provides
    ForestryccConfig provideConfig(ConfigManager configManager) {
        return (ForestryccConfig)configManager.getConfig(ForestryccConfig.class);
    }
}

