/*
 * Decompiled with CFR 0.152.
 */
package com.clanactivitytracker;

import com.clanactivitytracker.ClanActivityTrackerConfig;
import com.google.inject.Provides;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.FriendsChatManager;
import net.runelite.api.clan.ClanChannelMember;
import net.runelite.api.clan.ClanSettings;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.ClanChannelChanged;
import net.runelite.api.events.ClanMemberJoined;
import net.runelite.api.events.FriendsChatMemberJoined;
import net.runelite.client.RuneLite;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Clan Activity Tracker", description="Track activity of clan members.")
public class ClanActivityTrackerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ClanActivityTrackerPlugin.class);
    private static final String BASE_DIRECTORY = RuneLite.RUNELITE_DIR + "/clan-activity-tracker/";
    private static final String[] HEADERS = new String[]{"rsn", "rank", "message count", "last message timestamp", "last seen online"};
    @Inject
    private ClanActivityTrackerConfig config;
    @Inject
    private Client client;

    @Provides
    ClanActivityTrackerConfig provideConfig(ConfigManager configManager) {
        return (ClanActivityTrackerConfig)configManager.getConfig(ClanActivityTrackerConfig.class);
    }

    @Subscribe
    public void onClanChannelChanged(ClanChannelChanged event) throws IOException {
        if (this.config.chatTrackType() != ClanActivityTrackerConfig.ChatTrackType.CLAN_CHAT && this.config.chatTrackType() != ClanActivityTrackerConfig.ChatTrackType.BOTH) {
            return;
        }
        if (event.getClanChannel() == null) {
            return;
        }
        if (event.getClanId() != 0) {
            return;
        }
        ClanSettings clanSettings = this.client.getClanSettings();
        if (clanSettings == null) {
            return;
        }
        Object localRsn = "";
        if (this.config.rsnSpecificLog()) {
            localRsn = "_" + Objects.requireNonNull(this.client.getLocalPlayer()).getName();
        }
        String pathname = BASE_DIRECTORY + event.getClanChannel().getName().replaceAll(" ", "_") + (String)localRsn + this.config.fileSuffix();
        this.createFile(pathname);
        Iterable<CSVRecord> records = this.readAll(pathname);
        try {
            String rsn;
            BufferedWriter writer = Files.newBufferedWriter(Paths.get(pathname, new String[0]), StandardOpenOption.WRITE);
            CSVPrinter csvPrinter = new CSVPrinter(writer, CSVFormat.DEFAULT.withHeader(HEADERS));
            List memberList = event.getClanChannel().getMembers();
            ArrayList<String> clanRsns = new ArrayList<String>();
            ArrayList<String> updatedRsns = new ArrayList<String>();
            for (ClanChannelMember member : memberList) {
                clanRsns.add(this.cleanRsn(member.getName()));
            }
            for (CSVRecord record : records) {
                if (record.size() != 5) continue;
                rsn = record.get(0);
                if (clanRsns.contains(rsn)) {
                    int index = clanRsns.indexOf(rsn);
                    csvPrinter.printRecord(rsn, Objects.requireNonNull(clanSettings.titleForRank(((ClanChannelMember)memberList.get(index)).getRank())).getName(), record.get(2), record.get(3), this.formatTimestamp((int)Instant.now().getEpochSecond(), "yyyy-MM-dd HH:mm:ss"));
                    updatedRsns.add(rsn);
                    continue;
                }
                csvPrinter.printRecord(record);
            }
            for (ClanChannelMember member : memberList) {
                rsn = this.cleanRsn(member.getName());
                if (updatedRsns.contains(rsn)) continue;
                csvPrinter.printRecord(this.cleanRsn(member.getName()), Objects.requireNonNull(clanSettings.titleForRank(member.getRank())).getName(), 0, "-", this.formatTimestamp((int)Instant.now().getEpochSecond(), "yyyy-MM-dd HH:mm:ss"));
            }
            csvPrinter.flush();
            csvPrinter.close();
        }
        catch (IOException IOE) {
            log.debug("Clan Activity Tracker encountered an IO exception, likely since the .CSV file was open.");
        }
    }

    @Subscribe
    public void onClanMemberJoined(ClanMemberJoined event) throws IOException {
        if (this.config.chatTrackType() != ClanActivityTrackerConfig.ChatTrackType.CLAN_CHAT && this.config.chatTrackType() != ClanActivityTrackerConfig.ChatTrackType.BOTH) {
            return;
        }
        if (event.getClanChannel() == null) {
            return;
        }
        ClanSettings clanSettings = this.client.getClanSettings();
        if (clanSettings == null) {
            return;
        }
        Object localRsn = "";
        if (this.config.rsnSpecificLog()) {
            localRsn = "_" + Objects.requireNonNull(this.client.getLocalPlayer()).getName();
        }
        String pathname = BASE_DIRECTORY + event.getClanChannel().getName().replaceAll(" ", "_") + (String)localRsn + this.config.fileSuffix();
        this.createFile(pathname);
        Iterable<CSVRecord> records = this.readAll(pathname);
        try {
            BufferedWriter writer = Files.newBufferedWriter(Paths.get(pathname, new String[0]), StandardOpenOption.WRITE);
            CSVPrinter csvPrinter = new CSVPrinter(writer, CSVFormat.DEFAULT.withHeader(HEADERS));
            String rsn = this.cleanRsn(event.getClanMember().getName());
            boolean found = false;
            for (CSVRecord record : records) {
                if (record.size() != 5) continue;
                if (rsn.equals(record.get(0))) {
                    csvPrinter.printRecord(record.get(0), Objects.requireNonNull(clanSettings.titleForRank(event.getClanMember().getRank())).getName(), record.get(2), record.get(3), this.formatTimestamp((int)Instant.now().getEpochSecond(), "yyyy-MM-dd HH:mm:ss"));
                    found = true;
                    continue;
                }
                csvPrinter.printRecord(record);
            }
            if (!found) {
                csvPrinter.printRecord(rsn, Objects.requireNonNull(clanSettings.titleForRank(event.getClanMember().getRank())).getName(), 0, "-", this.formatTimestamp((int)Instant.now().getEpochSecond(), "yyyy-MM-dd HH:mm:ss"));
            }
            csvPrinter.flush();
            csvPrinter.close();
        }
        catch (IOException IOE) {
            log.debug("Clan Activity Tracker encountered an IO exception, likely since the .CSV file was open.");
        }
    }

    @Subscribe
    public void onFriendsChatMemberJoined(FriendsChatMemberJoined event) throws IOException {
        if (this.config.chatTrackType() != ClanActivityTrackerConfig.ChatTrackType.FRIEND_CHAT && this.config.chatTrackType() != ClanActivityTrackerConfig.ChatTrackType.BOTH) {
            return;
        }
        FriendsChatManager friendsChatManager = this.client.getFriendsChatManager();
        if (friendsChatManager == null) {
            return;
        }
        Object localRsn = "";
        if (this.config.rsnSpecificLog()) {
            localRsn = "_" + Objects.requireNonNull(this.client.getLocalPlayer()).getName();
        }
        String pathname = BASE_DIRECTORY + friendsChatManager.getName().replaceAll("\u00a0", "_") + (String)localRsn + this.config.fileSuffix();
        this.createFile(pathname);
        Iterable<CSVRecord> records = this.readAll(pathname);
        try {
            BufferedWriter writer = Files.newBufferedWriter(Paths.get(pathname, new String[0]), StandardOpenOption.WRITE);
            CSVPrinter csvPrinter = new CSVPrinter(writer, CSVFormat.DEFAULT.withHeader(HEADERS));
            String rsn = this.cleanRsn(event.getMember().getName());
            boolean found = false;
            for (CSVRecord record : records) {
                if (record.size() != 5) continue;
                if (rsn.equals(record.get(0))) {
                    csvPrinter.printRecord(record.get(0), event.getMember().getRank(), record.get(2), record.get(3), this.formatTimestamp((int)Instant.now().getEpochSecond(), "yyyy-MM-dd HH:mm:ss"));
                    found = true;
                    continue;
                }
                csvPrinter.printRecord(record);
            }
            if (!found) {
                csvPrinter.printRecord(rsn, event.getMember().getRank(), 0, "-", this.formatTimestamp((int)Instant.now().getEpochSecond(), "yyyy-MM-dd HH:mm:ss"));
            }
            csvPrinter.flush();
            csvPrinter.close();
        }
        catch (IOException IOE) {
            log.debug("Clan Activity Tracker encountered an IO exception, likely since the .CSV file was open.");
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) throws IOException {
        ArrayList<ChatMessageType> chatTypesToTrack = new ArrayList<ChatMessageType>();
        switch (this.config.chatTrackType()) {
            case CLAN_CHAT: {
                chatTypesToTrack.add(ChatMessageType.CLAN_CHAT);
                break;
            }
            case FRIEND_CHAT: {
                chatTypesToTrack.add(ChatMessageType.FRIENDSCHAT);
                break;
            }
            case BOTH: {
                chatTypesToTrack.add(ChatMessageType.CLAN_CHAT);
                chatTypesToTrack.add(ChatMessageType.FRIENDSCHAT);
            }
        }
        if (chatTypesToTrack.contains(chatMessage.getType())) {
            Object localRsn = "";
            if (this.config.rsnSpecificLog()) {
                localRsn = "_" + Objects.requireNonNull(this.client.getLocalPlayer()).getName();
            }
            String pathname = BASE_DIRECTORY + chatMessage.getSender().replaceAll("[ \u00a0]", "_") + (String)localRsn + this.config.fileSuffix();
            this.createFile(pathname);
            String rsn = this.cleanRsn(chatMessage.getName());
            Iterable<CSVRecord> records = this.readAll(pathname);
            try {
                BufferedWriter writer = Files.newBufferedWriter(Paths.get(pathname, new String[0]), StandardOpenOption.WRITE);
                CSVPrinter csvPrinter = new CSVPrinter(writer, CSVFormat.DEFAULT.withHeader(HEADERS));
                for (CSVRecord record : records) {
                    if (record.size() != 5) continue;
                    if (record.get("rsn").equals(rsn)) {
                        int newcount = Integer.parseInt(record.get("message count")) + 1;
                        csvPrinter.printRecord(record.get(0), record.get(1), newcount, this.formatTimestamp(chatMessage.getTimestamp(), "yyyy-MM-dd HH:mm:ss"), record.get(4));
                        continue;
                    }
                    csvPrinter.printRecord(record);
                }
                csvPrinter.flush();
                csvPrinter.close();
            }
            catch (IOException IOE) {
                log.debug("Clan Activity Tracker encountered an IO exception, likely since the .CSV file was open.");
            }
        }
    }

    public Iterable<CSVRecord> readAll(String pathname) throws IOException {
        FileReader in = new FileReader(pathname);
        return CSVFormat.DEFAULT.withHeader(HEADERS).withFirstRecordAsHeader().parse(in);
    }

    public String cleanRsn(String inputString) {
        String cleanString = inputString.replace("\u00a0", " ");
        cleanString = cleanString.replaceAll("(<.+>)", "");
        return cleanString;
    }

    public void createFile(String Pathname) throws IOException {
        block1: {
            File file;
            File basedir = new File(BASE_DIRECTORY);
            if (!basedir.exists()) {
                basedir.mkdir();
            }
            if ((file = new File(Pathname)).exists()) break block1;
            FileWriter outputfile = new FileWriter(file);
            CSVPrinter printer = new CSVPrinter(outputfile, CSVFormat.DEFAULT.withHeader(HEADERS));
            printer.close();
        }
    }

    public String formatTimestamp(int timestamp, String pattern) {
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern(pattern);
        return Instant.ofEpochSecond(timestamp).atZone(ZoneId.of("UTC")).format(dateFormatter);
    }
}

