/*
 * Decompiled with CFR 0.152.
 */
package thestonedturtle.lootlogger.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Collection;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.util.AsyncBufferedImage;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.QuantityFormatter;
import thestonedturtle.lootlogger.data.UniqueItem;

class UniqueItemPanel
extends JPanel {
    final JPanel panel = new JPanel();

    UniqueItemPanel(Collection<UniqueItem> items, ItemManager itemManager, int itemMissingAlpha) {
        this.setLayout(new BorderLayout());
        this.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.setBorder(new EmptyBorder(3, 0, 3, 0));
        this.setPreferredSize(new Dimension(215, 40));
        this.panel.setLayout(new GridBagLayout());
        this.panel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.add((Component)this.panel, "North");
        this.updatePanel(items, itemManager, itemMissingAlpha);
    }

    public void updatePanel(Collection<UniqueItem> items, ItemManager itemManager, int itemMissingAlpha) {
        this.panel.removeAll();
        float alphaMissing = (float)itemMissingAlpha / 100.0f;
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        c.ipady = 5;
        for (UniqueItem l : items) {
            int quantity = l.getQty();
            AsyncBufferedImage image = itemManager.getImage(l.getItemID(), quantity, quantity > 1);
            float alpha = quantity > 0 ? 1.0f : alphaMissing;
            BufferedImage opaque = ImageUtil.alphaOffset((Image)image, (float)alpha);
            JLabel icon = new JLabel();
            icon.setToolTipText(UniqueItemPanel.buildToolTip(l, quantity));
            icon.setIcon(new ImageIcon(opaque));
            icon.setVerticalAlignment(0);
            icon.setHorizontalAlignment(0);
            this.panel.add((Component)icon, c);
            ++c.gridx;
            image.onLoaded(() -> {
                icon.setIcon(new ImageIcon(ImageUtil.alphaOffset((Image)image, (float)alpha)));
                icon.revalidate();
                icon.repaint();
            });
        }
    }

    private static String buildToolTip(UniqueItem item, int qty) {
        String s = "<html>" + item.getName();
        if (qty > 0) {
            s = s + " x " + QuantityFormatter.formatNumber((long)qty);
        }
        if (item.getPrice() > 0) {
            s = s + "<br/>Price: " + QuantityFormatter.quantityToStackSize((long)item.getPrice());
            if (qty > 0) {
                s = s + "<br/>Total: " + QuantityFormatter.quantityToStackSize((long)(qty * item.getPrice())) + "</html";
            }
        }
        s = s + "</html>";
        return s;
    }

    public JPanel getPanel() {
        return this.panel;
    }
}

