/*
 * Decompiled with CFR 0.152.
 */
package thestonedturtle.lootlogger.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.util.QuantityFormatter;

class TextPanel
extends JPanel {
    private static final Color PANEL_BACKGROUND_COLOR = ColorScheme.DARKER_GRAY_COLOR;
    private static final Border PANEL_BORDER = BorderFactory.createMatteBorder(8, 15, 8, 0, PANEL_BACKGROUND_COLOR);
    private final JLabel textLabel = new JLabel("", 2);
    private final JLabel valueLabel = new JLabel("", 2);

    TextPanel() {
        this.setLayout(new BorderLayout());
        this.setBackground(PANEL_BACKGROUND_COLOR);
        this.setBorder(PANEL_BORDER);
        this.textLabel.setForeground(Color.WHITE);
        this.valueLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.add((Component)this.textLabel, "Before");
        this.add((Component)this.valueLabel, "Center");
    }

    public void updatePanel(String text, long totalValue) {
        this.textLabel.setText(text);
        this.valueLabel.setText(QuantityFormatter.quantityToStackSize((long)totalValue) + " gp");
        this.valueLabel.setForeground(TextPanel.getRSValueColor(totalValue));
        this.setToolTipText(QuantityFormatter.formatNumber((long)totalValue));
    }

    public void updatePanel(String text, int value) {
        this.textLabel.setText(text);
        this.valueLabel.setText(QuantityFormatter.formatNumber((long)value));
    }

    private static Color getRSValueColor(long val) {
        return val >= 10000000L ? Color.GREEN : (val >= 100000L ? Color.WHITE : Color.YELLOW);
    }

    public JLabel getTextLabel() {
        return this.textLabel;
    }

    public JLabel getValueLabel() {
        return this.valueLabel;
    }
}

