/*
 * Decompiled with CFR 0.152.
 */
package thestonedturtle.lootlogger.ui;

import com.google.common.base.Strings;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.DynamicGridLayout;
import net.runelite.client.ui.components.IconTextField;
import net.runelite.client.ui.components.materialtabs.MaterialTab;
import net.runelite.client.ui.components.materialtabs.MaterialTabGroup;
import net.runelite.client.util.AsyncBufferedImage;
import net.runelite.client.util.Text;
import net.runelite.http.api.loottracker.LootRecordType;
import org.apache.commons.text.similarity.JaroWinklerDistance;
import thestonedturtle.lootlogger.data.BossTab;
import thestonedturtle.lootlogger.ui.LootLoggerPanel;

class SelectionPanel
extends JPanel {
    private static final Color BACKGROUND_COLOR = ColorScheme.DARK_GRAY_COLOR;
    private static final Color BUTTON_COLOR = ColorScheme.DARKER_GRAY_COLOR;
    private static final Color BUTTON_HOVER_COLOR = ColorScheme.DARKER_GRAY_HOVER_COLOR;
    private static final JaroWinklerDistance DISTANCE = new JaroWinklerDistance();
    private final SetMultimap<LootRecordType, String> names;
    private final LootLoggerPanel parent;
    private final ItemManager itemManager;
    private final IconTextField searchBar = new IconTextField();
    private final JPanel namePanel = new JPanel();
    private boolean configToggle;

    SelectionPanel(boolean configToggle, SetMultimap<LootRecordType, String> names, LootLoggerPanel parent, ItemManager itemManager) {
        this.names = names == null ? HashMultimap.create() : names;
        this.parent = parent;
        this.itemManager = itemManager;
        this.configToggle = configToggle;
        this.setLayout(new GridBagLayout());
        this.setBackground(BACKGROUND_COLOR);
        this.searchBar.setIcon(IconTextField.Icon.SEARCH);
        this.searchBar.setPreferredSize(new Dimension(205, 30));
        this.searchBar.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.searchBar.setHoverBackgroundColor(ColorScheme.DARK_GRAY_HOVER_COLOR);
        this.searchBar.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                SelectionPanel.this.onSearchBarChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SelectionPanel.this.onSearchBarChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                SelectionPanel.this.onSearchBarChanged();
            }
        });
        this.namePanel.setLayout(new GridBagLayout());
        this.createPanel();
    }

    private void createPanel() {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.createNamePanel(LootRecordType.UNKNOWN, "Current Session Data"), c);
        ++c.gridy;
        if (this.configToggle) {
            this.add((Component)this.createBossTabPanel(), c);
            ++c.gridy;
        }
        this.add((Component)this.searchBar, c);
        ++c.gridy;
        this.addNamesToPanel(this.names);
        this.add((Component)this.namePanel, c);
    }

    private JPanel createBossTabPanel() {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(5, 0, 0, 0);
        JPanel container = new JPanel(new GridBagLayout());
        container.setBorder(new EmptyBorder(0, 0, 10, 0));
        for (String categoryName : BossTab.getCategories()) {
            container.add((Component)this.createTabCategory(categoryName), c);
            ++c.gridy;
        }
        return container;
    }

    private void addNamesToPanel(SetMultimap<LootRecordType, String> names) {
        this.namePanel.removeAll();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 0, 4, 0);
        for (LootRecordType type : LootRecordType.values()) {
            JPanel section;
            if (!names.containsKey((Object)type) || (section = this.createCollapseableSection(type, names.get((Object)type))) == null) continue;
            this.namePanel.add((Component)section, c);
            ++c.gridy;
        }
        this.namePanel.revalidate();
    }

    @Nullable
    private JPanel createCollapseableSection(LootRecordType type, Set<String> names) {
        if ((names = names.stream().filter(n -> {
            if (!this.configToggle) {
                return true;
            }
            BossTab b = BossTab.getByName(n);
            return b == null || !b.getType().equals((Object)type);
        }).collect(Collectors.toSet())).size() == 0) {
            return null;
        }
        final JPanel container = new JPanel((LayoutManager)new DynamicGridLayout(0, 1));
        final JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new EmptyBorder(0, 8, 0, 8));
        final JLabel headerLabel = new JLabel(Text.titleCase((Enum)type));
        headerLabel.setToolTipText("Click to toggle this section");
        headerLabel.setHorizontalAlignment(0);
        headerLabel.setBackground(BACKGROUND_COLOR);
        headerLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 0, 2, 0), BorderFactory.createMatteBorder(0, 0, 2, 0, BUTTON_HOVER_COLOR)));
        headerLabel.setOpaque(true);
        headerLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                headerLabel.setBackground(BUTTON_HOVER_COLOR);
                panel.setBackground(BUTTON_HOVER_COLOR);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                headerLabel.setBackground(BACKGROUND_COLOR);
                panel.setBackground(BACKGROUND_COLOR);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                panel.setVisible(!panel.isVisible());
                if (panel.isVisible()) {
                    container.add(panel);
                } else {
                    container.remove(panel);
                }
                container.revalidate();
                container.repaint();
            }
        });
        container.add(headerLabel);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(2, 0, 2, 0);
        for (String name : new TreeSet<String>(names)) {
            panel.add((Component)this.createNamePanel(type, name), c);
            ++c.gridy;
        }
        container.add(panel);
        return container;
    }

    private JPanel createNamePanel(final LootRecordType type, final String name) {
        final JPanel p = new JPanel();
        p.add(new JLabel(name));
        p.setBackground(BUTTON_COLOR);
        p.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                p.setBackground(BUTTON_HOVER_COLOR);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                p.setBackground(BUTTON_COLOR);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                SelectionPanel.this.parent.requestLootLog(type, name);
            }
        });
        return p;
    }

    private JPanel createTabCategory(String categoryName) {
        JPanel container = new JPanel();
        container.setLayout(new GridBagLayout());
        container.setBorder(new EmptyBorder(0, 5, 0, 5));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        MaterialTabGroup thisTabGroup = new MaterialTabGroup();
        thisTabGroup.setLayout((LayoutManager)new GridLayout(0, 4, 7, 7));
        thisTabGroup.setBorder((Border)new EmptyBorder(0, 0, 4, 0));
        JLabel name = new JLabel(categoryName);
        name.setBorder(new EmptyBorder(8, 0, 0, 0));
        name.setForeground(Color.WHITE);
        name.setVerticalAlignment(0);
        Collection<BossTab> categoryTabs = BossTab.getByCategoryName(categoryName);
        for (BossTab tab : categoryTabs) {
            final MaterialTab materialTab = new MaterialTab("", thisTabGroup, null);
            materialTab.setName(tab.getName());
            materialTab.setToolTipText(tab.getName());
            materialTab.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    materialTab.setBackground(BUTTON_HOVER_COLOR);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    materialTab.setBackground(BUTTON_COLOR);
                }
            });
            materialTab.setOnSelectEvent(() -> {
                this.parent.requestLootLog(tab.getType(), tab.getName());
                return true;
            });
            AsyncBufferedImage image = this.itemManager.getImage(tab.getItemID());
            Runnable resize = () -> {
                materialTab.setIcon((Icon)new ImageIcon(image.getScaledInstance(35, 35, 4)));
                materialTab.setOpaque(true);
                materialTab.setBackground(BUTTON_COLOR);
                materialTab.setHorizontalAlignment(0);
                materialTab.setVerticalAlignment(0);
                materialTab.setPreferredSize(new Dimension(35, 35));
            };
            image.onLoaded(resize);
            resize.run();
            thisTabGroup.addTab(materialTab);
        }
        container.add((Component)name, c);
        ++c.gridy;
        container.add((Component)thisTabGroup, c);
        return container;
    }

    private void onSearchBarChanged() {
        String text = this.searchBar.getText();
        if (Strings.isNullOrEmpty((String)text)) {
            this.addNamesToPanel(this.names);
        } else {
            this.addNamesToPanel(this.filterNames(this.names, text));
        }
    }

    private SetMultimap<LootRecordType, String> filterNames(SetMultimap<LootRecordType, String> nameMap, String searchText) {
        String[] searchTerms = searchText.toLowerCase().split(" ");
        return (SetMultimap)nameMap.entries().stream().filter(entry -> SelectionPanel.matchesSearchTerm((String)entry.getValue(), searchTerms)).collect(Multimaps.toMultimap(Map.Entry::getKey, Map.Entry::getValue, HashMultimap::create));
    }

    private static boolean matchesSearchTerm(String name, String[] terms) {
        for (String term : terms) {
            if (!Arrays.stream(name.toLowerCase().split(" ")).noneMatch(nameTerm -> nameTerm.contains(term) || DISTANCE.apply((CharSequence)nameTerm, (CharSequence)term) > 0.9)) continue;
            return false;
        }
        return true;
    }

    public JPanel getNamePanel() {
        return this.namePanel;
    }
}

