/*
 * Decompiled with CFR 0.152.
 */
package thestonedturtle.lootlogger.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.function.BiConsumer;
import javax.swing.BoxLayout;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.http.api.loottracker.LootRecordType;
import thestonedturtle.lootlogger.data.LootLog;
import thestonedturtle.lootlogger.localstorage.LTItemEntry;
import thestonedturtle.lootlogger.ui.LootGrid;
import thestonedturtle.lootlogger.ui.LootGridName;

public class NamedLootGrid
extends JPanel {
    private boolean isCollapsed = false;
    private final LootGridName namePanel;
    private final LootGrid grid;
    private long price;

    NamedLootGrid(String name, int count, long price, LootGrid grid, LootRecordType type, BiConsumer<LootRecordType, String> clearData) {
        this.grid = grid;
        this.price = price;
        this.setLayout(new BoxLayout(this, 1));
        this.setBackground(ColorScheme.DARKER_GRAY_COLOR.darker());
        this.namePanel = new LootGridName(name, count, price);
        JPopupMenu menu = new JPopupMenu();
        JMenuItem delete = new JMenuItem("Clear stored data");
        delete.addActionListener(ev -> clearData.accept(type, name));
        menu.add(delete);
        this.namePanel.setComponentPopupMenu(menu);
        this.namePanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    return;
                }
                NamedLootGrid.this.changeCollapse();
            }
        });
        this.add(this.namePanel);
        this.add(grid);
    }

    void updateGrid(LootLog log, LTItemEntry[] itemsToDisplay, ItemManager itemManager) {
        this.price = log.getLootValue(false);
        this.namePanel.updateLabel(log.getName(), log.getRecords().size(), this.price);
        this.grid.updateGrid(itemsToDisplay, itemManager);
        if (this.isCollapsed) {
            this.changeCollapse();
        }
    }

    void changeCollapse() {
        this.isCollapsed = !this.isCollapsed;
        this.grid.setVisible(!this.isCollapsed);
        for (Component component : this.namePanel.getComponents()) {
            Color color = component.getForeground();
            component.setForeground(this.isCollapsed ? color.darker() : color.brighter());
        }
    }

    public long getPrice() {
        return this.price;
    }
}

