/*
 * Decompiled with CFR 0.152.
 */
package thestonedturtle.lootlogger.ui;

import com.google.common.collect.ImmutableList;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.http.api.loottracker.LootRecordType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thestonedturtle.lootlogger.ItemSortTypes;
import thestonedturtle.lootlogger.LootLoggerConfig;
import thestonedturtle.lootlogger.UniqueItemPlacement;
import thestonedturtle.lootlogger.data.LootLog;
import thestonedturtle.lootlogger.localstorage.LTItemEntry;
import thestonedturtle.lootlogger.localstorage.LTRecord;
import thestonedturtle.lootlogger.ui.LootGrid;
import thestonedturtle.lootlogger.ui.NamedLootGrid;
import thestonedturtle.lootlogger.ui.TextPanel;
import thestonedturtle.lootlogger.ui.UniqueItemPanel;

class LootPanel
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(LootPanel.class);
    private static final String CURRENT_KC = "Current Killcount:";
    private static final String KILLS_LOGGED = "Kills Logged:";
    private static final String TOTAL_VALUE = "Total Value:";
    private static final String TOTAL_KILLS = "Total Kills:";
    private final LootLog lootLog;
    private final LootLoggerConfig config;
    private final ItemManager itemManager;
    private boolean playbackPlaying = false;
    private boolean cancelPlayback = false;
    private final BiConsumer<LootRecordType, String> clearData;
    private final LootGrid lootGrid = new LootGrid();
    private final TextPanel currentKillcountPanel = new TextPanel();
    private final TextPanel killsLoggedPanel = new TextPanel();
    private final TextPanel totalValuePanel = new TextPanel();
    private final Map<String, NamedLootGrid> minionGridMap = new HashMap<String, NamedLootGrid>();
    private final Map<Integer, UniqueItemPanel> uniqueItemPanelMap = new HashMap<Integer, UniqueItemPanel>();
    private final GridBagConstraints gridBagConstraints = new GridBagConstraints();

    LootPanel(LootLog log, LootLoggerConfig config, ItemManager itemManager, BiConsumer<LootRecordType, String> clearData) {
        this.lootLog = log;
        this.config = config;
        this.itemManager = itemManager;
        this.clearData = clearData;
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(0, 10, 5, 10));
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.gridBagConstraints.fill = 2;
        this.gridBagConstraints.weightx = 1.0;
        this.gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.gridBagConstraints.gridx = 0;
        this.gridBagConstraints.gridy = 0;
        this.createPanel(log);
    }

    private void createPanel(LootLog lootLog) {
        this.currentKillcountPanel.setVisible(false);
        this.killsLoggedPanel.setVisible(false);
        this.totalValuePanel.setVisible(false);
        this.lootGrid.setVisible(false);
        this.minionGridMap.clear();
        this.uniqueItemPanelMap.clear();
        this.removeAll();
        this.gridBagConstraints.gridy = 0;
        if (!this.config.uniquesPlacement().equals((Object)UniqueItemPlacement.ITEM_BREAKDOWN)) {
            LootLog.recalculateUniques(lootLog, this.config.includeMinions());
            Iterator iterator = lootLog.getUniquePositionMap().keySet().iterator();
            while (iterator.hasNext()) {
                int position = (Integer)iterator.next();
                Collection uniques = lootLog.getUniquePositionMap().get((Object)position);
                UniqueItemPanel p = new UniqueItemPanel(uniques, this.itemManager, this.config.itemMissingAlpha());
                this.uniqueItemPanelMap.put(position, p);
                this.add((Component)p, this.gridBagConstraints);
                ++this.gridBagConstraints.gridy;
            }
        }
        this.add((Component)this.currentKillcountPanel, this.gridBagConstraints);
        ++this.gridBagConstraints.gridy;
        this.add((Component)this.killsLoggedPanel, this.gridBagConstraints);
        ++this.gridBagConstraints.gridy;
        this.add((Component)this.totalValuePanel, this.gridBagConstraints);
        ++this.gridBagConstraints.gridy;
        this.add((Component)this.lootGrid, this.gridBagConstraints);
        ++this.gridBagConstraints.gridy;
        int killsLogged = lootLog.getRecords().size();
        if (killsLogged > 0) {
            this.killsLoggedPanel.updatePanel(KILLS_LOGGED, lootLog.getRecords().size());
            this.killsLoggedPanel.setVisible(true);
            LTRecord entry = lootLog.getRecords().get(lootLog.getRecords().size() - 1);
            if (entry.getKillCount() != -1) {
                this.currentKillcountPanel.updatePanel(CURRENT_KC, entry.getKillCount());
                this.currentKillcountPanel.setVisible(true);
            }
        }
        this.updateMainLootGrid(lootLog);
        long totalValue = lootLog.getLootValue(false);
        if (this.config.includeMinions()) {
            for (LootLog log : lootLog.getMinionLogs()) {
                if (log.getRecords().size() == 0) continue;
                killsLogged += log.getRecords().size();
                NamedLootGrid namedGrid = this.createMinionGrid(log);
                this.minionGridMap.put(log.getName().toLowerCase(), namedGrid);
                this.add((Component)namedGrid, this.gridBagConstraints);
                ++this.gridBagConstraints.gridy;
                totalValue += namedGrid.getPrice();
            }
        }
        if (totalValue > 0L) {
            this.totalValuePanel.updatePanel(TOTAL_VALUE, totalValue);
            this.totalValuePanel.setVisible(true);
        }
        if (lootLog.getName().equalsIgnoreCase("Current Session Data")) {
            this.killsLoggedPanel.updatePanel(TOTAL_KILLS, killsLogged);
            this.killsLoggedPanel.setVisible(killsLogged > 0);
        }
    }

    private LTItemEntry[] getItemsToDisplay(LootLog log) {
        boolean hideUniques = this.config.uniquesPlacement().equals((Object)UniqueItemPlacement.UNIQUES_PANEL);
        return (LTItemEntry[])log.getConsolidated().values().stream().filter(e -> !hideUniques || !this.lootLog.getUniqueIds().contains(e.getId())).sorted(LootPanel.createLTItemEntryComparator(this.config.itemSortType())).toArray(LTItemEntry[]::new);
    }

    private void updateMainLootGrid(LootLog lootLog) {
        LTItemEntry[] itemsToDisplay = this.getItemsToDisplay(lootLog);
        if (itemsToDisplay.length > 0) {
            this.lootGrid.updateGrid(itemsToDisplay, this.itemManager);
            this.lootGrid.setVisible(true);
        }
    }

    private NamedLootGrid createMinionGrid(LootLog log) {
        LTItemEntry[] itemsToDisplay = this.getItemsToDisplay(log);
        LootGrid grid = new LootGrid(itemsToDisplay, this.itemManager);
        long logValue = log.getLootValue(false);
        return new NamedLootGrid(log.getName(), log.getRecords().size(), logValue, grid, log.getType(), this.clearData);
    }

    private void updateMinionLog(LootLog log) {
        NamedLootGrid grid = this.minionGridMap.get(log.getName().toLowerCase());
        if (grid == null) {
            return;
        }
        LTItemEntry[] itemsToDisplay = this.getItemsToDisplay(log);
        grid.updateGrid(log, itemsToDisplay, this.itemManager);
    }

    void addedRecord(LTRecord record) {
        this.lootLog.addRecord(record);
        if (!this.playbackPlaying) {
            this.refreshPanel(this.lootLog, false);
        }
    }

    void addMinionRecord(LTRecord record) {
        LootLog minionLog = this.lootLog.getMinionLog(record.getName());
        if (minionLog == null) {
            LootLog newMinionLog = new LootLog((Collection<LTRecord>)ImmutableList.of((Object)record), record.getName());
            this.lootLog.getMinionLogs().add(newMinionLog);
            NamedLootGrid grid = this.createMinionGrid(newMinionLog);
            this.minionGridMap.put(newMinionLog.getName().toLowerCase(), grid);
            this.add((Component)grid, this.gridBagConstraints);
            ++this.gridBagConstraints.gridy;
            if (!this.playbackPlaying) {
                this.refreshPanel(this.lootLog, true);
            }
            return;
        }
        minionLog.addRecord(record);
        this.updateMinionLog(minionLog);
        if (!this.playbackPlaying) {
            this.refreshPanel(this.lootLog, true);
        }
    }

    public void refreshPanel(LootLog lootLog, boolean minionUpdate) {
        LootLog.recalculateUniques(lootLog, this.config.includeMinions());
        for (Map.Entry<Integer, UniqueItemPanel> entry : this.uniqueItemPanelMap.entrySet()) {
            Collection uniques = lootLog.getUniquePositionMap().get((Object)entry.getKey());
            entry.getValue().updatePanel(uniques, this.itemManager, this.config.itemMissingAlpha());
        }
        if (!minionUpdate) {
            this.updateMainLootGrid(lootLog);
            if (lootLog.getRecords().size() > 0) {
                LTRecord entry = lootLog.getRecords().get(lootLog.getRecords().size() - 1);
                this.currentKillcountPanel.updatePanel(CURRENT_KC, entry.getKillCount());
                this.currentKillcountPanel.setVisible(entry.getKillCount() != -1);
            }
        }
        long totalValue = lootLog.getLootValue(this.config.includeMinions());
        this.totalValuePanel.updatePanel(TOTAL_VALUE, totalValue);
        this.totalValuePanel.setVisible(totalValue > 0L);
        int killsLogged = lootLog.getRecords().size();
        if (lootLog.getName().equalsIgnoreCase("Current Session Data")) {
            killsLogged += lootLog.getMinionLogs().stream().mapToInt(l -> l.getRecords().size()).sum();
        }
        String killsLoggedText = lootLog.getName().equalsIgnoreCase("Current Session Data") ? TOTAL_KILLS : KILLS_LOGGED;
        this.killsLoggedPanel.updatePanel(killsLoggedText, killsLogged);
        this.killsLoggedPanel.setVisible(killsLogged > 0);
    }

    void playback() {
        if (this.playbackPlaying) {
            this.cancelPlayback = true;
            return;
        }
        this.playbackPlaying = true;
        if (this.lootLog.getRecords().size() > 0) {
            LootLog tempLog = new LootLog(new ArrayList<LTRecord>(), this.lootLog.getName());
            for (LTRecord r : this.lootLog.getRecords()) {
                tempLog.addRecord(r);
                if (tempLog.getRecords().size() == 1) {
                    SwingUtilities.invokeLater(() -> this.createPanel(tempLog));
                } else if (tempLog.getRecords().size() == this.lootLog.getRecords().size()) {
                    this.cancelPlayback = true;
                } else {
                    SwingUtilities.invokeLater(() -> this.refreshPanel(tempLog, false));
                }
                try {
                    if (this.cancelPlayback) {
                        this.playbackPlaying = false;
                        this.cancelPlayback = false;
                        SwingUtilities.invokeLater(() -> this.createPanel(this.lootLog));
                        break;
                    }
                    Thread.sleep(250L);
                }
                catch (InterruptedException e) {
                    log.warn(e.getMessage());
                }
            }
        }
        this.playbackPlaying = false;
    }

    private static Comparator<LTItemEntry> createLTItemEntryComparator(ItemSortTypes sortType) {
        return (o1, o2) -> {
            switch (sortType) {
                case ITEM_ID: {
                    return o1.getId() - o2.getId();
                }
                case PRICE: {
                    if (o1.getPrice() == o2.getPrice()) break;
                    return o1.getPrice() > o2.getPrice() ? -1 : 1;
                }
                case VALUE: {
                    if (o1.getTotal() == o2.getTotal()) break;
                    return o1.getTotal() > o2.getTotal() ? -1 : 1;
                }
                case ALPHABETICAL: {
                    break;
                }
                default: {
                    log.warn("Sort Type not being handled correctly, defaulting to alphabetical.");
                }
            }
            return o1.getName().compareTo(o2.getName());
        };
    }

    public Map<String, NamedLootGrid> getMinionGridMap() {
        return this.minionGridMap;
    }
}

