/*
 * Decompiled with CFR 0.152.
 */
package thestonedturtle.lootlogger.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.components.PluginErrorPanel;
import net.runelite.client.util.ImageUtil;
import net.runelite.http.api.loottracker.LootRecordType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thestonedturtle.lootlogger.LootLoggerPlugin;
import thestonedturtle.lootlogger.data.BossTab;
import thestonedturtle.lootlogger.data.LootLog;
import thestonedturtle.lootlogger.localstorage.LTRecord;
import thestonedturtle.lootlogger.ui.LootPanel;
import thestonedturtle.lootlogger.ui.SelectionPanel;

public class LootLoggerPanel
extends PluginPanel {
    private static final Logger log = LoggerFactory.getLogger(LootLoggerPanel.class);
    private static final BufferedImage ICON_DELETE;
    private static final BufferedImage ICON_REFRESH;
    private static final BufferedImage ICON_BACK;
    private static final BufferedImage ICON_REPLAY;
    private static final Color BACKGROUND_COLOR;
    private static final Color BUTTON_HOVER_COLOR;
    private final ItemManager itemManager;
    private final LootLoggerPlugin plugin;
    private LootPanel lootPanel;
    private LootLog lootLog;
    private SelectionPanel selectionPanel;

    public LootLoggerPanel(ItemManager itemManager, LootLoggerPlugin plugin) {
        super(false);
        this.itemManager = itemManager;
        this.plugin = plugin;
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.setLayout(new BorderLayout());
        this.showSelectionView();
    }

    public void useLog(LootLog log) {
        this.lootLog = log;
        this.showLootView();
    }

    public void requestLootLog(LootRecordType type, String name) {
        if (this.selectionPanel != null) {
            this.selectionPanel.getNamePanel().removeAll();
        }
        this.plugin.requestLootLog(type, name);
    }

    public void showSelectionView() {
        this.removeAll();
        this.lootLog = null;
        this.lootPanel = null;
        PluginErrorPanel errorPanel = new PluginErrorPanel();
        errorPanel.setBorder((Border)new EmptyBorder(10, 25, 10, 25));
        errorPanel.setContent("Loot Logger", "Select the Activity, Player, or NPC you wish to view loot for");
        this.selectionPanel = new SelectionPanel(this.plugin.config.bossButtons(), this.plugin.getLootNames(), this, this.itemManager);
        this.add((Component)errorPanel, "North");
        this.add(this.wrapContainer(this.selectionPanel), "Center");
        this.revalidate();
        this.repaint();
    }

    public void showLootView() {
        this.removeAll();
        this.selectionPanel = null;
        JPanel title = this.createLootViewTitle();
        this.lootPanel = new LootPanel(this.lootLog, this.plugin.config, this.itemManager, (lootRecordType, name) -> {
            if (this.clearData((LootRecordType)lootRecordType, (String)name)) {
                this.requestLootLog((LootRecordType)lootRecordType, this.lootLog.getName());
            }
        });
        this.add(title, "North");
        this.add(this.wrapContainer(this.lootPanel), "Center");
        this.revalidate();
        this.repaint();
    }

    private JPanel createLootViewTitle() {
        final String name = this.lootLog.getName();
        JPanel title = new JPanel();
        title.setBorder(new CompoundBorder(new EmptyBorder(10, 8, 8, 8), new MatteBorder(0, 0, 1, 0, Color.GRAY)));
        title.setLayout(new BorderLayout());
        title.setBackground(BACKGROUND_COLOR);
        JPanel first = new JPanel();
        first.setBackground(BACKGROUND_COLOR);
        JLabel back = this.createIconLabel(ICON_BACK);
        back.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                LootLoggerPanel.this.showSelectionView();
            }
        });
        back.setToolTipText("Back to selection screen");
        JLabel text = new JLabel(name);
        text.setForeground(Color.WHITE);
        first.add(back);
        first.add(text);
        JPanel second = new JPanel();
        second.setBackground(BACKGROUND_COLOR);
        JLabel refresh = this.createIconLabel(ICON_REFRESH);
        refresh.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                LootLoggerPanel.this.requestLootLog(LootLoggerPanel.this.lootLog.getType(), name);
            }
        });
        refresh.setToolTipText("Refresh panel");
        JLabel clear = this.createIconLabel(ICON_DELETE);
        clear.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (LootLoggerPanel.this.clearData(LootLoggerPanel.this.lootLog.getType(), name)) {
                    LootLoggerPanel.this.showSelectionView();
                }
            }
        });
        clear.setToolTipText("Clear stored data");
        JLabel replay = this.createIconLabel(ICON_REPLAY);
        replay.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                LootLoggerPanel.this.playbackLoot();
            }
        });
        replay.setToolTipText("Replay Loot");
        second.add(refresh);
        second.add(clear);
        second.add(replay);
        title.add((Component)first, "West");
        title.add((Component)second, "East");
        return title;
    }

    private JLabel createIconLabel(BufferedImage icon) {
        final JLabel label = new JLabel();
        label.setIcon(new ImageIcon(icon));
        label.setOpaque(true);
        label.setBackground(BACKGROUND_COLOR);
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                label.setBackground(BUTTON_HOVER_COLOR);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                label.setBackground(BACKGROUND_COLOR);
            }
        });
        return label;
    }

    private JScrollPane wrapContainer(JPanel container) {
        JPanel wrapped = new JPanel(new BorderLayout());
        wrapped.add((Component)container, "North");
        wrapped.setBackground(BACKGROUND_COLOR);
        JScrollPane scroller = new JScrollPane(wrapped);
        scroller.setHorizontalScrollBarPolicy(31);
        scroller.getVerticalScrollBar().setPreferredSize(new Dimension(8, 0));
        scroller.setBackground(BACKGROUND_COLOR);
        return scroller;
    }

    private boolean clearData(LootRecordType type, String name) {
        int delete = JOptionPane.showConfirmDialog(this.getRootPane(), "<html>Are you sure you want to clear all data for this tab?<br/>There is no way to undo this action.</html>", "Warning", 0);
        if (delete == 0) {
            boolean deletedAtleastOne = this.plugin.clearStoredDataByName(type, name);
            BossTab tab = BossTab.getByName(name);
            if (tab != null) {
                for (String alias : tab.getAliases()) {
                    deletedAtleastOne |= this.plugin.clearStoredDataByName(type, alias);
                }
            }
            if (!deletedAtleastOne) {
                JOptionPane.showMessageDialog(this.getRootPane(), "Unable to clear stored data, please try again.");
                return false;
            }
            return true;
        }
        return false;
    }

    public void addLog(LTRecord r) {
        BossTab tab = BossTab.getByName(r.getName());
        if (this.lootLog == null) {
            this.requestLootLog(r.getType(), tab == null ? r.getName() : tab.getName());
        } else if (this.lootLog.getName().equalsIgnoreCase(r.getName()) || tab != null && this.lootLog.getName().equalsIgnoreCase(tab.getName())) {
            this.lootPanel.addedRecord(r);
        } else if (this.lootLog.getName().equalsIgnoreCase("Current Session Data") || this.lootPanel.getMinionGridMap().containsKey(r.getName().toLowerCase()) || tab != null && tab.getMinions().contains(r.getName().toLowerCase())) {
            this.lootPanel.addMinionRecord(r);
        }
    }

    public void refreshUI() {
        log.debug("Refreshing UI");
        if (this.lootLog == null) {
            this.showSelectionView();
        } else {
            this.showLootView();
        }
    }

    private void playbackLoot() {
        if (this.lootPanel == null) {
            return;
        }
        ScheduledExecutorService ex = Executors.newSingleThreadScheduledExecutor();
        if (this.lootLog != null) {
            ex.schedule(this.lootPanel::playback, 0L, TimeUnit.SECONDS);
        }
    }

    public LootLog getLootLog() {
        return this.lootLog;
    }

    static {
        BACKGROUND_COLOR = ColorScheme.DARK_GRAY_COLOR;
        BUTTON_HOVER_COLOR = ColorScheme.DARKER_GRAY_HOVER_COLOR;
        ICON_DELETE = ImageUtil.loadImageResource(LootLoggerPlugin.class, (String)"delete-white.png");
        ICON_REFRESH = ImageUtil.loadImageResource(LootLoggerPlugin.class, (String)"refresh-white.png");
        ICON_BACK = ImageUtil.loadImageResource(LootLoggerPlugin.class, (String)"back-arrow-white.png");
        ICON_REPLAY = ImageUtil.loadImageResource(LootLoggerPlugin.class, (String)"replay-white.png");
    }
}

