/*
 * Decompiled with CFR 0.152.
 */
package thestonedturtle.lootlogger.ui;

import java.awt.Color;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.util.QuantityFormatter;

public class LootGridName
extends JPanel {
    private static final int TITLE_PADDING = 5;
    private static final Border VISIBLE_BORDER = new EmptyBorder(7, 7, 7, 7);
    private final JLabel titleLabel = new JLabel();
    private final JLabel priceLabel = new JLabel();

    LootGridName(String name, int count, long price) {
        this.setLayout(new BoxLayout(this, 0));
        this.setBackground(ColorScheme.DARKER_GRAY_COLOR.darker());
        this.setBorder(VISIBLE_BORDER);
        this.titleLabel.setFont(FontManager.getRunescapeSmallFont());
        this.titleLabel.setForeground(Color.WHITE);
        this.titleLabel.setMinimumSize(new Dimension(1, this.titleLabel.getPreferredSize().height));
        this.add(this.titleLabel);
        this.add(Box.createHorizontalGlue());
        this.add(Box.createRigidArea(new Dimension(5, 0)));
        this.priceLabel.setFont(FontManager.getRunescapeSmallFont());
        this.priceLabel.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
        this.add(this.priceLabel);
        this.updateLabel(name, count, price);
    }

    void updateLabel(String name, int count, long price) {
        this.titleLabel.setText(name + " x " + count);
        this.priceLabel.setText(QuantityFormatter.quantityToStackSize((long)price) + " gp");
        this.priceLabel.setToolTipText(QuantityFormatter.formatNumber((long)price) + " gp");
    }
}

