/*
 * Decompiled with CFR 0.152.
 */
package thestonedturtle.lootlogger.ui;

import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.util.QuantityFormatter;
import thestonedturtle.lootlogger.localstorage.LTItemEntry;

class LootGrid
extends JPanel {
    private static final int ITEMS_PER_ROW = 5;
    private static final Dimension ITEM_SIZE = new Dimension(40, 40);

    LootGrid() {
    }

    LootGrid(LTItemEntry[] itemsToDisplay, ItemManager itemManager) {
        this.updateGrid(itemsToDisplay, itemManager);
    }

    public void updateGrid(LTItemEntry[] itemsToDisplay, ItemManager itemManager) {
        this.removeAll();
        int rowSize = (itemsToDisplay.length % 5 == 0 ? 0 : 1) + itemsToDisplay.length / 5;
        this.setLayout(new GridLayout(rowSize, 5, 1, 1));
        for (int i = 0; i < rowSize * 5; ++i) {
            JPanel slot = new JPanel();
            slot.setLayout(new GridLayout(1, 1, 0, 0));
            slot.setBackground(ColorScheme.DARKER_GRAY_COLOR);
            slot.setPreferredSize(ITEM_SIZE);
            if (i < itemsToDisplay.length) {
                LTItemEntry item = itemsToDisplay[i];
                if (item == null) continue;
                JLabel itemLabel = new JLabel();
                itemLabel.setToolTipText(LootGrid.buildToolTip(item));
                itemLabel.setVerticalAlignment(0);
                itemLabel.setHorizontalAlignment(0);
                itemManager.getImage(item.getId(), item.getQuantity(), item.getQuantity() > 1).addTo(itemLabel);
                slot.add(itemLabel);
            }
            this.add(slot);
        }
        this.repaint();
    }

    private static String buildToolTip(LTItemEntry item) {
        String name = item.getName();
        int quantity = item.getQuantity();
        long price = item.getPrice();
        return "<html>" + name + " x " + QuantityFormatter.formatNumber((long)quantity) + "<br/>Price: " + QuantityFormatter.quantityToStackSize((long)price) + "<br/>Total: " + QuantityFormatter.quantityToStackSize((long)((long)quantity * price)) + "</html>";
    }
}

