/*
 * Decompiled with CFR 0.152.
 */
package thestonedturtle.lootlogger.localstorage;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.client.RuneLite;
import net.runelite.http.api.RuneLiteAPI;
import net.runelite.http.api.loottracker.LootRecordType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thestonedturtle.lootlogger.localstorage.LTRecord;
import thestonedturtle.lootlogger.localstorage.LootRecordDateAdapter;

@Singleton
public class LootRecordWriter {
    private static final Logger log = LoggerFactory.getLogger(LootRecordWriter.class);
    private static final String FILE_EXTENSION = ".log";
    private static final File LOOT_RECORD_DIR = new File(RuneLite.RUNELITE_DIR, "loots");
    private File playerFolder = LOOT_RECORD_DIR;
    private final Map<LootRecordType, File> eventFolders = new HashMap<LootRecordType, File>();
    private String name;
    private final Gson CUSTOM_GSON = RuneLiteAPI.GSON.newBuilder().registerTypeAdapter(Date.class, (Object)new LootRecordDateAdapter()).create();

    @Inject
    public LootRecordWriter() {
        LOOT_RECORD_DIR.mkdir();
    }

    public boolean setPlayerUsername(String username) {
        if (username.equalsIgnoreCase(this.name)) {
            return false;
        }
        this.playerFolder = new File(LOOT_RECORD_DIR, username);
        this.playerFolder.mkdir();
        this.name = username;
        this.createSubFolders();
        return true;
    }

    private void createSubFolders() {
        this.eventFolders.clear();
        for (LootRecordType type : LootRecordType.values()) {
            File folder = new File(this.playerFolder, type.name().toLowerCase());
            folder.mkdir();
            this.eventFolders.put(type, folder);
        }
    }

    private static String npcNameToFileName(String npcName) {
        return npcName.toLowerCase().trim() + FILE_EXTENSION;
    }

    public SetMultimap<LootRecordType, String> getKnownFileNames() {
        HashMultimap fileNames = HashMultimap.create();
        for (Map.Entry<LootRecordType, File> entry : this.eventFolders.entrySet()) {
            File[] files = entry.getValue().listFiles((dir, name) -> name.endsWith(FILE_EXTENSION));
            if (files == null) continue;
            for (File f : files) {
                fileNames.put((Object)entry.getKey(), (Object)f.getName().replace(FILE_EXTENSION, ""));
            }
        }
        return fileNames;
    }

    public synchronized Collection<LTRecord> loadLootTrackerRecords(LootRecordType recordType, String npcName) {
        String fileName = LootRecordWriter.npcNameToFileName(npcName);
        File file = new File(this.eventFolders.get(recordType), fileName);
        ArrayList<LTRecord> data = new ArrayList<LTRecord>();
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = br.readLine()) != null) {
                if (line.length() <= 0) continue;
                LTRecord r = (LTRecord)this.CUSTOM_GSON.fromJson(line, LTRecord.class);
                data.add(r);
            }
        }
        catch (FileNotFoundException e) {
            log.debug("File not found: {}", (Object)fileName);
        }
        catch (IOException e) {
            log.warn("IOException for file {}: {}", (Object)fileName, (Object)e.getMessage());
        }
        return data;
    }

    public synchronized boolean addLootTrackerRecord(LTRecord rec) {
        String fileName = LootRecordWriter.npcNameToFileName(rec.getName());
        File lootFile = new File(this.eventFolders.get(rec.getType()), fileName);
        String dataAsString = this.CUSTOM_GSON.toJson((Object)rec);
        try {
            BufferedWriter file = new BufferedWriter(new FileWriter(String.valueOf(lootFile), true));
            file.append(dataAsString);
            file.newLine();
            file.close();
            return true;
        }
        catch (IOException ioe) {
            log.warn("Error writing loot data to file {}: {}", (Object)fileName, (Object)ioe.getMessage());
            return false;
        }
    }

    public synchronized boolean deleteLootTrackerRecords(LootRecordType type, String npcName) {
        String fileName = LootRecordWriter.npcNameToFileName(npcName);
        File lootFile = new File(this.eventFolders.get(type), fileName);
        if (lootFile.delete()) {
            log.debug("Deleted loot file: {}", (Object)fileName);
            return true;
        }
        log.debug("Couldn't delete file: {}", (Object)fileName);
        return false;
    }

    public synchronized boolean writeLootTrackerFile(String npcName, Collection<LTRecord> loots) {
        String fileName = LootRecordWriter.npcNameToFileName(npcName);
        File lootFile = new File(this.playerFolder, fileName);
        try {
            BufferedWriter file = new BufferedWriter(new FileWriter(String.valueOf(lootFile), false));
            for (LTRecord rec : loots) {
                String dataAsString = this.CUSTOM_GSON.toJson((Object)rec);
                file.append(dataAsString);
                file.newLine();
            }
            file.close();
            return true;
        }
        catch (IOException ioe) {
            log.warn("Error rewriting loot data to file {}: {}", (Object)fileName, (Object)ioe.getMessage());
            return false;
        }
    }

    public synchronized boolean renameUsernameFolderToAccountHash(String username, long hash) {
        File usernameDir = new File(LOOT_RECORD_DIR, username);
        if (!usernameDir.exists()) {
            log.debug("Already rewritten");
            return true;
        }
        File hashDir = new File(LOOT_RECORD_DIR, String.valueOf(hash));
        if (hashDir.exists()) {
            log.warn("Can't rename username folder to account hash as the folder for this account hash already exists. This was most likely caused by running RL through the Jagex launcher before the migration code was added");
            log.warn("Username: {} | AccountHash: {}", (Object)username, (Object)hash);
            return false;
        }
        return usernameDir.renameTo(hashDir);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }
}

