/*
 * Decompiled with CFR 0.152.
 */
package thestonedturtle.lootlogger.localstorage;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LootRecordDateAdapter
extends TypeAdapter<Date> {
    private static final Logger log = LoggerFactory.getLogger(LootRecordDateAdapter.class);
    private final SimpleDateFormat SPACE_FORMAT = new SimpleDateFormat("MMM d, yyyy, h:mm:ss aaa");
    private final SimpleDateFormat UNICODE_FORMAT = new SimpleDateFormat("MMM d, yyyy, h:mm:ss\u202faaa");

    public void write(JsonWriter out, Date value) throws IOException {
        if (value == null) {
            out.nullValue();
            return;
        }
        out.value(this.SPACE_FORMAT.format(value));
    }

    public Date read(JsonReader reader) throws IOException {
        if (reader.peek() == JsonToken.NULL) {
            reader.nextNull();
            return null;
        }
        String date = reader.nextString();
        try {
            if (date.contains("\u202f")) {
                return this.UNICODE_FORMAT.parse(date);
            }
            return this.SPACE_FORMAT.parse(date);
        }
        catch (ParseException e) {
            log.error("Error parsing LootRecord date value: {}", (Object)date);
            e.printStackTrace();
            return null;
        }
    }
}

