/*
 * Decompiled with CFR 0.152.
 */
package thestonedturtle.lootlogger.data;

import com.google.common.collect.ImmutableMap;
import thestonedturtle.lootlogger.data.BossTab;

public enum Pet {
    PET_GENERAL_GRAARDOR(12650, BossTab.GENERAL_GRAARDOR.getName()),
    PET_KREEARRA(12649, BossTab.KREEARRA.getName()),
    PET_KRIL_TSUTSAROTH(12652, BossTab.KRIL_TSUTSAROTH.getName()),
    PET_ZILYANA(12651, BossTab.COMMANDER_ZILYANA.getName()),
    CALLISTO_CUB(13178, BossTab.CALLISTO.getName(), "Artio"),
    PET_CHAOS_ELEMENTAL(11995, BossTab.CHAOS_ELEMENTAL.getName(), BossTab.CHAOS_FANATIC.getName()),
    SCORPIAS_OFFSPRING(13181, BossTab.SCORPIA.getName()),
    VENENATIS_SPIDERLING(13177, BossTab.VENENATIS.getName(), "Spindel"),
    VETION_JR(13179, BossTab.VETION.getName(), "Vet'ion", "Calvar'ion"),
    PRINCE_BLACK_DRAGON(12653, BossTab.KING_BLACK_DRAGON.getName()),
    ABYSSAL_ORPHAN(13262, BossTab.ABYSSAL_SIRE.getName()),
    HELLPUPPY(13247, BossTab.CERBERUS.getName()),
    NOON(21748, BossTab.GROTESQUE_GUARDIANS.getName()),
    PET_KRAKEN(12655, BossTab.KRAKEN.getName()),
    PET_SMOKE_DEVIL(12648, BossTab.THERMONUCLEAR_SMOKE_DEVIL.getName()),
    SKOTOS(21273, BossTab.SKOTIZO.getName()),
    BABY_MOLE(12646, BossTab.GIANT_MOLE.getName()),
    KALPHITE_PRINCESS(12647, BossTab.KALPHITE_QUEEN.getName()),
    OLMLET(20851, BossTab.CHAMBERS_OF_XERIC.getName()),
    LIL_ZIK(22473, BossTab.THEATRE_OF_BLOOD.getName()),
    PET_DARK_CORE(12816, BossTab.CORPOREAL_BEAST.getName()),
    PET_SNAKELING(12921, BossTab.ZULRAH.getName()),
    PET_DAGANNOTH_REX(12645, BossTab.DAGANNOTH_REX.getName()),
    PET_DAGANNOTH_PRIME(12644, BossTab.DAGANNOTH_PRIME.getName()),
    PET_DAGANNOTH_SUPREME(12643, BossTab.DAGANNOTH_SUPREME.getName()),
    VORKI(21992, BossTab.VORKATH.getName()),
    BLOODHOUND(19730, BossTab.CLUE_SCROLL_MASTER.getName()),
    IKKLE_HYDRA(22746, BossTab.ALCHEMICAL_HYDRA.getName()),
    YOUNGLLEF(23757, BossTab.THE_GAUNTLET.getName()),
    SRARACHA(23495, BossTab.SARACHNIS.getName()),
    SMOLCANO(23760, BossTab.ZALCANO.getName()),
    LITTLE_NIGHTMARE(24491, BossTab.NIGHTMARE.getName(), BossTab.PHOSANIS_NIGHTMARE.getName()),
    HERBI(21509, "Herbiboar"),
    PHOENIX(20693, BossTab.WINTERTODT.getName()),
    PET_PENANCE_QUEEN(12703, "Barbarian Assault"),
    TINY_TEMPOR(25602, BossTab.TEMPOROSS.getName()),
    TUMEKENS_GUARDIAN(27352, BossTab.TOMBS_OF_AMASCUT.getName()),
    MUPHIN(27590, BossTab.PHANTOM_MUSPAH.getName());

    private static final ImmutableMap<String, Pet> BOSS_MAP;
    private final int petID;
    private final String[] bossNames;

    private Pet(int id, String ... bossNames) {
        this.petID = id;
        this.bossNames = bossNames;
    }

    public static Pet getByBossName(String name) {
        return (Pet)((Object)BOSS_MAP.get((Object)name.toUpperCase()));
    }

    public int getPetID() {
        return this.petID;
    }

    public String[] getBossNames() {
        return this.bossNames;
    }

    static {
        ImmutableMap.Builder byName = ImmutableMap.builder();
        for (Pet pet : Pet.values()) {
            for (String bossName : pet.getBossNames()) {
                byName.put((Object)bossName.toUpperCase(), (Object)pet);
            }
        }
        BOSS_MAP = byName.build();
    }
}

