/*
 * Decompiled with CFR 0.152.
 */
package thestonedturtle.lootlogger.data;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.runelite.http.api.loottracker.LootRecordType;
import thestonedturtle.lootlogger.data.UniqueItem;
import thestonedturtle.lootlogger.localstorage.LTItemEntry;
import thestonedturtle.lootlogger.localstorage.LTRecord;

public class LootLog {
    private static final Pattern CLUE_ITEM_TYPE_PATTERN = Pattern.compile("\\((\\w*)\\)");
    private final String name;
    private LootRecordType type;
    private final List<LTRecord> records = new ArrayList<LTRecord>();
    private final Map<Integer, LTItemEntry> consolidated = new HashMap<Integer, LTItemEntry>();
    private final Collection<UniqueItem> uniques;
    private final Set<Integer> uniqueIds = new HashSet<Integer>();
    private final Multimap<Integer, UniqueItem> uniquePositionMap = ArrayListMultimap.create();
    private final List<LootLog> minionLogs = new ArrayList<LootLog>();

    public LootLog(Collection<LTRecord> records, String name) {
        this.records.addAll(records);
        this.name = name;
        if (records.size() == 0) {
            this.type = LootRecordType.UNKNOWN;
        } else {
            LTRecord record = this.records.get(0);
            this.type = record.getType();
        }
        for (LTRecord rec : records) {
            for (LTItemEntry entry : rec.getDrops()) {
                this.addItemEntryToMap(entry);
            }
        }
        Collection<UniqueItem> unsorted = UniqueItem.getUniquesForBoss(name);
        if (unsorted == null) {
            this.uniques = new ArrayList<UniqueItem>();
            return;
        }
        this.uniques = unsorted.stream().sorted(Comparator.comparingInt(UniqueItem::getPosition)).collect(Collectors.toList());
    }

    public synchronized void addRecord(LTRecord record) {
        this.records.add(record);
        for (LTItemEntry entry : record.getDrops()) {
            this.addItemEntryToMap(entry);
        }
    }

    private void addItemEntryToMap(LTItemEntry item) {
        LTItemEntry oldEntry;
        Matcher m;
        String itemNameLowercased = item.getName().toLowerCase();
        ClueType type = null;
        if (itemNameLowercased.startsWith("clue scroll")) {
            type = ClueType.SCROLL;
        } else if (itemNameLowercased.startsWith("casket ")) {
            type = ClueType.CASKET;
        }
        if (type != null && (m = CLUE_ITEM_TYPE_PATTERN.matcher(item.getName())).find()) {
            String result = m.group(1);
            int id = item.getId();
            switch (result.toLowerCase()) {
                case "easy": {
                    id = type.equals((Object)ClueType.SCROLL) ? 2677 : 2714;
                    break;
                }
                case "medium": {
                    id = type.equals((Object)ClueType.SCROLL) ? 2801 : 2802;
                    break;
                }
                case "hard": {
                    id = type.equals((Object)ClueType.SCROLL) ? 2722 : 2724;
                    break;
                }
                case "elite": {
                    id = type.equals((Object)ClueType.SCROLL) ? 12073 : 12084;
                }
            }
            item = new LTItemEntry(item.getName(), id, item.getQuantity(), item.getPrice());
        }
        if ((oldEntry = this.consolidated.get(item.getId())) != null) {
            oldEntry.setPrice(item.getPrice());
            oldEntry.setQuantity(oldEntry.getQuantity() + item.getQuantity());
        } else {
            this.consolidated.put(item.getId(), new LTItemEntry(item.getName(), item.getId(), item.getQuantity(), item.getPrice()));
        }
    }

    @Nullable
    public LootLog getMinionLog(String name) {
        for (LootLog log : this.minionLogs) {
            if (!log.getName().equalsIgnoreCase(name)) continue;
            return log;
        }
        return null;
    }

    public long getLootValue(boolean includeMinions) {
        long value = this.getConsolidated().values().stream().mapToLong(e -> e.getPrice() * (long)e.getQuantity()).sum();
        if (includeMinions) {
            for (LootLog minionLog : this.minionLogs) {
                value += minionLog.getConsolidated().values().stream().mapToLong(e -> e.getPrice() * (long)e.getQuantity()).sum();
            }
        }
        return value;
    }

    public static void recalculateUniques(LootLog lootLog, boolean includeMinions) {
        lootLog.getUniqueIds().clear();
        lootLog.getUniquePositionMap().clear();
        ArrayList<LootLog> allLogs = new ArrayList<LootLog>();
        allLogs.add(lootLog);
        if (includeMinions) {
            allLogs.addAll(lootLog.getMinionLogs());
        }
        for (UniqueItem item : lootLog.getUniques()) {
            List ids = Arrays.stream(item.getAlternativeIds()).boxed().collect(Collectors.toList());
            ids.add(item.getItemID());
            ids.add(item.getLinkedID());
            int qty = 0;
            Iterator iterator = ids.iterator();
            while (iterator.hasNext()) {
                int id = (Integer)iterator.next();
                lootLog.getUniqueIds().add(id);
                for (LootLog log : allLogs) {
                    LTItemEntry entry = log.getConsolidated().get(id);
                    qty += entry == null ? 0 : entry.getQuantity();
                }
            }
            item.setQty(qty);
            lootLog.getUniquePositionMap().put((Object)item.getPosition(), (Object)item);
        }
    }

    public String getName() {
        return this.name;
    }

    public LootRecordType getType() {
        return this.type;
    }

    public List<LTRecord> getRecords() {
        return this.records;
    }

    public Map<Integer, LTItemEntry> getConsolidated() {
        return this.consolidated;
    }

    public Collection<UniqueItem> getUniques() {
        return this.uniques;
    }

    public Set<Integer> getUniqueIds() {
        return this.uniqueIds;
    }

    public Multimap<Integer, UniqueItem> getUniquePositionMap() {
        return this.uniquePositionMap;
    }

    public List<LootLog> getMinionLogs() {
        return this.minionLogs;
    }

    public void setType(LootRecordType type) {
        this.type = type;
    }

    private static enum ClueType {
        SCROLL,
        CASKET;

    }
}

