/*
 * Decompiled with CFR 0.152.
 */
package thestonedturtle.lootlogger.data;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.runelite.http.api.loottracker.LootRecordType;

public enum BossTab {
    BARROWS("Barrows", 19629, "Other", LootRecordType.EVENT, new String[0]),
    CHAMBERS_OF_XERIC("Chambers of Xeric", 20851, "Other", LootRecordType.EVENT, new String[0]),
    THEATRE_OF_BLOOD("Theatre of Blood", 22473, "Other", LootRecordType.EVENT, new String[0]),
    TOMBS_OF_AMASCUT("Tombs of Amascut", 27352, "Other", LootRecordType.EVENT, (Collection<String>)ImmutableSet.of((Object)"Cache of runes"), new String[0]),
    ZULRAH("Zulrah", 12921, "Other", LootRecordType.NPC, new String[0]),
    VORKATH("Vorkath", 21992, "Other", LootRecordType.NPC, new String[0]),
    VARDORVIS("Vardorvis", 28248, "Forgotten Four", LootRecordType.NPC, new String[0]),
    THE_LEVIATHAN("The Leviathan", 28252, "Forgotten Four", LootRecordType.NPC, new String[0]),
    DUKE_SUCELLUS("Duke Sucellus", 28250, "Forgotten Four", LootRecordType.NPC, new String[0]),
    THE_WHISPERER("The Whisperer", 28246, "Forgotten Four", LootRecordType.NPC, new String[0]),
    KREEARRA("Kree'arra", 12649, "God Wars Dungeon", LootRecordType.NPC, (Collection<String>)ImmutableSet.of((Object)"Wingman Skree", (Object)"Flockleader Geerin", (Object)"Flight Kilisa"), new String[0]),
    GENERAL_GRAARDOR("General Graardor", 12650, "God Wars Dungeon", LootRecordType.NPC, (Collection<String>)ImmutableSet.of((Object)"Sergeant Strongstack", (Object)"Sergeant Steelwill", (Object)"Sergeant Grimspike"), new String[0]),
    COMMANDER_ZILYANA("Commander Zilyana", 12651, "God Wars Dungeon", LootRecordType.NPC, (Collection<String>)ImmutableSet.of((Object)"Growler", (Object)"Bree", (Object)"Starlight"), new String[0]),
    KRIL_TSUTSAROTH("K'ril Tsutsaroth", 12652, "God Wars Dungeon", LootRecordType.NPC, (Collection<String>)ImmutableSet.of((Object)"Balfrug Kreeyath", (Object)"Tstanon Karlak", (Object)"Zakl'n Gritch"), new String[0]),
    NEX("Nex", 26348, "God Wars Dungeon", LootRecordType.NPC, (Collection<String>)ImmutableSet.of((Object)"Fumus", (Object)"Umbra", (Object)"Cruor", (Object)"Glacies"), new String[0]),
    VETION("Vet'ion Reborn", 13179, "Wilderness", LootRecordType.NPC, (Collection<String>)ImmutableSet.of((Object)"Calvar'ion"), "Vet'ion"),
    VENENATIS("Venenatis", 13177, "Wilderness", LootRecordType.NPC, (Collection<String>)ImmutableSet.of((Object)"Spindel"), new String[0]),
    CALLISTO("Callisto", 13178, "Wilderness", LootRecordType.NPC, (Collection<String>)ImmutableSet.of((Object)"Artio"), new String[0]),
    CHAOS_ELEMENTAL("Chaos Elemental", 11995, "Wilderness", LootRecordType.NPC, new String[0]),
    SCORPIA("Scorpia", 13181, "Wilderness", LootRecordType.NPC, new String[0]),
    CHAOS_FANATIC("Chaos Fanatic", 4675, "Wilderness", LootRecordType.NPC, new String[0]),
    CRAZY_ARCHAEOLOGIST("Crazy Archaeologist", 11990, "Wilderness", LootRecordType.NPC, new String[0]),
    KING_BLACK_DRAGON("King Black Dragon", 12653, "Wilderness", LootRecordType.NPC, new String[0]),
    KALPHITE_QUEEN("Kalphite Queen", 12647, "Other", LootRecordType.NPC, new String[0]),
    SKOTIZO("Skotizo", 21273, "Slayer", LootRecordType.NPC, new String[0]),
    GROTESQUE_GUARDIANS("Grotesque Guardians", 21748, "Slayer", LootRecordType.NPC, "Dusk"),
    ABYSSAL_SIRE("Abyssal Sire", 13262, "Slayer", LootRecordType.NPC, new String[0]),
    KRAKEN("Kraken", 12655, "Slayer", LootRecordType.NPC, new String[0]),
    CERBERUS("Cerberus", 13247, "Slayer", LootRecordType.NPC, new String[0]),
    THERMONUCLEAR_SMOKE_DEVIL("Thermonuclear smoke devil", 12648, "Slayer", LootRecordType.NPC, new String[0]),
    ALCHEMICAL_HYDRA("Alchemical Hydra", 22746, "Slayer", LootRecordType.NPC, new String[0]),
    GIANT_MOLE("Giant Mole", 12646, "Other", LootRecordType.NPC, new String[0]),
    CORPOREAL_BEAST("Corporeal Beast", 22318, "Other", LootRecordType.NPC, new String[0]),
    SARACHNIS("Sarachnis", 23495, "Other", LootRecordType.NPC, new String[0]),
    THE_GAUNTLET("The Gauntlet", 23757, "Other", LootRecordType.EVENT, new String[0]),
    NIGHTMARE("The Nightmare", 24491, "Other", LootRecordType.NPC, new String[0]),
    PHOSANIS_NIGHTMARE("Phosani's Nightmare", 25836, "Other", LootRecordType.NPC, new String[0]),
    PHANTOM_MUSPAH("Phantom Muspah", 27590, "Other", LootRecordType.NPC, new String[0]),
    DAGANNOTH_REX("Dagannoth Rex", 12645, "Dagannoth Kings", LootRecordType.NPC, new String[0]),
    DAGANNOTH_PRIME("Dagannoth Prime", 12644, "Dagannoth Kings", LootRecordType.NPC, new String[0]),
    DAGANNOTH_SUPREME("Dagannoth Supreme", 12643, "Dagannoth Kings", LootRecordType.NPC, new String[0]),
    CLUE_SCROLL_BEGINNER("Clue Scroll (Beginner)", 23182, "Clue Scrolls", LootRecordType.EVENT, new String[0]),
    CLUE_SCROLL_EASY("Clue Scroll (Easy)", 2677, "Clue Scrolls", LootRecordType.EVENT, new String[0]),
    CLUE_SCROLL_MEDIUM("Clue Scroll (Medium)", 2801, "Clue Scrolls", LootRecordType.EVENT, new String[0]),
    CLUE_SCROLL_HARD("Clue Scroll (Hard)", 2722, "Clue Scrolls", LootRecordType.EVENT, new String[0]),
    CLUE_SCROLL_ELITE("Clue Scroll (Elite)", 12073, "Clue Scrolls", LootRecordType.EVENT, new String[0]),
    CLUE_SCROLL_MASTER("Clue Scroll (Master)", 19835, "Clue Scrolls", LootRecordType.EVENT, new String[0]),
    WINTERTODT("Wintertodt", 20693, "Skilling", LootRecordType.EVENT, "Supply crate (Wintertodt)"),
    TEMPOROSS("Tempoross", 25602, "Skilling", LootRecordType.EVENT, (Collection<String>)ImmutableSet.of((Object)"Casket (Tempoross)"), "Reward pool (Tempoross)"),
    ZALCANO("Zalcano", 23760, "Skilling", LootRecordType.NPC, new String[0]);

    private final String name;
    private final int itemID;
    private final String category;
    private final LootRecordType type;
    private final Set<String> aliases = new HashSet<String>();
    private final Set<String> minions;
    private static final Map<String, BossTab> NAME_MAP;
    private static final Multimap<String, BossTab> CATEGORY_MAP;

    private BossTab(String name, int itemID, String category, LootRecordType type, String ... aliases) {
        this(name, itemID, category, type, Collections.emptyList(), aliases);
    }

    private BossTab(String name, int itemID, String category, LootRecordType type, Collection<String> minions, String ... aliases) {
        this.name = name;
        this.itemID = itemID;
        this.category = category;
        this.type = type;
        this.aliases.add(name);
        this.aliases.addAll(Arrays.asList(aliases));
        this.minions = minions.stream().map(String::toLowerCase).collect(Collectors.toSet());
    }

    @Nullable
    public static BossTab getByName(String name) {
        return NAME_MAP.get(name.toUpperCase());
    }

    public static Collection<BossTab> getByCategoryName(String name) {
        return CATEGORY_MAP.get((Object)name);
    }

    public static TreeSet<String> getCategories() {
        return new TreeSet<String>(CATEGORY_MAP.keySet());
    }

    public String getName() {
        return this.name;
    }

    public int getItemID() {
        return this.itemID;
    }

    public String getCategory() {
        return this.category;
    }

    public LootRecordType getType() {
        return this.type;
    }

    public Set<String> getAliases() {
        return this.aliases;
    }

    public Set<String> getMinions() {
        return this.minions;
    }

    static {
        ImmutableMap.Builder byName = ImmutableMap.builder();
        ImmutableMultimap.Builder categoryMap = ImmutableMultimap.builder();
        for (BossTab tab : BossTab.values()) {
            for (String name : tab.getAliases()) {
                byName.put((Object)name.toUpperCase(), (Object)tab);
            }
            categoryMap.put((Object)tab.getCategory(), (Object)tab);
        }
        NAME_MAP = byName.build();
        CATEGORY_MAP = categoryMap.build();
    }
}

