/*
 * Decompiled with CFR 0.152.
 */
package thestonedturtle.lootlogger;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.SetMultimap;
import com.google.inject.Provides;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.ItemComposition;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.config.RuneScapeProfileType;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.ItemStack;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.PluginManager;
import net.runelite.client.plugins.loottracker.LootReceived;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.Text;
import net.runelite.http.api.loottracker.LootRecordType;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thestonedturtle.lootlogger.LootLoggerConfig;
import thestonedturtle.lootlogger.data.BossTab;
import thestonedturtle.lootlogger.data.LootLog;
import thestonedturtle.lootlogger.data.Pet;
import thestonedturtle.lootlogger.data.UniqueItem;
import thestonedturtle.lootlogger.localstorage.LTItemEntry;
import thestonedturtle.lootlogger.localstorage.LTRecord;
import thestonedturtle.lootlogger.localstorage.LootRecordWriter;
import thestonedturtle.lootlogger.ui.LootLoggerPanel;

@PluginDescriptor(name="Loot Logger")
public class LootLoggerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(LootLoggerPlugin.class);
    private static final String SIRE_FONT_TEXT = "you place the unsired into the font of consumption...";
    private static final String SIRE_REWARD_TEXT = "the font consumes the unsired";
    private static final int MAX_TEXT_CHECK = 25;
    private static final int MAX_PET_TICKS = 5;
    private static final Pattern CLUE_SCROLL_PATTERN = Pattern.compile("You have completed ([0-9]+) ([a-z]+) Treasure Trails.");
    private static final Pattern BOSS_NAME_NUMBER_PATTERN = Pattern.compile("Your (.*) kill count is:? ([0-9]*).");
    private static final Pattern NUMBER_PATTERN = Pattern.compile("([0-9]+)");
    private static final ImmutableSet<String> PET_MESSAGES = ImmutableSet.of((Object)"You have a funny feeling like you're being followed.", (Object)"You feel something weird sneaking into your backpack.", (Object)"You have a funny feeling like you would have been followed...");
    private static final int NMZ_MAP_REGION = 9033;
    public static final String SESSION_NAME = "Current Session Data";
    @Inject
    private Client client;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    public LootLoggerConfig config;
    @Inject
    private ItemManager itemManager;
    @Inject
    private ClientThread clientThread;
    @Inject
    private LootRecordWriter writer;
    @Inject
    private PluginManager pluginManager;
    private LootLoggerPanel panel;
    private NavigationButton navButton;
    private SetMultimap<LootRecordType, String> lootNames = HashMultimap.create();
    private boolean prepared = false;
    private boolean unsiredReclaiming = false;
    private int unsiredCheckCount = 0;
    private int petTicks = 0;
    private boolean gotPet = false;
    private final Map<String, Integer> killCountMap = new HashMap<String, Integer>();
    private final LinkedListMultimap<String, LTRecord> sessionData = LinkedListMultimap.create();

    @Provides
    LootLoggerConfig provideConfig(ConfigManager configManager) {
        return (LootLoggerConfig)configManager.getConfig(LootLoggerConfig.class);
    }

    protected void startUp() throws Exception {
        Optional<Plugin> mainPlugin;
        this.panel = new LootLoggerPanel(this.itemManager, this);
        BufferedImage icon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"panel-icon.png");
        this.navButton = NavigationButton.builder().tooltip("Loot Logger").icon(icon).priority(6).panel((PluginPanel)this.panel).build();
        if (this.config.enableUI()) {
            this.clientToolbar.addNavigation(this.navButton);
        }
        if (!this.prepared) {
            this.prepared = true;
            this.clientThread.invokeLater(() -> {
                switch (this.client.getGameState()) {
                    case UNKNOWN: 
                    case STARTING: {
                        return false;
                    }
                }
                UniqueItem.prepareUniqueItems(this.itemManager);
                return true;
            });
        }
        if (this.client.getGameState().equals((Object)GameState.LOGGED_IN) || this.client.getGameState().equals((Object)GameState.LOADING)) {
            this.updateWriterUsername();
        }
        if ((mainPlugin = this.pluginManager.getPlugins().stream().filter(p -> p.getName().equals("Loot Tracker")).findFirst()).isPresent() && !this.pluginManager.isPluginEnabled(mainPlugin.get())) {
            this.pluginManager.setPluginEnabled(mainPlugin.get(), true);
        }
    }

    protected void shutDown() {
        if (this.config.enableUI()) {
            this.clientToolbar.removeNavigation(this.navButton);
        }
        this.gotPet = false;
        this.petTicks = 0;
        this.writer.setName(null);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("lootlogger")) {
            if (event.getKey().equals("enableUI")) {
                if (this.config.enableUI()) {
                    this.clientToolbar.addNavigation(this.navButton);
                } else {
                    this.clientToolbar.removeNavigation(this.navButton);
                }
            }
            if (this.config.enableUI()) {
                SwingUtilities.invokeLater(this.panel::refreshUI);
            }
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOGGED_IN) {
            this.updateWriterUsername();
        }
    }

    private void updateWriterUsername() {
        Object folder = String.valueOf(this.client.getAccountHash());
        RuneScapeProfileType profileType = RuneScapeProfileType.getCurrent((Client)this.client);
        if (profileType != RuneScapeProfileType.STANDARD) {
            folder = (String)folder + "-" + Text.titleCase((Enum)profileType);
        }
        if (((String)folder).equalsIgnoreCase(this.writer.getName())) {
            return;
        }
        String name = this.client.getUsername();
        if (name != null && name.length() > 0 && this.client.getAccountHash() != -1L) {
            this.writer.renameUsernameFolderToAccountHash(name.toLowerCase(), this.client.getAccountHash());
        }
        if (this.writer.setPlayerUsername((String)folder)) {
            this.localPlayerNameChanged();
        }
    }

    private void localPlayerNameChanged() {
        this.lootNames = this.writer.getKnownFileNames();
        if (this.config.enableUI()) {
            SwingUtilities.invokeLater(this.panel::showSelectionView);
        }
    }

    private Collection<LTItemEntry> convertToLTItemEntries(Collection<ItemStack> stacks) {
        return stacks.stream().map(i -> this.createLTItemEntry(i.getId(), i.getQuantity())).collect(Collectors.toList());
    }

    private LTItemEntry createLTItemEntry(int id, int qty) {
        ItemComposition c = this.itemManager.getItemComposition(id);
        int realId = c.getNote() == -1 ? c.getId() : c.getLinkedNoteId();
        int price = this.itemManager.getItemPrice(realId);
        return new LTItemEntry(c.getName(), id, qty, price);
    }

    private void addRecord(LTRecord record) {
        this.writer.addLootTrackerRecord(record);
        this.lootNames.put((Object)record.getType(), (Object)record.getName().toLowerCase());
        this.sessionData.put((Object)record.getName().toLowerCase(), (Object)record);
        if (this.config.enableUI()) {
            SwingUtilities.invokeLater(() -> this.panel.addLog(record));
        }
    }

    @Subscribe
    public void onLootReceived(LootReceived event) {
        Pet p;
        if (this.isInNightmareZone() && this.config.ignoreNmz()) {
            return;
        }
        Collection<LTItemEntry> drops = this.convertToLTItemEntries(event.getItems());
        if (this.gotPet && (p = Pet.getByBossName(event.getName())) != null) {
            this.gotPet = false;
            this.petTicks = 0;
            drops.add(this.createLTItemEntry(p.getPetID(), 1));
        }
        int kc = this.killCountMap.getOrDefault(event.getName().toUpperCase(), -1);
        BossTab tab = BossTab.getByName(event.getName());
        if (kc == -1 && tab != null && tab.getAliases().size() > 0) {
            String alias;
            Iterator<String> iterator = tab.getAliases().iterator();
            while (iterator.hasNext() && (kc = this.killCountMap.getOrDefault((alias = iterator.next()).toUpperCase(), -1).intValue()) <= 0) {
            }
        }
        LTRecord record = new LTRecord(event.getName(), event.getCombatLevel(), kc, event.getType(), drops, new Date());
        this.addRecord(record);
    }

    public Collection<LTRecord> getDataByName(LootRecordType type, String name) {
        BossTab tab = BossTab.getByName(name);
        if (tab == null) {
            return this.writer.loadLootTrackerRecords(type, name);
        }
        ArrayList<LTRecord> records = new ArrayList<LTRecord>();
        for (String alias : tab.getAliases()) {
            records.addAll(this.writer.loadLootTrackerRecords(type, alias));
        }
        return records;
    }

    public void requestLootLog(LootRecordType type, String name) {
        this.clientThread.invoke(() -> {
            BossTab tab;
            if (name.equalsIgnoreCase(SESSION_NAME)) {
                LootLog log = new LootLog(Collections.emptyList(), name);
                for (String key : this.sessionData.keySet()) {
                    log.getMinionLogs().add(new LootLog(this.sessionData.get((Object)key), key));
                }
                SwingUtilities.invokeLater(() -> this.panel.useLog(log));
                return;
            }
            Collection<LTRecord> records = this.getDataByName(type, name);
            LootLog log = new LootLog(records, name);
            if (log.getType().equals((Object)LootRecordType.UNKNOWN)) {
                log.setType(type);
            }
            if ((tab = BossTab.getByName(name)) != null && tab.getMinions().size() > 0) {
                for (String minion : tab.getMinions()) {
                    Collection<LTRecord> minionRecords = this.getDataByName(type, minion);
                    LootLog minionLog = new LootLog(minionRecords, minion);
                    log.getMinionLogs().add(minionLog);
                }
            }
            SwingUtilities.invokeLater(() -> this.panel.useLog(log));
        });
    }

    public boolean clearStoredDataByName(LootRecordType type, String name) {
        if (name.equalsIgnoreCase(SESSION_NAME)) {
            this.sessionData.clear();
            return true;
        }
        if (this.panel.getLootLog().getName().equalsIgnoreCase(SESSION_NAME)) {
            this.sessionData.removeAll((Object)name.toLowerCase());
            return true;
        }
        this.lootNames.remove((Object)type, (Object)name);
        return this.writer.deleteLootTrackerRecords(type, name);
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded event) {
        if (event.getGroupId() != 193) {
            return;
        }
        Widget text = this.client.getWidget(12648450);
        if (text != null && text.getText().toLowerCase().contains(SIRE_FONT_TEXT)) {
            this.unsiredCheckCount = 0;
            this.unsiredReclaiming = true;
        }
    }

    @Subscribe
    public void onGameTick(GameTick t) {
        if (this.gotPet) {
            if (this.petTicks > 5) {
                this.gotPet = false;
                this.petTicks = 0;
            } else {
                ++this.petTicks;
            }
        }
        if (this.unsiredReclaiming) {
            if (this.hasUnsiredWidgetUpdated()) {
                this.unsiredReclaiming = false;
                return;
            }
            ++this.unsiredCheckCount;
            if (this.unsiredCheckCount >= 25) {
                this.unsiredReclaiming = false;
            }
        }
    }

    private boolean hasUnsiredWidgetUpdated() {
        Widget text = this.client.getWidget(12648450);
        if (text != null && text.getText().toLowerCase().contains(SIRE_REWARD_TEXT)) {
            Widget sprite = this.client.getWidget(193);
            if (sprite == null || sprite.getItemId() == -1) {
                return false;
            }
            log.debug("Unsired was exchanged for item ID: {}", (Object)sprite.getItemId());
            this.receivedUnsiredLoot(sprite.getItemId());
            return true;
        }
        return false;
    }

    private void receivedUnsiredLoot(int itemID) {
        this.clientThread.invokeLater(() -> {
            Collection<LTRecord> data = this.getDataByName(LootRecordType.NPC, BossTab.ABYSSAL_SIRE.getName());
            ItemComposition c = this.itemManager.getItemComposition(itemID);
            LTItemEntry itemEntry = new LTItemEntry(c.getName(), itemID, 1, 0L);
            log.debug("Received Unsired item: {}", (Object)c.getName());
            if (data == null) {
                log.debug("No previous Abyssal sire loot, creating new loot record");
                LTRecord r = new LTRecord(BossTab.ABYSSAL_SIRE.getName(), 350, -1, LootRecordType.NPC, Collections.singletonList(itemEntry), new Date());
                this.addRecord(r);
                return;
            }
            log.debug("Adding drop to last abyssal sire loot record");
            ArrayList<LTRecord> items = new ArrayList<LTRecord>(data);
            LTRecord r = (LTRecord)items.get(items.size() - 1);
            r.addDropEntry(itemEntry);
            this.writer.writeLootTrackerFile(BossTab.ABYSSAL_SIRE.getName(), items);
            if (this.config.enableUI()) {
                SwingUtilities.invokeLater(this.panel::refreshUI);
            }
        });
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        Matcher n;
        Matcher m;
        if (event.getType() != ChatMessageType.GAMEMESSAGE && event.getType() != ChatMessageType.SPAM) {
            return;
        }
        String chatMessage = Text.removeTags((String)event.getMessage());
        if (PET_MESSAGES.contains((Object)chatMessage)) {
            this.gotPet = true;
        }
        if ((m = CLUE_SCROLL_PATTERN.matcher(chatMessage)).find()) {
            String eventType;
            switch (m.group(2).toLowerCase()) {
                case "beginner": {
                    eventType = "Clue Scroll (Beginner)";
                    break;
                }
                case "easy": {
                    eventType = "Clue Scroll (Easy)";
                    break;
                }
                case "medium": {
                    eventType = "Clue Scroll (Medium)";
                    break;
                }
                case "hard": {
                    eventType = "Clue Scroll (Hard)";
                    break;
                }
                case "elite": {
                    eventType = "Clue Scroll (Elite)";
                    break;
                }
                case "master": {
                    eventType = "Clue Scroll (Master)";
                    break;
                }
                default: {
                    return;
                }
            }
            int killCount = Integer.valueOf(m.group(1));
            this.killCountMap.put(eventType.toUpperCase(), killCount);
            return;
        }
        if (chatMessage.startsWith("Your Barrows chest count is") && (n = NUMBER_PATTERN.matcher(chatMessage)).find()) {
            this.killCountMap.put("BARROWS", Integer.valueOf(n.group()));
            return;
        }
        if (chatMessage.startsWith("Your completed Chambers of Xeric count is") && (n = NUMBER_PATTERN.matcher(chatMessage)).find()) {
            this.killCountMap.put("CHAMBERS OF XERIC", Integer.valueOf(n.group()));
            return;
        }
        if (chatMessage.startsWith("Your completed Theatre of Blood count is") && (n = NUMBER_PATTERN.matcher(chatMessage)).find()) {
            this.killCountMap.put("THEATRE OF BLOOD", Integer.valueOf(n.group()));
            return;
        }
        Matcher boss = BOSS_NAME_NUMBER_PATTERN.matcher(chatMessage);
        if (boss.find()) {
            String bossName = boss.group(1);
            int killCount = Integer.valueOf(boss.group(2));
            this.killCountMap.put(bossName.toUpperCase(), killCount);
        }
    }

    private boolean isInNightmareZone() {
        if (this.client.getLocalPlayer() == null) {
            return false;
        }
        return ArrayUtils.contains((int[])this.client.getMapRegions(), (int)9033) && this.client.getLocalPlayer().getWorldLocation().getPlane() > 0;
    }

    public SetMultimap<LootRecordType, String> getLootNames() {
        return this.lootNames;
    }
}

