/*
 * Decompiled with CFR 0.152.
 */
package com.daynightbrightness;

import com.daynightbrightness.DayNightBrightnessConfig;
import com.google.inject.Provides;
import java.time.LocalTime;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.GameStateChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Day & Night Brightness")
public class DayNightBrightnessPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(DayNightBrightnessPlugin.class);
    @Inject
    private Client client;
    @Inject
    private DayNightBrightnessConfig config;
    @Inject
    private ConfigManager configManager;

    protected void startUp() throws Exception {
        log.info("Day & Night Brightness started!");
    }

    protected void shutDown() throws Exception {
        log.info("Day & Night Brightness stopped!");
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGGED_IN) {
            LocalTime currentTime = LocalTime.now();
            if (currentTime.isAfter(LocalTime.of(this.config.dayHour(), 0)) && currentTime.isBefore(LocalTime.of(this.config.nightHour(), 0))) {
                this.client.runScript(new Object[]{3966, 15, this.config.dayBrightness()});
            } else {
                this.client.runScript(new Object[]{3966, 15, this.config.nightBrightness()});
            }
        }
    }

    @Provides
    DayNightBrightnessConfig provideConfig(ConfigManager configManager) {
        return (DayNightBrightnessConfig)configManager.getConfig(DayNightBrightnessConfig.class);
    }
}

