/*
 * Decompiled with CFR 0.152.
 */
package com.unpottedreminder;

import com.google.common.collect.ImmutableList;
import com.google.inject.Provides;
import com.unpottedreminder.UnpottedReminderConfig;
import com.unpottedreminder.UnpottedReminderOverlay;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.Skill;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.GraphicChanged;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.StatChanged;
import net.runelite.client.Notifier;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.Text;
import net.runelite.client.util.WildcardMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Unpotted Reminder", description="Reminds you you're unpotted in combat when you have one in your inventory", tags={"combat", "potion", "reminder", "overlay", "pvm", "alert"})
public class UnpottedReminderPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(UnpottedReminderPlugin.class);
    @Inject
    private Client client;
    @Inject
    private UnpottedReminderConfig config;
    @Inject
    private UnpottedReminderOverlay overlay;
    @Inject
    private Notifier notifier;
    @Inject
    private ClientThread clientThread;
    @Inject
    private OverlayManager overlayManager;
    private Item[] playerItems;
    private List<String> blacklisted = new ArrayList<String>();
    private List<String> whitelisted = new ArrayList<String>();
    private Instant alertStart;
    private Instant lastNotify;
    private int invigorateTick;
    private int remainingDuration;
    private static final int IMBUED_HEART_DURATION_TICKS = 700;
    private static final String IMBUED_HEART_READY_MESSAGE = "Your imbued heart has regained its magical power.";
    private static final Pattern IMBUED_HEART_BUSY_MESSAGE = Pattern.compile("The heart is still drained of its power. Judging by how it feels, it will be ready in around (\\d+) (\\w+)\\.");
    private static final int IMBUED_HEART_GRAPHIC = 1316;
    private static final List<Integer> MELEE_POTIONS = ImmutableList.of((Object)9739, (Object)9741, (Object)9743, (Object)9745, (Object)12695, (Object)12697, (Object)12699, (Object)12701, (Object)23685, (Object)23688, (Object)23691, (Object)23694, (Object[])new Integer[]{2428, 121, 123, 125, 2436, 145, 147, 149, 23697, 23700, 23703, 23706, 113, 115, 117, 119, 2440, 157, 159, 161, 23709, 23712, 23715, 23718});
    private static final List<Integer> RANGED_POTIONS = ImmutableList.of((Object)2444, (Object)169, (Object)171, (Object)173, (Object)23733, (Object)23736, (Object)23739, (Object)23742, (Object)22461, (Object)22464, (Object)22467, (Object)22470, (Object[])new Integer[]{24635, 24638, 24641, 24644});
    private static final List<Integer> MAGIC_POTIONS = ImmutableList.of((Object)3040, (Object)3042, (Object)3040, (Object)22449, (Object)22452, (Object)22455, (Object)22458);
    private static final List<Integer> OVERLOADS = ImmutableList.of((Object)27343, (Object)27345, (Object)11730, (Object)11731, (Object)11732, (Object)11733, (Object)20996, (Object)20995, (Object)20994, (Object)20993);
    private static final List<Integer> DEFENSIVE_CASTING_WEAPONTYPES = ImmutableList.of((Object)18, (Object)21);
    private static final List<Integer> RANGED_WEAPONTYPES = ImmutableList.of((Object)3, (Object)5, (Object)6, (Object)7, (Object)19);
    private static final Integer POWERED_STAFF_WEAPONTYPE = 23;
    private static final Integer ATTACK_STYLE_DEFENSIVE = 3;
    private static final List<Skill> MELEE_SKILLS = ImmutableList.of((Object)Skill.ATTACK, (Object)Skill.STRENGTH, (Object)Skill.DEFENCE);
    private final List<Skill> trackedSkills = ImmutableList.of((Object)Skill.ATTACK, (Object)Skill.STRENGTH, (Object)Skill.DEFENCE, (Object)Skill.RANGED, (Object)Skill.MAGIC);
    private final EnumMap<Skill, Integer> playerExperience = new EnumMap(Skill.class);
    private final EnumMap<Skill, Integer> playerBoosts = new EnumMap(Skill.class);

    @Provides
    UnpottedReminderConfig getConfig(ConfigManager configManager) {
        return (UnpottedReminderConfig)configManager.getConfig(UnpottedReminderConfig.class);
    }

    protected void startUp() {
        this.invigorateTick = -1;
        this.remainingDuration = 0;
        this.blacklisted = this.splitList(this.config.blacklist());
        this.whitelisted = this.splitList(this.config.whitelist());
        this.clientThread.invoke(() -> {
            if (this.client.getGameState() == GameState.LOGGED_IN) {
                for (Skill skill : this.trackedSkills) {
                    this.playerExperience.put(skill, this.client.getSkillExperience(skill));
                }
                ItemContainer inventory = this.client.getItemContainer(InventoryID.INVENTORY);
                if (inventory != null) {
                    this.playerItems = inventory.getItems();
                }
            }
        });
    }

    protected void shutDown() {
        this.playerItems = null;
        this.alertStart = null;
        this.playerExperience.clear();
        this.invigorateTick = -1;
        this.remainingDuration = 0;
        this.overlayManager.remove((Overlay)this.overlay);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("unpottedreminder")) {
            this.blacklisted = this.splitList(this.config.blacklist());
            this.whitelisted = this.splitList(this.config.whitelist());
            if (!this.config.showOverlay()) {
                this.overlayManager.remove((Overlay)this.overlay);
            }
        }
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        if (event.getItemContainer() == this.client.getItemContainer(InventoryID.INVENTORY)) {
            this.playerItems = event.getItemContainer().getItems();
        }
    }

    @Subscribe
    public void onStatChanged(StatChanged event) {
        Skill skill = event.getSkill();
        if (!this.trackedSkills.contains(skill)) {
            return;
        }
        int xpDiff = event.getXp() - this.playerExperience.getOrDefault(skill, -1);
        int boost = event.getBoostedLevel() - event.getLevel();
        this.playerBoosts.put(skill, boost);
        this.playerExperience.put(skill, event.getXp());
        if (this.config.experienceThreshold() > 0 && xpDiff > this.config.experienceThreshold()) {
            return;
        }
        if (this.shouldAlert(skill)) {
            this.alert();
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (this.invigorateTick > 0 && this.client.getTickCount() > this.invigorateTick + this.remainingDuration) {
            this.invigorateTick = -1;
            this.remainingDuration = 0;
        }
        if (null != this.alertStart && Instant.now().minusSeconds(this.config.timeout()).isAfter(this.alertStart)) {
            this.clearAlert();
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        Matcher heartBusy;
        String msg = Text.removeTags((String)event.getMessage());
        if (msg.contains("You drink some of your")) {
            this.clearAlert();
        }
        if (msg.equals(IMBUED_HEART_READY_MESSAGE)) {
            this.invigorateTick = -1;
            this.remainingDuration = 0;
        }
        if ((heartBusy = IMBUED_HEART_BUSY_MESSAGE.matcher(msg)).find()) {
            if (heartBusy.group(2).startsWith("minute")) {
                this.remainingDuration = (int)((double)(Integer.parseInt(heartBusy.group(1)) * 60) / 0.6);
            } else if (heartBusy.group(2).startsWith("second")) {
                this.remainingDuration = (int)((double)Integer.parseInt(heartBusy.group(1)) / 0.6);
            }
            this.invigorateTick = this.client.getTickCount();
        }
    }

    @Subscribe
    public void onGraphicChanged(GraphicChanged event) {
        if (event.getActor().getGraphic() == 1316 && Objects.equals(event.getActor().getName(), this.client.getLocalPlayer().getName())) {
            this.invigorateTick = this.client.getTickCount();
            this.remainingDuration = 700;
            this.clearAlert();
        }
    }

    private void alert() {
        boolean shouldNotify = this.config.shouldNotify() && (null == this.lastNotify || Instant.now().minusSeconds(this.config.notifyCooldown()).isAfter(this.lastNotify));
        this.alertStart = Instant.now();
        if (this.config.showOverlay()) {
            this.overlayManager.add((Overlay)this.overlay);
        }
        if (shouldNotify) {
            this.notifier.notify("You need to drink your boost potion!");
            this.lastNotify = Instant.now();
        }
    }

    private void clearAlert() {
        this.overlayManager.remove((Overlay)this.overlay);
        this.alertStart = null;
    }

    private boolean shouldAlert(Skill skill) {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return false;
        }
        if (Skill.DEFENCE.equals((Object)skill)) {
            skill = this.getPrimarySkillForDefensive();
        }
        if (this.isSkillDisabled(skill)) {
            return false;
        }
        if (!this.client.isInInstancedRegion() && this.config.onlyInInstances()) {
            return false;
        }
        if (!this.interactingShouldAlert()) {
            return false;
        }
        if (!this.hasBoostPotionInInventory(skill)) {
            return false;
        }
        return this.isBoostBelowThreshold(skill);
    }

    private Skill getPrimarySkillForDefensive() {
        if (this.usingDefensiveMagic()) {
            return Skill.MAGIC;
        }
        if (this.usingDefensiveRanged()) {
            return Skill.RANGED;
        }
        return Skill.STRENGTH;
    }

    private boolean isSkillDisabled(Skill skill) {
        switch (skill) {
            case MAGIC: {
                return !this.config.enableMagic();
            }
            case RANGED: {
                return !this.config.enableRanged();
            }
            case ATTACK: 
            case STRENGTH: {
                return !this.config.enableMelee();
            }
        }
        return true;
    }

    private boolean interactingShouldAlert() {
        String interactingName;
        String string = interactingName = this.client.getLocalPlayer().getInteracting() != null ? this.client.getLocalPlayer().getInteracting().getName() : null;
        if (null == interactingName) {
            return this.config.alertWhenNotInteracting();
        }
        boolean isBlackListed = this.config.useBlacklist() && this.blacklisted.stream().anyMatch(npcName -> WildcardMatcher.matches((String)npcName, (String)interactingName));
        boolean isWhitelisted = !this.config.useWhitelist() || this.whitelisted.stream().anyMatch(npcName -> WildcardMatcher.matches((String)npcName, (String)interactingName));
        return isWhitelisted && !isBlackListed;
    }

    private boolean hasBoostPotionInInventory(Skill skill) {
        boolean heartReady;
        boolean bl = heartReady = this.invigorateTick <= 0;
        if (MELEE_SKILLS.contains(skill) && this.config.enableMelee() && Arrays.stream(this.playerItems).anyMatch(item -> MELEE_POTIONS.contains(item.getId()))) {
            return true;
        }
        if (Skill.RANGED == skill && this.config.enableRanged() && Arrays.stream(this.playerItems).anyMatch(item -> RANGED_POTIONS.contains(item.getId()))) {
            return true;
        }
        if (Skill.MAGIC == skill && this.config.enableMagic() && Arrays.stream(this.playerItems).anyMatch(item -> item.getId() == 20724 && heartReady || MAGIC_POTIONS.contains(item.getId()))) {
            return true;
        }
        return (this.config.enableMelee() || this.config.enableRanged() || this.config.enableMagic()) && Arrays.stream(this.playerItems).anyMatch(item -> OVERLOADS.contains(item.getId()));
    }

    private boolean isBoostBelowThreshold(Skill skill) {
        if (MELEE_SKILLS.contains(skill) && this.config.enableMelee() && this.playerBoosts.getOrDefault(skill, -1) <= this.config.meleeBoostThreshold()) {
            return true;
        }
        if (Skill.RANGED == skill && this.config.enableRanged() && this.playerBoosts.getOrDefault(Skill.RANGED, -1) <= this.config.rangedBoostThreshold()) {
            return true;
        }
        return Skill.MAGIC == skill && this.config.enableMagic() && this.playerBoosts.getOrDefault(Skill.MAGIC, -1) <= this.config.magicBoostThreshold();
    }

    private boolean usingDefensiveMagic() {
        int defensiveCasting = this.client.getVarbitValue(2668);
        int currentAttackStyleVarbit = this.client.getVarpValue(43);
        int equippedWeaponTypeVarbit = this.client.getVarbitValue(357);
        if (POWERED_STAFF_WEAPONTYPE == equippedWeaponTypeVarbit && ATTACK_STYLE_DEFENSIVE == currentAttackStyleVarbit) {
            return true;
        }
        return DEFENSIVE_CASTING_WEAPONTYPES.contains(equippedWeaponTypeVarbit) && defensiveCasting == 1;
    }

    private boolean usingDefensiveRanged() {
        int currentAttackStyleVarbit = this.client.getVarpValue(43);
        int equippedWeaponTypeVarbit = this.client.getVarbitValue(357);
        return RANGED_WEAPONTYPES.contains(equippedWeaponTypeVarbit) && ATTACK_STYLE_DEFENSIVE == currentAttackStyleVarbit;
    }

    private List<String> splitList(String list) {
        return Arrays.stream(list.split(",")).map(String::trim).collect(Collectors.toList());
    }
}

