/*
 * Decompiled with CFR 0.152.
 */
package com.unpottedreminder;

import com.unpottedreminder.UnpottedReminderConfig;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.LineComponent;

class UnpottedReminderOverlay
extends OverlayPanel {
    private final Client client;
    private final UnpottedReminderConfig config;

    @Inject
    private UnpottedReminderOverlay(Client client, UnpottedReminderConfig config) {
        this.client = client;
        this.config = config;
    }

    public Dimension render(Graphics2D graphics) {
        this.panelComponent.getChildren().clear();
        this.panelComponent.getChildren().add(LineComponent.builder().left("You need to drink your boost potion!").build());
        if (this.config.shouldFlash()) {
            if (this.client.getGameCycle() % 40 >= 20) {
                this.panelComponent.setBackgroundColor(this.config.flashColor1());
            } else {
                this.panelComponent.setBackgroundColor(this.config.flashColor2());
            }
        } else {
            this.panelComponent.setBackgroundColor(this.config.flashColor1());
        }
        this.setPosition(OverlayPosition.BOTTOM_RIGHT);
        return this.panelComponent.render(graphics);
    }
}

