/*
 * Decompiled with CFR 0.152.
 */
package cc.jambox;

import cc.jambox.ItemCounter;
import cc.jambox.ItemCounterConfig;
import com.google.inject.Provides;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Regex Item Counter")
public class ItemCounterPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ItemCounterPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ItemCounterConfig config;
    @Inject
    private ClientThread clientThread;
    private HashMap<String, ItemCounter> itemMap;
    private Pattern[] regexes;
    @Inject
    private InfoBoxManager infoBoxManager;
    @Inject
    private ItemManager itemManager;

    protected void startUp() throws Exception {
        this.regexes = (Pattern[])Text.fromCSV((String)this.config.itemList()).stream().map(n -> Pattern.compile(n, 2)).toArray(Pattern[]::new);
        this.itemMap = new HashMap();
        this.update();
    }

    protected void shutDown() throws Exception {
        this.itemMap.values().stream().forEach(rem -> this.infoBoxManager.removeInfoBox((InfoBox)rem));
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if (!configChanged.getGroup().equals("regexitemcounter")) {
            return;
        }
        this.itemMap.values().stream().forEach(rem -> this.infoBoxManager.removeInfoBox((InfoBox)rem));
        this.itemMap.clear();
        this.regexes = (Pattern[])Text.fromCSV((String)this.config.itemList()).stream().map(n -> Pattern.compile(n, 2)).toArray(Pattern[]::new);
        this.update();
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        ItemContainer inv = this.client.getItemContainer(InventoryID.INVENTORY);
        ItemContainer eqp = this.client.getItemContainer(InventoryID.EQUIPMENT);
        if (event.getItemContainer() == inv || event.getItemContainer() == eqp) {
            this.checkInventory(ItemCounterPlugin.flattenItemArrayParams(inv.getItems(), eqp.getItems()));
        }
    }

    public void update() {
        Item[] eqpItems;
        ItemContainer inv = this.client.getItemContainer(InventoryID.INVENTORY);
        ItemContainer eqp = this.client.getItemContainer(InventoryID.EQUIPMENT);
        Item[] invItems = inv == null ? new Item[]{} : inv.getItems();
        Item[] itemArray = eqpItems = eqp == null ? new Item[]{} : eqp.getItems();
        if (inv != null && eqp != null) {
            this.clientThread.invokeLater(() -> this.checkInventory(ItemCounterPlugin.flattenItemArrayParams(invItems, eqpItems)));
        }
    }

    private void checkInventory(Item[] invItems) {
        for (Pattern regex : this.regexes) {
            int running_total = 0;
            for (Item item : invItems) {
                int itemId = item.getId();
                String itemName = this.itemManager.getItemComposition(itemId).getName();
                if (!regex.matcher(itemName).matches()) continue;
                running_total += this.config.countQuantity() ? item.getQuantity() : 1;
                ItemCounter counter = this.itemMap.getOrDefault(regex.pattern(), null);
                if (counter != null) continue;
                counter = new ItemCounter((BufferedImage)this.itemManager.getImage(itemId), itemId, regex.pattern(), running_total, this, this.config.formatAsOsrsNumber());
                this.infoBoxManager.addInfoBox((InfoBox)counter);
                this.itemMap.put(regex.pattern(), counter);
            }
            ItemCounter counter = this.itemMap.getOrDefault(regex.pattern(), null);
            if (counter == null) continue;
            counter.setCount(running_total);
        }
    }

    public static Item[] flattenItemArrayParams(Item[] ... stuff) {
        return ItemCounterPlugin.flattenItemArrays(stuff);
    }

    public static Item[] flattenItemArrays(Item[][] itemSets) {
        int total_len = 0;
        for (Item[] itemSet : itemSets) {
            if (itemSet == null) continue;
            total_len += itemSet.length;
        }
        Item[] result = new Item[total_len];
        int overall_idx = 0;
        for (Item[] itemSet : itemSets) {
            if (itemSet == null) continue;
            for (int i = 0; i < itemSet.length; ++i) {
                result[overall_idx++] = itemSet[i];
            }
        }
        return result;
    }

    @Provides
    ItemCounterConfig provideConfig(ConfigManager configManager) {
        return (ItemCounterConfig)configManager.getConfig(ItemCounterConfig.class);
    }
}

