/*
 * Decompiled with CFR 0.152.
 */
package cc.jambox;

import java.awt.image.BufferedImage;
import java.text.NumberFormat;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.infobox.Counter;
import net.runelite.client.util.QuantityFormatter;

public class ItemCounter
extends Counter {
    private final int itemID;
    private final String name;
    private final boolean formatStackAsOsrs;

    ItemCounter(BufferedImage image, int itemID, String name, int count, Plugin plugin, boolean formatStackAsOsrs) {
        super(image, plugin, count);
        this.itemID = itemID;
        this.name = name;
        this.formatStackAsOsrs = formatStackAsOsrs;
    }

    public String getText() {
        return this.formatStackAsOsrs ? QuantityFormatter.quantityToRSDecimalStack((int)this.getCount()) : NumberFormat.getIntegerInstance().format(this.getCount());
    }

    public String getTooltip() {
        return this.name + ": " + this.getCount();
    }

    public int getItemID() {
        return this.itemID;
    }
}

