/*
 * Decompiled with CFR 0.152.
 */
package com.speshkitty.giantsfoundryitemvalues;

import com.google.inject.Provides;
import com.speshkitty.giantsfoundryitemvalues.ItemBarValuesConfig;
import com.speshkitty.giantsfoundryitemvalues.ItemBarValuesOverlay;
import java.awt.Point;
import java.awt.Rectangle;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Giant's Foundry Gear Values")
public class ItemBarValuesPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ItemBarValuesPlugin.class);
    private Rectangle giantsFoundryArea = new Rectangle(3354, 11478, 24, 25);
    @Inject
    private Client client;
    @Inject
    private ItemBarValuesConfig config;
    @Inject
    private ItemBarValuesOverlay overlay;
    @Inject
    private OverlayManager overlayManager;

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.overlay);
        log.info("Giant Foundry Bar Value started!");
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
        log.info("Giant Foundry Bar Value stopped!");
    }

    protected Logger getLogger() {
        return log;
    }

    protected boolean ShouldDrawInfo() {
        if (this.TileIsInFoundry(this.client.getLocalPlayer().getWorldLocation()) && this.config.showInGF()) {
            return true;
        }
        return this.config.showEverywhere();
    }

    private boolean TileIsInFoundry(WorldPoint tile) {
        return this.giantsFoundryArea.contains(new Point(tile.getX(), tile.getY()));
    }

    @Provides
    ItemBarValuesConfig provideConfig(ConfigManager configManager) {
        return (ItemBarValuesConfig)configManager.getConfig(ItemBarValuesConfig.class);
    }
}

