/*
 * Decompiled with CFR 0.152.
 */
package net.wiseoldman.web;

import com.google.gson.Gson;
import java.awt.Color;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.MessageNode;
import net.runelite.api.events.ChatMessage;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.eventbus.EventBus;
import net.wiseoldman.WomUtilsConfig;
import net.wiseoldman.WomUtilsPlugin;
import net.wiseoldman.beans.GroupInfoWithMemberships;
import net.wiseoldman.beans.GroupMemberAddition;
import net.wiseoldman.beans.GroupMemberRemoval;
import net.wiseoldman.beans.Member;
import net.wiseoldman.beans.NameChangeEntry;
import net.wiseoldman.beans.ParticipantWithCompetition;
import net.wiseoldman.beans.ParticipantWithStanding;
import net.wiseoldman.beans.PlayerInfo;
import net.wiseoldman.beans.WomPlayerUpdate;
import net.wiseoldman.beans.WomStatus;
import net.wiseoldman.events.WomGroupMemberAdded;
import net.wiseoldman.events.WomGroupMemberRemoved;
import net.wiseoldman.events.WomGroupSynced;
import net.wiseoldman.events.WomOngoingPlayerCompetitionsFetched;
import net.wiseoldman.events.WomUpcomingPlayerCompetitionsFetched;
import net.wiseoldman.ui.WomIconHandler;
import net.wiseoldman.web.HttpMethod;
import net.wiseoldman.web.WomCallback;
import net.wiseoldman.web.WomCommand;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WomClient {
    private static final Logger log = LoggerFactory.getLogger(WomClient.class);
    @Inject
    private OkHttpClient okHttpClient;
    private Gson gson;
    @Inject
    private WomIconHandler iconHandler;
    @Inject
    private Client client;
    @Inject
    private WomUtilsConfig config;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private ClientThread clientThread;
    @Inject
    private EventBus eventBus;
    private static final Color SUCCESS = new Color(170, 255, 40);
    private static final Color ERROR = new Color(204, 66, 66);
    private static final DecimalFormat NUMBER_FORMAT = new DecimalFormat("#.##");
    private final WomUtilsPlugin plugin;
    private final String leagueError = " You are currently in a League world. Your group configurations might be for the main game.";

    @Inject
    public WomClient(Gson gson, WomUtilsPlugin plugin) {
        this.gson = gson.newBuilder().setDateFormat(0, 0).create();
        this.plugin = plugin;
    }

    public void submitNameChanges(NameChangeEntry[] changes) {
        Request request = this.createRequest((Object)changes, HttpMethod.POST, "names", "bulk");
        this.sendRequest(request);
        log.info("Submitted {} name changes to WOM", (Object)changes.length);
    }

    void sendRequest(Request request) {
        this.sendRequest(request, (Response r) -> {});
    }

    void sendRequest(Request request, Consumer<Response> consumer) {
        this.sendRequest(request, new WomCallback(consumer));
    }

    void sendRequest(Request request, Consumer<Response> consumer, Consumer<Exception> exceptionConsumer) {
        this.sendRequest(request, new WomCallback(consumer, exceptionConsumer));
    }

    void sendRequest(Request request, Callback callback) {
        this.okHttpClient.newCall(request).enqueue(callback);
    }

    private Request createRequest(Object payload, String ... pathSegments) {
        return this.createRequest(payload, HttpMethod.POST, pathSegments);
    }

    private Request createRequest(Object payload, HttpMethod httpMethod, String ... pathSegments) {
        HttpUrl url = this.buildUrl(pathSegments);
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)this.gson.toJson(payload));
        Request.Builder requestBuilder = new Request.Builder().header("User-Agent", "WiseOldMan RuneLite Plugin").url(url);
        if (httpMethod == HttpMethod.PUT) {
            return requestBuilder.put(body).build();
        }
        if (httpMethod == HttpMethod.DELETE) {
            return requestBuilder.delete(body).build();
        }
        return requestBuilder.post(body).build();
    }

    private Request createRequest(String ... pathSegments) {
        HttpUrl url = this.buildUrl(pathSegments);
        return new Request.Builder().header("User-Agent", "WiseOldMan RuneLite Plugin").url(url).build();
    }

    private HttpUrl buildUrl(String[] pathSegments) {
        HttpUrl.Builder urlBuilder = new HttpUrl.Builder().scheme("https").host("api.wiseoldman.net").addPathSegment(this.plugin.isSeasonal ? "league" : "v2");
        for (String pathSegment : pathSegments) {
            if (pathSegment.startsWith("?")) {
                String[] kv = pathSegment.substring(1).split("=");
                urlBuilder.addQueryParameter(kv[0], kv[1]);
                continue;
            }
            urlBuilder.addPathSegment(pathSegment);
        }
        return urlBuilder.build();
    }

    public void importGroupMembers() {
        if (this.config.groupId() > 0) {
            Request request = this.createRequest("groups", "" + this.config.groupId());
            this.sendRequest(request, this::importMembersCallback);
        }
    }

    private void importMembersCallback(Response response) {
        if (!response.isSuccessful()) {
            return;
        }
        GroupInfoWithMemberships groupInfo = this.parseResponse(response, GroupInfoWithMemberships.class);
        this.postEvent(new WomGroupSynced(groupInfo, true));
    }

    private void syncClanMembersCallBack(Response response) {
        if (response.isSuccessful()) {
            GroupInfoWithMemberships data = this.parseResponse(response, GroupInfoWithMemberships.class);
            this.postEvent(new WomGroupSynced(data));
        } else {
            WomStatus data = this.parseResponse(response, WomStatus.class);
            String message = "Error: " + data.getMessage() + (this.plugin.isSeasonal ? " You are currently in a League world. Your group configurations might be for the main game." : "");
            this.sendResponseToChat(message, ERROR);
        }
    }

    private void removeMemberCallback(Response response, String username) {
        WomStatus data = this.parseResponse(response, WomStatus.class);
        if (response.isSuccessful()) {
            this.postEvent(new WomGroupMemberRemoved(username));
        } else {
            String message = "Error: " + data.getMessage() + (this.plugin.isSeasonal ? " You are currently in a League world. Your group configurations might be for the main game." : "");
            this.sendResponseToChat(message, ERROR);
        }
    }

    private void addMemberCallback(Response response, String username) {
        if (response.isSuccessful()) {
            this.postEvent(new WomGroupMemberAdded(username));
        } else {
            WomStatus data = this.parseResponse(response, WomStatus.class);
            String message = "Error: " + data.getMessage() + (this.plugin.isSeasonal ? " You are currently in a League world. Your group configurations might be for the main game." : "");
            this.sendResponseToChat(message, ERROR);
        }
    }

    private void playerOngoingCompetitionsCallback(String username, Response response) {
        if (response.isSuccessful()) {
            ParticipantWithStanding[] comps = this.parseResponse(response, ParticipantWithStanding[].class);
            this.postEvent(new WomOngoingPlayerCompetitionsFetched(username, comps));
        } else {
            WomStatus data = this.parseResponse(response, WomStatus.class);
            String message = "Error: " + data.getMessage();
            this.sendResponseToChat(message, ERROR);
        }
    }

    private void playerUpcomingCompetitionsCallback(String username, Response response) {
        if (response.isSuccessful()) {
            ParticipantWithCompetition[] comps = this.parseResponse(response, ParticipantWithCompetition[].class);
            this.postEvent(new WomUpcomingPlayerCompetitionsFetched(username, comps));
        } else {
            WomStatus data = this.parseResponse(response, WomStatus.class);
            String message = "Error: " + data.getMessage();
            this.sendResponseToChat(message, ERROR);
        }
    }

    private <T> T parseResponse(Response r, Class<T> clazz) {
        return this.parseResponse(r, clazz, false);
    }

    private <T> T parseResponse(Response r, Class<T> clazz, boolean nullIferror) {
        String body;
        if (nullIferror && !r.isSuccessful()) {
            return null;
        }
        try {
            body = r.body().string();
        }
        catch (IOException e) {
            log.error("Could not read response {}", (Object)e.getMessage());
            return null;
        }
        return (T)this.gson.fromJson(body, clazz);
    }

    private void sendResponseToChat(String message, Color color) {
        ChatMessageBuilder cmb = new ChatMessageBuilder();
        cmb.append("[WOM] ");
        cmb.append(color, message);
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(cmb.build()).build());
    }

    public void syncClanMembers(ArrayList<Member> clanMembers) {
        GroupMemberAddition payload = new GroupMemberAddition(this.config.verificationCode(), clanMembers);
        Request request = this.createRequest((Object)payload, HttpMethod.PUT, "groups", "" + this.config.groupId());
        this.sendRequest(request, this::syncClanMembersCallBack);
    }

    public void addGroupMember(String username) {
        ArrayList<Member> memberToAdd = new ArrayList<Member>();
        memberToAdd.add(new Member(username.toLowerCase(), "member"));
        GroupMemberAddition payload = new GroupMemberAddition(this.config.verificationCode(), memberToAdd);
        Request request = this.createRequest((Object)payload, "groups", "" + this.config.groupId(), "members");
        this.sendRequest(request, (Response r) -> this.addMemberCallback((Response)r, username));
    }

    public void removeGroupMember(String username) {
        GroupMemberRemoval payload = new GroupMemberRemoval(this.config.verificationCode(), new String[]{username.toLowerCase()});
        Request request = this.createRequest((Object)payload, HttpMethod.DELETE, "groups", "" + this.config.groupId(), "members");
        this.sendRequest(request, (Response r) -> this.removeMemberCallback((Response)r, username));
    }

    public void commandLookup(String username, WomCommand command, ChatMessage chatMessage) {
        Request request = this.createRequest("players", username);
        this.sendRequest(request, (Response r) -> this.commandCallback((Response)r, command, chatMessage));
    }

    private void commandCallback(Response response, WomCommand command, ChatMessage chatMessage) {
        double time;
        if (!response.isSuccessful()) {
            return;
        }
        PlayerInfo info = this.parseResponse(response, PlayerInfo.class);
        try {
            String cmd = command.getCommand();
            time = cmd.equals("!ehp") ? info.getEhp() : (cmd.equals("!ehb") ? info.getEhb() : (cmd.equals("!ttm") ? info.getTtm() : info.getTt200m()));
        }
        catch (Throwable e) {
            log.warn("{}", (Object)e.getMessage());
            return;
        }
        String value = NUMBER_FORMAT.format(time);
        String message = new ChatMessageBuilder().append(ChatColorType.NORMAL).append(command.getMessage()).append(ChatColorType.HIGHLIGHT).append(value).append(".").build();
        MessageNode messageNode = chatMessage.getMessageNode();
        messageNode.setRuneLiteFormatMessage(message);
        this.client.refreshChat();
    }

    private void postEvent(Object event) {
        this.clientThread.invokeLater(() -> this.eventBus.post(event));
    }

    public void fetchUpcomingPlayerCompetitions(String username) {
        Request request = this.createRequest("players", username, "competitions", "?status=upcoming");
        this.sendRequest(request, (Response r) -> this.playerUpcomingCompetitionsCallback(username, (Response)r));
    }

    public void fetchOngoingPlayerCompetitions(String username) {
        Request request = this.createRequest("players", username, "competitions", "standings", "?status=ongoing");
        this.sendRequest(request, (Response r) -> this.playerOngoingCompetitionsCallback(username, (Response)r));
    }

    public void updatePlayer(String username, long accountHash) {
        Request request = this.createRequest((Object)new WomPlayerUpdate(accountHash), "players", username);
        this.sendRequest(request);
    }

    public CompletableFuture<PlayerInfo> lookupAsync(String username) {
        CompletableFuture<PlayerInfo> future = new CompletableFuture<PlayerInfo>();
        Request request = this.createRequest("players", username);
        this.sendRequest(request, r -> future.complete(this.parseResponse((Response)r, (Class)PlayerInfo.class, true)), future::completeExceptionally);
        return future;
    }

    public CompletableFuture<PlayerInfo> updateAsync(String username) {
        CompletableFuture<PlayerInfo> future = new CompletableFuture<PlayerInfo>();
        Request request = this.createRequest(new Object(), "players", username);
        this.sendRequest(request, r -> future.complete(this.parseResponse((Response)r, (Class)PlayerInfo.class, true)), future::completeExceptionally);
        return future;
    }
}

