/*
 * Decompiled with CFR 0.152.
 */
package net.wiseoldman.web;

import java.io.IOException;
import java.util.function.Consumer;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WomCallback
implements Callback {
    private static final Logger log = LoggerFactory.getLogger(WomCallback.class);
    private final Consumer<Response> responseConsumer;
    private Consumer<Exception> failureConsumer;

    public void onFailure(Call call, IOException e) {
        if (this.failureConsumer == null) {
            log.warn("Error submitting request, caused by {}.", (Object)e.getMessage());
        } else {
            this.failureConsumer.accept(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onResponse(Call call, Response response) {
        try {
            this.responseConsumer.accept(response);
        }
        catch (Throwable e) {
            log.warn("Error when handling response, caused by {}.", (Object)e.getMessage());
        }
        finally {
            response.close();
        }
    }

    public WomCallback(Consumer<Response> responseConsumer) {
        this.responseConsumer = responseConsumer;
    }

    public WomCallback(Consumer<Response> responseConsumer, Consumer<Exception> failureConsumer) {
        this.responseConsumer = responseConsumer;
        this.failureConsumer = failureConsumer;
    }
}

