/*
 * Decompiled with CFR 0.152.
 */
package net.wiseoldman.util;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import net.runelite.client.util.QuantityFormatter;

public class Format {
    public static String formatNumber(long num) {
        if (num < 10000L && num > -10000L) {
            return QuantityFormatter.formatNumber((long)num);
        }
        DecimalFormat df = new DecimalFormat();
        df.setGroupingUsed(false);
        df.setRoundingMode(RoundingMode.FLOOR);
        df.setMaximumFractionDigits(2);
        if (num < 10000000L && num > -10000000L) {
            df.setMaximumFractionDigits(0);
            return df.format((double)num / 1000.0) + "k";
        }
        if (num < 1000000000L && num > -1000000000L) {
            return df.format((double)num / 1000000.0) + "m";
        }
        return df.format((double)num / 1.0E9) + "b";
    }

    public static String formatNumber(double num) {
        if (num < 10000.0 && num > -10000.0) {
            return String.format("%.0f", num);
        }
        DecimalFormat df = new DecimalFormat();
        df.setRoundingMode(RoundingMode.FLOOR);
        df.setMaximumFractionDigits(2);
        return df.format(num / 1000.0) + "k";
    }

    public static String formatDate(String date, boolean relative) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd MMM yyyy, HH:mm");
        ZoneId localZone = ZoneId.systemDefault();
        ZonedDateTime updatedAt = Instant.parse(date).atZone(localZone);
        if (relative) {
            Object lastUpdated = "";
            ZonedDateTime now = Instant.now().atZone(localZone);
            long difference = Duration.between(updatedAt, now).toHours();
            if (difference == 0L) {
                return "less than 1 hour ago";
            }
            long days = difference / 24L;
            long hours = difference % 24L;
            String dayUnit = days > 1L ? " days, " : " day, ";
            String hourUnit = hours > 1L ? " hours ago" : " hour ago";
            lastUpdated = (String)lastUpdated + (String)(days > 0L ? days + dayUnit : "");
            lastUpdated = (String)lastUpdated + (String)(hours > 0L ? hours + hourUnit : "");
            return lastUpdated;
        }
        return formatter.format(updatedAt);
    }
}

