/*
 * Decompiled with CFR 0.152.
 */
package net.wiseoldman.ui;

import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.IndexedSprite;
import net.runelite.api.events.ScriptCallbackEvent;
import net.runelite.api.widgets.Widget;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.Text;
import net.wiseoldman.WomUtilsConfig;
import net.wiseoldman.beans.GroupMembership;
import net.wiseoldman.ui.CountryIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class WomIconHandler {
    private static final Logger log = LoggerFactory.getLogger(WomIconHandler.class);
    private static final int CLAN_SETTINGS_MEMBERS_WIDGET = 45416458;
    private final Client client;
    private final ClientThread clientThread;
    private final WomUtilsConfig config;
    private int modIconsStart = -1;
    private String currentLayouting;

    @Inject
    WomIconHandler(Client client, ClientThread clientThread, WomUtilsConfig config) {
        this.client = client;
        this.clientThread = clientThread;
        this.config = config;
    }

    private boolean loadCountryIcons() {
        IndexedSprite[] modIcons = this.client.getModIcons();
        if (this.modIconsStart != -1 || modIcons == null) {
            return false;
        }
        CountryIcon[] countryIcons = CountryIcon.values();
        IndexedSprite[] newModIcons = Arrays.copyOf(modIcons, modIcons.length + countryIcons.length);
        this.modIconsStart = modIcons.length;
        for (int i = 0; i < countryIcons.length; ++i) {
            IndexedSprite sprite;
            CountryIcon icon = countryIcons[i];
            BufferedImage image = icon.loadImage();
            newModIcons[this.modIconsStart + i] = sprite = ImageUtil.getImageIndexedSprite((BufferedImage)image, (Client)this.client);
        }
        this.client.setModIcons(newModIcons);
        return true;
    }

    public boolean iconsAreLoaded() {
        return this.modIconsStart != -1;
    }

    public void loadIcons() {
        this.clientThread.invokeLater(this::loadCountryIcons);
    }

    public void handleScriptEvent(ScriptCallbackEvent event, Map<String, GroupMembership> groupMembers) {
        switch (event.getEventName()) {
            case "friendsChatSetText": {
                String sanitized;
                String[] stringStack = this.client.getStringStack();
                int stringStackSize = this.client.getStringStackSize();
                String rsn = stringStack[stringStackSize - 1];
                this.currentLayouting = sanitized = Text.toJagexName((String)Text.removeTags((String)rsn).toLowerCase());
                GroupMembership member = groupMembers.get(sanitized);
                if (member == null) break;
                String country = member.getPlayer().getCountry() != null && this.config.showFlags() ? member.getPlayer().getCountry().toLowerCase() : "default";
                CountryIcon icon = CountryIcon.getIcon(country);
                int iconIdx = this.modIconsStart + icon.ordinal();
                stringStack[stringStackSize - 1] = rsn + " <img=" + iconIdx + ">";
                break;
            }
            case "friendsChatSetPosition": {
                if (this.currentLayouting == null || !groupMembers.containsKey(this.currentLayouting)) {
                    return;
                }
                int[] intStack = this.client.getIntStack();
                int intStackSize = this.client.getIntStackSize();
                int xpos = intStack[intStackSize - 4];
                intStack[intStackSize - 4] = xpos += 13;
            }
        }
    }

    public void rebuildMemberList(boolean disable, Map<String, GroupMembership> groupMembers, int componentId) {
        Widget containerWidget = this.client.getWidget(componentId);
        if (containerWidget == null) {
            return;
        }
        Widget[] children = containerWidget.getChildren();
        if (children == null) {
            return;
        }
        for (int i = 0; i < children.length; ++i) {
            if (children[i].getFontId() == -1 || children[i].getXTextAlignment() != 0) continue;
            String name = Text.removeTags((String)children[i].getText());
            String sanitized = Text.toJagexName((String)name);
            GroupMembership member = groupMembers.get(sanitized.toLowerCase());
            if (!disable && member != null) {
                String country = member.getPlayer().getCountry() != null && this.config.showFlags() ? member.getPlayer().getCountry().toLowerCase() : "default";
                CountryIcon icon = CountryIcon.getIcon(country);
                int iconIdx = this.modIconsStart + icon.ordinal();
                String spacer = name.charAt(name.length() - 1) != ' ' ? " " : "";
                String newName = name + spacer + "<img=" + iconIdx + ">";
                children[i].setText(newName);
                continue;
            }
            children[i].setText(name);
        }
    }

    public void rebuildSettingsMemberList(boolean disable, Map<String, GroupMembership> groupMembers) {
        Widget containerWidget = this.client.getWidget(45416458);
        if (containerWidget == null) {
            return;
        }
        Widget[] children = containerWidget.getChildren();
        if (children == null) {
            return;
        }
        for (int i = 1; i < children.length; i += 3) {
            String oldText;
            String name = Text.removeTags((String)children[i].getText());
            String sanitized = Text.toJagexName((String)name);
            GroupMembership member = groupMembers.get(sanitized.toLowerCase());
            if (!disable && member != null) {
                oldText = children[i].getText();
                String country = member.getPlayer().getCountry() != null && this.config.showFlags() ? member.getPlayer().getCountry().toLowerCase() : "default";
                CountryIcon icon = CountryIcon.getIcon(country);
                int iconIdx = this.modIconsStart + icon.ordinal();
                String spacer = name.charAt(name.length() - 1) != ' ' ? " " : "";
                String newName = name + spacer + "<img=" + iconIdx + ">";
                children[i].setText(newName);
                if (oldText.contains("<img")) continue;
                Widget rankIcon = children[i + 1];
                rankIcon.setOriginalX(rankIcon.getOriginalX() - 6);
                rankIcon.revalidate();
                continue;
            }
            oldText = children[i].getText();
            if (oldText.contains("<img")) {
                Widget rankIcon = children[i + 1];
                rankIcon.setOriginalX(rankIcon.getOriginalX() + 6);
                rankIcon.revalidate();
            }
            children[i].setText(name);
        }
    }

    public void rebuildLists(Map<String, GroupMembership> members, boolean showIcons) {
        this.clientThread.invokeLater(() -> {
            this.rebuildFriendsList();
            this.rebuildMemberList(!showIcons, members, 458764);
            this.rebuildMemberList(!showIcons, members, 45940742);
            this.rebuildMemberList(!showIcons, members, 46006278);
        });
    }

    private void rebuildFriendsList() {
        this.client.runScript(new Object[]{631, 28114949, 28114951, 28114952, 28114953, 28114954, 28114955, 28114956, 28114957, 28114962});
    }
}

