/*
 * Decompiled with CFR 0.152.
 */
package net.wiseoldman.ui;

import com.google.common.util.concurrent.Runnables;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.Client;
import net.runelite.api.clan.ClanMember;
import net.runelite.api.clan.ClanSettings;
import net.runelite.api.clan.ClanTitle;
import net.runelite.api.widgets.Widget;
import net.runelite.client.game.chatbox.ChatboxPanelManager;
import net.runelite.client.util.Text;
import net.wiseoldman.beans.GroupMembership;
import net.wiseoldman.beans.Member;
import net.wiseoldman.web.WomClient;

public class SyncButton {
    private final Client client;
    private final WomClient womClient;
    private final ChatboxPanelManager chatboxPanelManager;
    private final Widget parent;
    private final List<Widget> cornersAndEdges = new ArrayList<Widget>();
    private final ClanSettings clanSettings;
    private final Map<String, GroupMembership> groupMembers;
    private final List<String> ignoredRanks;
    private final List<String> alwaysIncludedOnSync;
    private Widget textWidget;

    public SyncButton(Client client, WomClient womClient, ChatboxPanelManager chatboxPanelManager, int parent, Map<String, GroupMembership> groupMembers, List<String> ignoredRanks, List<String> alwaysIncludedOnSync) {
        this.client = client;
        this.womClient = womClient;
        this.chatboxPanelManager = chatboxPanelManager;
        this.parent = client.getWidget(parent);
        this.clanSettings = client.getClanSettings();
        this.groupMembers = groupMembers;
        this.ignoredRanks = ignoredRanks;
        this.alwaysIncludedOnSync = alwaysIncludedOnSync;
        this.createWidgetWithSprite(913, 6, 6, 9, 9);
        this.createWidgetWithSprite(914, 97, 6, 9, 9);
        this.createWidgetWithSprite(915, 6, 20, 9, 9);
        this.createWidgetWithSprite(916, 97, 20, 9, 9);
        this.createWidgetWithSprite(917, 6, 15, 9, 5);
        this.createWidgetWithSprite(918, 15, 6, 82, 9);
        this.createWidgetWithSprite(919, 97, 15, 9, 5);
        this.createWidgetWithSprite(920, 15, 20, 82, 9);
        this.textWidget = this.createWidgetWithText();
    }

    private void createWidgetWithSprite(int spriteId, int x, int y, int width, int height) {
        Widget w = this.parent.createChild(-1, 5);
        w.setSpriteId(spriteId);
        w.setOriginalX(x);
        w.setOriginalY(y);
        w.setOriginalWidth(width);
        w.setOriginalHeight(height);
        w.setXPositionMode(0);
        w.setYPositionMode(0);
        w.revalidate();
        this.cornersAndEdges.add(w);
    }

    private Widget createWidgetWithText() {
        Widget textWidget = this.parent.createChild(-1, 4);
        textWidget.setOriginalX(6);
        textWidget.setOriginalY(6);
        textWidget.setOriginalWidth(100);
        textWidget.setOriginalHeight(23);
        textWidget.setXPositionMode(0);
        textWidget.setYPositionMode(0);
        textWidget.setXTextAlignment(1);
        textWidget.setYTextAlignment(1);
        textWidget.setText("<col=9f9f9f>Sync WOM Group</col>");
        textWidget.setFontId(494);
        textWidget.setTextShadowed(true);
        textWidget.setHasListener(true);
        textWidget.setAction(0, "Sync WOM Group");
        textWidget.setOnMouseOverListener(new Object[]{e -> this.update(true)});
        textWidget.setOnMouseLeaveListener(new Object[]{e -> this.update(false)});
        textWidget.revalidate();
        return textWidget;
    }

    private void update(boolean hovered) {
        for (Widget w : this.cornersAndEdges) {
            int spriteId = w.getSpriteId();
            w.setSpriteId(hovered ? spriteId + 8 : spriteId - 8);
            w.revalidate();
        }
    }

    private void syncMembers() {
        this.syncMembers(true);
    }

    private void syncMembers(boolean overwrite) {
        HashMap<String, Member> clanMembers = new HashMap<String, Member>();
        if (!overwrite) {
            this.groupMembers.forEach((k, v) -> clanMembers.put((String)k, new Member(v.getPlayer().getDisplayName(), v.getRole())));
        }
        for (ClanMember clanMember : this.clanSettings.getMembers()) {
            String role;
            if (clanMember.getName().startsWith("[#")) continue;
            String memberName = Text.toJagexName((String)clanMember.getName());
            ClanTitle memberTitle = this.clanSettings.titleForRank(clanMember.getRank());
            String string = role = memberTitle == null ? "member" : memberTitle.getName().toLowerCase().replaceAll("[-\\s]", "_");
            if (this.ignoredRanks.contains(role)) continue;
            clanMembers.put(memberName.toLowerCase(), new Member(memberName, role));
        }
        for (String name : this.alwaysIncludedOnSync) {
            String nameLower = name.toLowerCase();
            if (clanMembers.containsKey(nameLower)) continue;
            clanMembers.put(nameLower, new Member(name, "member"));
        }
        this.womClient.syncClanMembers(new ArrayList<Member>(clanMembers.values()));
    }

    public void setEnabled() {
        this.textWidget.setText("<col=ffffff>Sync WOM Group</col>");
        this.textWidget.setOnOpListener(new Object[]{e -> this.chatboxPanelManager.openTextMenuInput("Any members not in your clan will be removed<br>from your WOM group. Proceed?").option("1. Yes, overwrite WOM group", this::syncMembers).option("2. No, only add new members", () -> this.syncMembers(false)).option("3. Cancel", Runnables.doNothing()).build()});
    }
}

