/*
 * Decompiled with CFR 0.152.
 */
package net.wiseoldman.ui;

import java.awt.Color;
import java.text.DecimalFormat;
import java.time.Duration;
import net.runelite.api.MenuAction;
import net.runelite.client.hiscore.HiscoreSkillType;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.util.ColorUtil;
import net.wiseoldman.WomUtilsPlugin;
import net.wiseoldman.beans.Competition;
import net.wiseoldman.beans.CompetitionProgress;
import net.wiseoldman.beans.Metric;
import net.wiseoldman.beans.ParticipantWithStanding;
import net.wiseoldman.util.Utils;
import org.apache.commons.lang3.time.DurationFormatUtils;

public class CompetitionInfobox
extends InfoBox {
    final Competition competition;
    final WomUtilsPlugin plugin;
    final int rank;
    final CompetitionProgress progress;
    private static final Color ACTIVE_COLOR = new Color(5371202);

    public CompetitionInfobox(Competition competition, WomUtilsPlugin plugin) {
        super(competition.getMetric().loadImage(), (Plugin)plugin);
        this.competition = competition;
        this.rank = -1;
        this.progress = null;
        this.plugin = plugin;
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_INFOBOX, "Show all competitions", "Wise Old Man"));
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_INFOBOX, "Hide competition", competition.getTitle()));
    }

    public CompetitionInfobox(ParticipantWithStanding pws, WomUtilsPlugin plugin) {
        super(pws.getCompetition().getMetric().loadImage(), (Plugin)plugin);
        this.competition = pws.getCompetition();
        this.rank = pws.getRank();
        this.progress = pws.getProgress();
        this.plugin = plugin;
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_INFOBOX, "Show all competitions", "Wise Old Man"));
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_INFOBOX, "Hide competition", this.competition.getTitle()));
    }

    public String getTooltip() {
        Metric metric = this.competition.getMetric();
        StringBuilder sb = new StringBuilder();
        sb.append(this.competition.getTitle()).append("</br>").append("Metric: ").append(metric.getName()).append("</br>").append(this.competition.getTimeStatus());
        if (this.progress != null) {
            sb.append("</br>");
            double gained = this.progress.getGained();
            if (gained > 0.0) {
                String coloredRank = ColorUtil.wrapWithColorTag((String)Utils.ordinalOf(this.rank), (Color)Color.GREEN);
                sb.append("Ranked: ").append(coloredRank);
                DecimalFormat df = metric == Metric.EHB || metric == Metric.EHP ? new DecimalFormat("####.##") : new DecimalFormat("###,###,###");
                String formattedProgress = df.format(gained);
                String coloredProgress = ColorUtil.wrapWithColorTag((String)formattedProgress, (Color)Color.GREEN);
                sb.append(" (Gained ").append(coloredProgress);
                switch (metric) {
                    case EHB: 
                    case EHP: {
                        sb.append(" hours");
                        break;
                    }
                    default: {
                        sb.append(this.getUnitForType(metric.getType()));
                    }
                }
                sb.append(")");
            }
        }
        return sb.toString();
    }

    private String getUnitForType(HiscoreSkillType type) {
        if (type == null) {
            return "";
        }
        switch (type) {
            case SKILL: {
                return " xp";
            }
            case BOSS: {
                return " kills";
            }
            case ACTIVITY: {
                return " points";
            }
        }
        return "";
    }

    public Color getTextColor() {
        return this.competition.isActive() ? ACTIVE_COLOR : Color.YELLOW;
    }

    public String getText() {
        Duration timeLeft = this.competition.durationLeft();
        if (timeLeft.toDays() > 9L) {
            return DurationFormatUtils.formatDuration((long)timeLeft.toMillis(), (String)"d'd'");
        }
        if (timeLeft.toDays() > 0L) {
            return DurationFormatUtils.formatDuration((long)timeLeft.toMillis(), (String)"d'd'H'h'");
        }
        if (timeLeft.toHours() > 0L) {
            return DurationFormatUtils.formatDuration((long)timeLeft.toMillis(), (String)"H'h'm'm'");
        }
        return DurationFormatUtils.formatDuration((long)timeLeft.toMillis(), (String)"mm:ss");
    }

    public boolean render() {
        return this.shouldShow() && !this.isHidden();
    }

    public boolean cull() {
        return this.competition.hasEnded();
    }

    public boolean shouldShow() {
        return this.plugin.isShowTimerOngoing() && this.competition.isActive() || this.plugin.isShowTimerUpcoming() && !this.competition.hasStarted() && this.competition.durationLeft().toDays() <= (long)this.plugin.getUpcomingInfoboxesMaxDays();
    }

    public boolean isHidden() {
        return this.plugin.getHiddenCompetitions().contains(this.competition.getId());
    }

    public int getLinkedCompetitionId() {
        return this.competition.getId();
    }
}

