/*
 * Decompiled with CFR 0.152.
 */
package net.wiseoldman.ui;

import com.google.common.base.Strings;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import javax.inject.Inject;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;
import net.wiseoldman.WomUtilsConfig;
import net.wiseoldman.WomUtilsPlugin;

public class CodeWordOverlay
extends OverlayPanel {
    private final WomUtilsConfig config;
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm 'UTC'").withZone(ZoneOffset.UTC);

    @Inject
    private CodeWordOverlay(WomUtilsPlugin plugin, WomUtilsConfig config) {
        super((Plugin)plugin);
        this.setPosition(OverlayPosition.ABOVE_CHATBOX_RIGHT);
        this.setPriority(OverlayPriority.LOW);
        this.config = config;
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.config.displayCodeword() || Strings.isNullOrEmpty((String)this.config.configuredCodeword())) {
            return null;
        }
        if (this.config.showTimestamp()) {
            this.panelComponent.getChildren().add(LineComponent.builder().left(this.config.configuredCodeword()).leftColor(this.config.codewordColor()).right(FORMATTER.format(Instant.now())).rightColor(this.config.timestampColor()).build());
        } else {
            this.panelComponent.getChildren().add(TitleComponent.builder().text(this.config.configuredCodeword()).color(this.config.codewordColor()).build());
        }
        return super.render(graphics);
    }
}

